/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.statistical.ui.widgets.internal.GData;
import org.eclipse.hyades.trace.ui.internal.util.MonitorSelectionDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class PerfmonMainTab
extends AbstractLaunchConfigurationTab
implements ILaunchConfigurationTab,
SelectionListener,
KeyListener {
    ILaunchConfigurationDialog dialog;
    boolean isdirty = false;
    String message = null;
    String error_message = null;
    Composite mainpanel;
    Composite host_panel;
    Label rac_host_label;
    Text rac_host_text;
    Button reg_host_same;
    Text reg_host_text;
    Composite container_panel;
    Label container_label;
    Text container_text;
    Button container_browse;
    Composite monitor_panel;
    Label monitor_label;
    Text monitor_text;
    Button monitor_browse;

    public void setMessage(String string) {
        this.message = string;
        if (this.message.length() == 0) {
            this.message = null;
        }
        this.updateLaunchConfigurationDialog();
    }

    public void setError(String string) {
        this.error_message = string;
        if (this.error_message.length() == 0) {
            this.error_message = null;
        }
        this.updateLaunchConfigurationDialog();
    }

    public void setDirty(boolean bl) {
        this.isdirty = bl;
        this.checkForErrors();
        this.updateLaunchConfigurationDialog();
    }

    public void createControl(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.mainpanel = new Composite(composite, 0);
        this.mainpanel.setLayout((Layout)gridLayout);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.host_panel = new Composite(this.mainpanel, 0);
        this.host_panel.setLayout((Layout)gridLayout);
        this.host_panel.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.rac_host_label = new Label(this.host_panel, 16384);
        this.rac_host_label.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.rac_host_text = new Text(this.host_panel, 18436);
        this.rac_host_text.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.reg_host_same = new Button(this.host_panel, 32);
        this.reg_host_same.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.reg_host_text = new Text(this.host_panel, 18436);
        this.reg_host_text.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.rac_host_label.setText(PerfmonPlugin.getString("RAC_HOST"));
        this.rac_host_text.setText("?");
        this.reg_host_same.setText(PerfmonPlugin.getString("USE_RAC_HOST"));
        this.reg_host_text.setText("?");
        this.reg_host_same.setSelection(true);
        this.reg_host_text.setEnabled(false);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.container_panel = new Composite(this.mainpanel, 0);
        this.container_panel.setLayout((Layout)gridLayout);
        this.container_panel.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.container_label = new Label(this.container_panel, 16384);
        this.container_label.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)2, (int)1, (int)4, (int)4));
        this.container_text = new Text(this.container_panel, 18436);
        this.container_text.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.container_browse = new Button(this.container_panel, 0);
        this.container_browse.setLayoutData((Object)GData.getGridData((boolean)false, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)1, (int)4));
        this.container_label.setText(PerfmonPlugin.getString("PROFILING_PROJECT"));
        this.container_text.setText("?");
        this.container_browse.setText(PerfmonPlugin.getString("BROWSE"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.monitor_panel = new Composite(this.mainpanel, 0);
        this.monitor_panel.setLayout((Layout)gridLayout);
        this.monitor_panel.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.monitor_label = new Label(this.container_panel, 16384);
        this.monitor_label.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)2, (int)1, (int)4, (int)4));
        this.monitor_text = new Text(this.container_panel, 18436);
        this.monitor_text.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.monitor_browse = new Button(this.container_panel, 0);
        this.monitor_browse.setLayoutData((Object)GData.getGridData((boolean)false, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)1, (int)4));
        this.monitor_label.setText(PerfmonPlugin.getString("PROFILING_MONITOR"));
        this.monitor_text.setText("DefaultMonitor");
        this.monitor_browse.setText(PerfmonPlugin.getString("BROWSE"));
        this.reg_host_same.addSelectionListener((SelectionListener)this);
        this.monitor_browse.addSelectionListener((SelectionListener)this);
        this.container_browse.addSelectionListener((SelectionListener)this);
        this.rac_host_text.addKeyListener((KeyListener)this);
        this.reg_host_text.addKeyListener((KeyListener)this);
        this.container_text.addKeyListener((KeyListener)this);
        this.monitor_text.addKeyListener((KeyListener)this);
        this.checkForErrors();
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.setDirty(true);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.setDirty(true);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.widgetSelected(selectionEvent);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.getSource() == this.reg_host_same) {
            this.reg_host_text.setEnabled(!this.reg_host_text.getEnabled());
            this.setDirty(true);
        } else if (selectionEvent.getSource() == this.monitor_browse) {
            Object[] objectArray;
            MonitorSelectionDialog monitorSelectionDialog = new MonitorSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), PerfmonPlugin.getString("PROFILING_DIALOG"));
            if (monitorSelectionDialog.open() == 0 && (objectArray = monitorSelectionDialog.getResult()) != null && objectArray.length == 1 && objectArray[0] != null) {
                IPath iPath = (IPath)objectArray[0];
                URI uRI = URI.createPlatformResourceURI((String)iPath.toString());
                this.monitor_text.setText(uRI.toString().replaceFirst("platform:/resource/", ""));
                this.setDirty(true);
            }
        } else if (selectionEvent.getSource() == this.container_browse) {
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            Path path = null;
            IFolder iFolder = null;
            try {
                path = new Path("" + this.container_text.getText());
                iFolder = iWorkspaceRoot.getFolder((IPath)path);
            }
            catch (Throwable throwable) {
                PerfmonPlugin.DBG.warning("could not find valid IContainer for model save path " + this.container_text.getText());
            }
            PerfmonPlugin.DBG.info("showing container selection dialog");
            ContainerSelectionDialog containerSelectionDialog = null;
            containerSelectionDialog = new ContainerSelectionDialog(this.mainpanel.getShell(), (IContainer)iFolder, false, PerfmonPlugin.getString("SMODEL_SELECT_PATH_DESCRIPTION"));
            containerSelectionDialog.open();
            Object[] objectArray = containerSelectionDialog.getResult();
            if (objectArray != null && objectArray.length > 0) {
                Path path2 = (Path)objectArray[0];
                URI uRI = URI.createPlatformResourceURI((String)path2.toString().replaceFirst("platform:/resource/", ""));
                this.container_text.setText("" + uRI);
                PerfmonPlugin.DBG.info("updating menuitems to reflect new model save path");
                this.setDirty(true);
            }
        }
    }

    public Control getControl() {
        return this.mainpanel;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("hosts_same", true);
        iLaunchConfigurationWorkingCopy.setAttribute("host_rac", "localhost");
        iLaunchConfigurationWorkingCopy.setAttribute("host_reg", "localhost");
        iLaunchConfigurationWorkingCopy.setAttribute("smodel_container", "");
        iLaunchConfigurationWorkingCopy.setAttribute("monitor", "DefaultMonitor");
        try {
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            String string = URI.createPlatformResourceURI((String)iWorkspace.getRoot().getProjects()[0].getFullPath().toString()).toString();
            iLaunchConfigurationWorkingCopy.setAttribute("smodel_container", string);
        }
        catch (Exception exception) {
            PerfmonPlugin.DBG.error("problem getting default project", (Throwable)exception);
        }
        iLaunchConfigurationWorkingCopy.setAttribute("statcon_file", "");
        this.checkForErrors();
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this.setDirty(false);
        try {
            this.reg_host_same.setSelection(iLaunchConfiguration.getAttribute("hosts_same", true));
            this.rac_host_text.setText(iLaunchConfiguration.getAttribute("host_rac", "localhost"));
            this.reg_host_text.setText(iLaunchConfiguration.getAttribute("host_reg", "localhost"));
            this.container_text.setText(iLaunchConfiguration.getAttribute("smodel_container", ""));
            this.monitor_text.setText(iLaunchConfiguration.getAttribute("monitor", "DefaultMonitor"));
        }
        catch (CoreException coreException) {
            PerfmonPlugin.DBG.logVisibleError((Throwable)coreException, PerfmonPlugin.getString("ERROR_LAUNCH_CONFIG"), true);
        }
        if (this.reg_host_same.getSelection()) {
            this.reg_host_text.setEnabled(false);
        } else {
            this.reg_host_text.setEnabled(true);
        }
        this.checkForErrors();
    }

    public void dispose() {
        try {
            this.mainpanel.dispose();
        }
        catch (Throwable throwable) {}
    }

    private void printConfiguration(ILaunchConfiguration iLaunchConfiguration) {
        try {
            PerfmonPlugin.DBG.info("" + iLaunchConfiguration.getAttribute("hosts_same", true));
            PerfmonPlugin.DBG.info(iLaunchConfiguration.getAttribute("host_rac", "localhost"));
            PerfmonPlugin.DBG.info(iLaunchConfiguration.getAttribute("host_reg", "localhost"));
            PerfmonPlugin.DBG.info(iLaunchConfiguration.getAttribute("smodel_container", ""));
            PerfmonPlugin.DBG.info(iLaunchConfiguration.getAttribute("monitor", "DefaultMonitor"));
            PerfmonPlugin.DBG.info(iLaunchConfiguration.getAttribute("statcon_file", ""));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        this.printConfiguration((ILaunchConfiguration)iLaunchConfigurationWorkingCopy);
        iLaunchConfigurationWorkingCopy.setAttribute("hosts_same", this.reg_host_same.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute("host_rac", this.rac_host_text.getText());
        iLaunchConfigurationWorkingCopy.setAttribute("host_reg", this.reg_host_text.getText());
        iLaunchConfigurationWorkingCopy.setAttribute("smodel_container", this.container_text.getText());
        iLaunchConfigurationWorkingCopy.setAttribute("monitor", this.monitor_text.getText());
    }

    public void checkForErrors() {
        this.error_message = "";
        try {
            if (this.rac_host_text.getText().length() == 0) {
                this.error_message = PerfmonPlugin.getString("BAD_RAC_HOST");
            }
            if (!this.reg_host_same.getSelection() && this.reg_host_text.getText().length() == 0) {
                this.error_message = PerfmonPlugin.getString("BAD_REG_HOST");
            }
            if (this.container_text.getText().length() == 0) {
                this.error_message = PerfmonPlugin.getString("BAD_CONTAINER");
            }
            if (this.monitor_text.getText().length() == 0) {
                this.error_message = PerfmonPlugin.getString("BAD_MONITOR");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setError(this.error_message);
        this.updateLaunchConfigurationDialog();
    }

    public String getErrorMessage() {
        return this.error_message;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        return this.error_message == null;
    }

    public boolean canSave() {
        return this.isdirty;
    }

    protected ILaunchConfigurationDialog getLaunchConfigurationDialog() {
        return this.dialog;
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog iLaunchConfigurationDialog) {
        this.dialog = iLaunchConfigurationDialog;
    }

    public void launched(ILaunch iLaunch) {
    }

    public String getName() {
        return PerfmonPlugin.getString("PERFMON_AGENT");
    }

    public Image getImage() {
        return PerfmonPlugin.img.getImage("logo.gif");
    }

    public void activated(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        this.initializeFrom((ILaunchConfiguration)iLaunchConfigurationWorkingCopy);
    }

    public void deactivated(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        this.performApply(iLaunchConfigurationWorkingCopy);
    }
}

