/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon.xml;

import java.util.Arrays;

public class FastStringBuffer {
    private char[] value;
    private int count;
    private static final FastStringBuffer NULL = new FastStringBuffer("null");

    public FastStringBuffer() {
        this(16);
    }

    public FastStringBuffer(int n) {
        this.value = new char[n];
    }

    public FastStringBuffer(String string) {
        this(string.length() + 16);
        this.append(string);
    }

    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    private void expandCapacity(int n) {
        int n2 = (this.value.length + 1) * 2;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        } else if (n > n2) {
            n2 = n;
        }
        char[] cArray = new char[n2];
        System.arraycopy(this.value, 0, cArray, 0, this.count);
        this.value = cArray;
    }

    public void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
        if (this.count < n) {
            Arrays.fill(this.value, this.count, this.value.length, '\u0000');
        } else {
            this.count = n;
        }
    }

    public char charAt(int n) {
        return this.value[n];
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        System.arraycopy(this.value, n, cArray, n3, n2 - n);
    }

    public void setCharAt(int n, char c) {
        this.value[n] = c;
    }

    public FastStringBuffer append(Object object) {
        return this.append(String.valueOf(object));
    }

    public FastStringBuffer append(String string) {
        int n;
        int n2;
        if (string == null) {
            string = String.valueOf(string);
        }
        if ((n2 = this.count + (n = string.length())) > this.value.length) {
            this.expandCapacity(n2);
        }
        string.getChars(0, n, this.value, this.count);
        this.count = n2;
        return this;
    }

    public FastStringBuffer append(FastStringBuffer fastStringBuffer) {
        int n;
        int n2;
        if (fastStringBuffer == null) {
            fastStringBuffer = NULL;
        }
        if ((n2 = this.count + (n = fastStringBuffer.length())) > this.value.length) {
            this.expandCapacity(n2);
        }
        fastStringBuffer.getChars(0, n, this.value, this.count);
        this.count = n2;
        return this;
    }

    public FastStringBuffer append(char[] cArray) {
        int n = cArray.length;
        int n2 = this.count + n;
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        }
        System.arraycopy(cArray, 0, this.value, this.count, n);
        this.count = n2;
        return this;
    }

    public FastStringBuffer append(char[] cArray, int n, int n2) {
        int n3 = this.count + n2;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        }
        System.arraycopy(cArray, n, this.value, this.count, n2);
        this.count = n3;
        return this;
    }

    public FastStringBuffer append(boolean bl) {
        return this.append(String.valueOf(bl));
    }

    public FastStringBuffer append(char c) {
        int n = this.count + 1;
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
        this.value[this.count++] = c;
        return this;
    }

    public FastStringBuffer append(int n) {
        return this.append(String.valueOf(n));
    }

    public FastStringBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public FastStringBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public FastStringBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public FastStringBuffer delete(int n, int n2) {
        int n3;
        if (n2 > this.count) {
            n2 = this.count;
        }
        if ((n3 = n2 - n) > 0) {
            System.arraycopy(this.value, n + n3, this.value, n, this.count - n2);
            this.count -= n3;
        }
        return this;
    }

    public FastStringBuffer deleteCharAt(int n) {
        System.arraycopy(this.value, n + 1, this.value, n, this.count - n - 1);
        --this.count;
        return this;
    }

    public FastStringBuffer replace(int n, int n2, String string) {
        int n3;
        int n4;
        if (n2 > this.count) {
            n2 = this.count;
        }
        if ((n4 = this.count + (n3 = string.length()) - (n2 - n)) > this.value.length) {
            this.expandCapacity(n4);
        }
        System.arraycopy(this.value, n2, this.value, n + n3, this.count - n2);
        string.getChars(0, n3, this.value, n);
        this.count = n4;
        return this;
    }

    public String substring(int n) {
        return this.substring(n, this.count);
    }

    public String substring(int n, int n2) {
        return new String(this.value, n, n2 - n);
    }

    public FastStringBuffer insert(int n, char[] cArray, int n2, int n3) {
        int n4 = this.count + n3;
        if (n4 > this.value.length) {
            this.expandCapacity(n4);
        }
        System.arraycopy(this.value, n, this.value, n + n3, this.count - n);
        System.arraycopy(cArray, n2, this.value, n, n3);
        this.count = n4;
        return this;
    }

    public FastStringBuffer insert(int n, Object object) {
        return this.insert(n, String.valueOf(object));
    }

    public FastStringBuffer insert(int n, String string) {
        int n2;
        int n3;
        if (string == null) {
            string = String.valueOf(string);
        }
        if ((n3 = this.count + (n2 = string.length())) > this.value.length) {
            this.expandCapacity(n3);
        }
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        string.getChars(0, n2, this.value, n);
        this.count = n3;
        return this;
    }

    public FastStringBuffer insert(int n, char[] cArray) {
        int n2 = cArray.length;
        int n3 = this.count + n2;
        if (n3 > this.value.length) {
            this.expandCapacity(n3);
        }
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        System.arraycopy(cArray, 0, this.value, n, n2);
        this.count = n3;
        return this;
    }

    public FastStringBuffer insert(int n, boolean bl) {
        return this.insert(n, String.valueOf(bl));
    }

    public FastStringBuffer insert(int n, char c) {
        int n2 = this.count + 1;
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        }
        System.arraycopy(this.value, n, this.value, n + 1, this.count - n);
        this.value[n] = c;
        this.count = n2;
        return this;
    }

    public FastStringBuffer insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public FastStringBuffer insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public FastStringBuffer insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public FastStringBuffer insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public int indexOf(char c, int n) {
        int n2 = n;
        while (n2 < this.count) {
            if (this.value[n2] == c) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    private int indexOf(char[] cArray, int n) {
        int n2 = this.count - cArray.length + 1;
        int n3 = 0;
        int n4 = cArray.length;
        int n5 = n;
        while (n5 < n2) {
            if (this.value[n5] == cArray[n3]) {
                if (++n3 == n4) {
                    return n5 + 1 - n3;
                }
            } else {
                n3 = 0;
            }
            ++n5;
        }
        return -1;
    }

    private int rindexOf(char[] cArray, int n) {
        int n2;
        int n3 = n2 = cArray.length - 1;
        int n4 = n += cArray.length - 1;
        while (n4 >= 0) {
            if (this.value[n4] == cArray[n3]) {
                if (--n3 == -1) {
                    return n4;
                }
            } else {
                n3 = n2;
            }
            --n4;
        }
        return -1;
    }

    public int indexOf(String string, int n) {
        char[] cArray = string.toCharArray();
        return this.indexOf(cArray, n);
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public int lastIndexOf(String string, int n) {
        char[] cArray = string.toCharArray();
        return this.rindexOf(cArray, n);
    }

    public FastStringBuffer reverse() {
        int n = this.count - 1;
        int n2 = n - 1 >> 1;
        while (n2 >= 0) {
            char c = this.value[n2];
            this.value[n2] = this.value[n - n2];
            this.value[n - n2] = c;
            --n2;
        }
        return this;
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }
}

