/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.presentation;

import java.io.File;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.AdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.AdapterPackage;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.AdapterType;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationFactory;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationType;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.context.Component;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextFactory;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextRoleNames;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextType;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextsType;
import org.eclipse.hyades.logging.adapter.model.internal.context.RoleNames;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorFactory;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserFactory;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElementType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.SubstitutionRuleType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorFactory;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.PropertyType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.UnitFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.ContextIds;
import org.eclipse.hyades.logging.adapter.ui.internal.presentation.MigrationUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;

public class AdaptorModelWizard
extends Wizard
implements INewWizard {
    private ConfigLogTemplatePage logPage;
    protected AdapterPackage adaptorPackage = AdapterPackage.eINSTANCE;
    protected AdapterFactory adaptorFactory = this.adaptorPackage.getAdapterFactory();
    protected AdaptorModelWizardNewFileCreationPage newFileCreationPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    static /* synthetic */ Class class$org$eclipse$hyades$logging$adapter$impl$BasicContext;
    static /* synthetic */ Class class$org$eclipse$hyades$logging$adapter$formatters$CBEFormatter;
    static /* synthetic */ Class class$org$eclipse$hyades$logging$adapter$sensors$SingleOSFileSensor;
    static /* synthetic */ Class class$org$eclipse$hyades$logging$adapter$extractors$RegularExpressionExtractor;
    static /* synthetic */ Class class$org$eclipse$hyades$logging$adapter$outputters$CBELogOutputter;
    static /* synthetic */ Class class$org$eclipse$hyades$logging$adapter$parsers$Parser;

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
        this.selection = iStructuredSelection;
        this.setWindowTitle(AcadEditorPlugin.INSTANCE.getString("_UI_Wizard_label"));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(AcadEditorPlugin.INSTANCE.getImage("full/wizban/NewAdaptor")));
    }

    EObject createInitialModel(String string) {
        XSDElementDeclaration xSDElementDeclaration;
        XSDTypeDefinition xSDTypeDefinition;
        EClass eClass = ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)this.adaptorPackage);
        EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature("adapter");
        EObject eObject = this.adaptorFactory.create(eClass);
        AdapterType adapterType = (AdapterType)this.adaptorFactory.create((EClass)eStructuralFeature.getEType());
        eObject.eSet(eStructuralFeature, (Object)adapterType);
        ContextsType contextsType = ContextFactory.eINSTANCE.createContextsType();
        adapterType.setContexts(contextsType);
        ConfigurationType configurationType = ConfigurationFactory.eINSTANCE.createConfigurationType();
        configurationType.setDescription("The component level configurations for this Adaptor");
        adapterType.setConfiguration(configurationType);
        ContextInstanceType contextInstanceType = ConfigurationFactory.eINSTANCE.createContextInstanceType();
        contextInstanceType.setContinuousOperation(true);
        contextInstanceType.setMaximumIdleTime("20000");
        contextInstanceType.setPauseInterval("10");
        contextInstanceType.setDescription("Context Instance for the current component");
        configurationType.getContextInstance().add((Object)contextInstanceType);
        ContextType contextType = this.createContext(contextInstanceType);
        contextsType.getContext().add((Object)contextType);
        Path path = new Path(string);
        SensorConfigType sensorConfigType = SensorFactory.eINSTANCE.createSensorConfigType();
        PropertyType propertyType = UnitFactory.eINSTANCE.createPropertyType();
        propertyType.setPropertyName("directory");
        propertyType.setPropertyValue(path.removeLastSegments(1).toOSString());
        sensorConfigType.getProperty().add((Object)propertyType);
        propertyType = UnitFactory.eINSTANCE.createPropertyType();
        propertyType.setPropertyName("fileName");
        propertyType.setPropertyValue(path.lastSegment());
        sensorConfigType.getProperty().add((Object)propertyType);
        sensorConfigType.setDescription("A single file sensor");
        sensorConfigType.setMaximumBlocking("5");
        sensorConfigType.setConfidenceBufferSize(new BigInteger("1024"));
        sensorConfigType.setFileFooterSize(new BigInteger("90"));
        contextInstanceType.setSensor(sensorConfigType);
        sensorConfigType.setType(SensorType.SINGLE_FILE_SENSOR_LITERAL);
        contextType.getComponent().add((Object)this.createComponentFileSensor(sensorConfigType));
        ExtractorType extractorType = ExtractorFactory.eINSTANCE.createExtractorType();
        extractorType.setDescription("This extractor uses regular expression  patterns to identify record delimiters");
        extractorType.setContainsLineBreaks(true);
        extractorType.setIncludeEndPattern(true);
        extractorType.setIncludeStartPattern(true);
        extractorType.setReplaceLineBreaks(true);
        extractorType.setReplaceLineBreaks(false);
        extractorType.setStartPattern("^");
        extractorType.setEndPattern("$");
        contextInstanceType.setExtractor(extractorType);
        contextType.getComponent().add((Object)this.createComponentExtractor(extractorType));
        ParserConfigType parserConfigType = ParserFactory.eINSTANCE.createParserConfigType();
        RuleElementType ruleElementType = ParserFactory.eINSTANCE.createRuleElementType();
        ruleElementType.setName("CommonBaseEvent");
        parserConfigType.getRuleElement().add((Object)ruleElementType);
        contextInstanceType.setParser(parserConfigType);
        Object object = AcadEditorPlugin.INSTANCE.getElementDefinitionForType(ruleElementType);
        if (object != null && object instanceof XSDElementDeclaration && (xSDTypeDefinition = (xSDElementDeclaration = (XSDElementDeclaration)object).getTypeDefinition()) instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition xSDComplexTypeDefinition = (XSDComplexTypeDefinition)xSDTypeDefinition;
            EList eList = xSDComplexTypeDefinition.getAttributeUses();
            int n = 0;
            while (n < eList.size()) {
                XSDAttributeUse xSDAttributeUse = (XSDAttributeUse)eList.get(n);
                if (xSDAttributeUse.isRequired()) {
                    RuleAttributeType ruleAttributeType = ParserFactory.eINSTANCE.createRuleAttributeType();
                    ruleAttributeType.setUsePreviousMatchSubstitutionAsDefault(true);
                    ruleAttributeType.setUsePreviousMatchSubstitutionAsDefault(false);
                    ruleAttributeType.setName(xSDAttributeUse.getAttributeDeclaration().getName());
                    ruleElementType.getRuleAttribute().add((Object)ruleAttributeType);
                    SubstitutionRuleType substitutionRuleType = ParserFactory.eINSTANCE.createSubstitutionRuleType();
                    substitutionRuleType.setMatch("^(.*)");
                    substitutionRuleType.setSubstitute("replace with our message text");
                    substitutionRuleType.setUseBuiltInFunction(true);
                    substitutionRuleType.setUseBuiltInFunction(false);
                    ruleAttributeType.getSubstitutionRule().add((Object)substitutionRuleType);
                }
                ++n;
            }
        }
        contextType.getComponent().add((Object)this.createComponentParser(parserConfigType));
        xSDElementDeclaration = FormatterFactory.eINSTANCE.createFormatterType();
        xSDElementDeclaration.setDescription("CBE Formatter");
        contextInstanceType.getFormatter().add((Object)xSDElementDeclaration);
        contextType.getComponent().add((Object)this.createComponentFormatter((FormatterType)xSDElementDeclaration));
        xSDTypeDefinition = OutputterFactory.eINSTANCE.createOutputterConfigType();
        propertyType = UnitFactory.eINSTANCE.createPropertyType();
        propertyType.setPropertyName("agentName");
        propertyType.setPropertyValue("Default Logging Agent");
        xSDTypeDefinition.getProperty().add((Object)propertyType);
        xSDTypeDefinition.setDescription("Logging Agent Outputter");
        xSDTypeDefinition.setType(OutputterType.LOGGING_AGENT_OUTPUTTER_LITERAL);
        contextInstanceType.getOutputter().add((Object)xSDTypeDefinition);
        contextType.getComponent().add((Object)this.createComponentOutputter((OutputterConfigType)xSDTypeDefinition));
        return eObject;
    }

    protected ContextType createContext(ContextInstanceType contextInstanceType) {
        String string = new Date().toString();
        ContextType contextType = ContextFactory.eINSTANCE.createContextType();
        contextType.setDescription(contextInstanceType.getDescription());
        contextType.setUniqueID(contextInstanceType.getUniqueID());
        contextType.setExecutableClass((class$org$eclipse$hyades$logging$adapter$impl$BasicContext == null ? (class$org$eclipse$hyades$logging$adapter$impl$BasicContext = AdaptorModelWizard.class$("org.eclipse.hyades.logging.adapter.impl.BasicContext")) : class$org$eclipse$hyades$logging$adapter$impl$BasicContext).getName());
        contextType.setImplementationCreationDate((Object)string);
        contextType.setLoggingLevel("60");
        contextType.setRole(ContextRoleNames.CONTEXT_LITERAL);
        contextType.setRoleCreationDate((Object)string);
        contextType.setName("Basic Context Implementation");
        return contextType;
    }

    protected Component createComponentFormatter(FormatterType formatterType) {
        String string = new Date().toString();
        Component component = ContextFactory.eINSTANCE.createComponent();
        component.setDescription(formatterType.getDescription());
        component.setUniqueID(formatterType.getUniqueID());
        component.setExecutableClass((class$org$eclipse$hyades$logging$adapter$formatters$CBEFormatter == null ? (class$org$eclipse$hyades$logging$adapter$formatters$CBEFormatter = AdaptorModelWizard.class$("org.eclipse.hyades.logging.adapter.formatters.CBEFormatter")) : class$org$eclipse$hyades$logging$adapter$formatters$CBEFormatter).getName());
        component.setImplementationCreationDate((Object)string);
        component.setLoggingLevel("99");
        component.setRole(RoleNames.FORMATTER_LITERAL);
        component.setRoleCreationDate((Object)string);
        component.setName(component.getDescription());
        return component;
    }

    protected Component createComponentFileSensor(SensorConfigType sensorConfigType) {
        String string = new Date().toString();
        Component component = ContextFactory.eINSTANCE.createComponent();
        component.setUniqueID(sensorConfigType.getUniqueID());
        component.setExecutableClass((class$org$eclipse$hyades$logging$adapter$sensors$SingleOSFileSensor == null ? (class$org$eclipse$hyades$logging$adapter$sensors$SingleOSFileSensor = AdaptorModelWizard.class$("org.eclipse.hyades.logging.adapter.sensors.SingleOSFileSensor")) : class$org$eclipse$hyades$logging$adapter$sensors$SingleOSFileSensor).getName());
        component.setImplementationCreationDate((Object)string);
        component.setLoggingLevel("0");
        component.setRole(RoleNames.CONTEXT_LITERAL);
        component.setRole(RoleNames.SENSOR_LITERAL);
        component.setRoleCreationDate((Object)string);
        component.setName("OS File Sensor");
        component.setDescription("Operating System file sensor");
        return component;
    }

    protected Component createComponentExtractor(ExtractorType extractorType) {
        String string = new Date().toString();
        Component component = ContextFactory.eINSTANCE.createComponent();
        component.setDescription(extractorType.getDescription());
        component.setUniqueID(extractorType.getUniqueID());
        component.setExecutableClass((class$org$eclipse$hyades$logging$adapter$extractors$RegularExpressionExtractor == null ? (class$org$eclipse$hyades$logging$adapter$extractors$RegularExpressionExtractor = AdaptorModelWizard.class$("org.eclipse.hyades.logging.adapter.extractors.RegularExpressionExtractor")) : class$org$eclipse$hyades$logging$adapter$extractors$RegularExpressionExtractor).getName());
        component.setImplementationCreationDate((Object)string);
        component.setLoggingLevel("99");
        component.setRole(RoleNames.MESSAGE_EXTRACTOR_LITERAL);
        component.setRoleCreationDate((Object)string);
        component.setName("Regular Expression Extractor");
        return component;
    }

    protected Component createComponentOutputter(OutputterConfigType outputterConfigType) {
        String string = new Date().toString();
        Component component = ContextFactory.eINSTANCE.createComponent();
        component.setDescription(outputterConfigType.getDescription());
        component.setUniqueID(outputterConfigType.getUniqueID());
        component.setExecutableClass((class$org$eclipse$hyades$logging$adapter$outputters$CBELogOutputter == null ? (class$org$eclipse$hyades$logging$adapter$outputters$CBELogOutputter = AdaptorModelWizard.class$("org.eclipse.hyades.logging.adapter.outputters.CBELogOutputter")) : class$org$eclipse$hyades$logging$adapter$outputters$CBELogOutputter).getName());
        component.setImplementationCreationDate((Object)string);
        component.setLoggingLevel("99");
        component.setRole(RoleNames.OUTPUTTER_LITERAL);
        component.setRoleCreationDate((Object)string);
        component.setName("Hyades Logging Agent Outputter");
        return component;
    }

    protected Component createComponentParser(ParserConfigType parserConfigType) {
        String string = new Date().toString();
        Component component = ContextFactory.eINSTANCE.createComponent();
        component.setDescription("Regular expression parser");
        component.setUniqueID(parserConfigType.getUniqueID());
        component.setExecutableClass((class$org$eclipse$hyades$logging$adapter$parsers$Parser == null ? (class$org$eclipse$hyades$logging$adapter$parsers$Parser = AdaptorModelWizard.class$("org.eclipse.hyades.logging.adapter.parsers.Parser")) : class$org$eclipse$hyades$logging$adapter$parsers$Parser).getName());
        component.setImplementationCreationDate((Object)string);
        component.setLoggingLevel("99");
        component.setRole(RoleNames.PARSER_LITERAL);
        component.setRoleCreationDate((Object)string);
        component.setName("Generic Parser");
        return component;
    }

    public boolean performFinish() {
        try {
            StructuredSelection structuredSelection;
            final IFile iFile = this.getModelFile();
            this.logPage.performFinish();
            final String string = this.logPage.getTemplateLogName();
            WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected void execute(IProgressMonitor iProgressMonitor) {
                    try {
                        try {
                            ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
                            URI uRI = URI.createPlatformResourceURI((String)iFile.getFullPath().toString());
                            Resource resource = resourceSetImpl.createResource(uRI);
                            EObject eObject = AdaptorModelWizard.this.createInitialModel(string);
                            if (eObject != null) {
                                resource.getContents().add((Object)eObject);
                            }
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            hashMap.put("ENCODING", AdaptorModelWizard.this.newFileCreationPage.getEncoding());
                            try {
                                EClass eClass = ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)AdapterPackage.eINSTANCE);
                                EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature("adapter");
                                AdapterType adapterType = (AdapterType)eObject.eGet(eStructuralFeature);
                                MigrationUtil.migrateSave(adapterType);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            resource.save(hashMap);
                        }
                        catch (Exception exception) {
                            AcadEditorPlugin.INSTANCE.log(exception);
                            Object var11_13 = null;
                            iProgressMonitor.done();
                            return;
                        }
                        Object var11_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_14 = null;
                        iProgressMonitor.done();
                        throw throwable;
                    }
                    iProgressMonitor.done();
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)workspaceModifyOperation);
            IWorkbenchWindow iWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
            final IWorkbenchPart iWorkbenchPart = iWorkbenchPage.getActivePart();
            if (iWorkbenchPart instanceof ISetSelectionTarget) {
                structuredSelection = new StructuredSelection((Object)iFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)structuredSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    public void run() {
                        ((ISetSelectionTarget)iWorkbenchPart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
            }
            catch (PartInitException partInitException) {
                MessageDialog.openError((Shell)iWorkbenchWindow.getShell(), (String)AcadEditorPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), (String)partInitException.getMessage());
                return false;
            }
            structuredSelection = iFile.getProject().getDescription();
            ICommand[] iCommandArray = structuredSelection.getBuildSpec();
            boolean bl = false;
            int n = 0;
            while (n < iCommandArray.length) {
                if (iCommandArray[n].getBuilderName().equals("org.eclipse.hyades.logging.adapter.ui.glaBuilder")) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                ICommand iCommand = structuredSelection.newCommand();
                iCommand.setBuilderName("org.eclipse.hyades.logging.adapter.ui.glaBuilder");
                ICommand[] iCommandArray2 = new ICommand[iCommandArray.length + 1];
                System.arraycopy(iCommandArray, 0, iCommandArray2, 1, iCommandArray.length);
                iCommandArray2[0] = iCommand;
                structuredSelection.setBuildSpec(iCommandArray2);
                iFile.getProject().setDescription((IProjectDescription)structuredSelection, null);
            }
            return true;
        }
        catch (Exception exception) {
            AcadEditorPlugin.INSTANCE.log(exception);
            return false;
        }
    }

    public void addPages() {
        Object e;
        this.newFileCreationPage = new AdaptorModelWizardNewFileCreationPage("Whatever", this.selection);
        this.newFileCreationPage.setTitle(AcadEditorPlugin.INSTANCE.getString("_UI_AdaptorModelWizard_label"));
        this.newFileCreationPage.setDescription(AcadEditorPlugin.INSTANCE.getString("_UI_AdaptorModelWizard_description"));
        this.newFileCreationPage.setFileName(AcadEditorPlugin.INSTANCE.getString("_UI_AdaptorEditorFilenameDefaultBase") + "." + AcadEditorPlugin.INSTANCE.getString("_UI_AdapterEditorFilenameExtension"));
        this.addPage((IWizardPage)this.newFileCreationPage);
        this.logPage = new ConfigLogTemplatePage("logPage");
        this.logPage.setDescription("Select a template log file.");
        this.logPage.setTitle("Template log file");
        this.addPage((IWizardPage)this.logPage);
        if (this.selection != null && !this.selection.isEmpty() && (e = this.selection.iterator().next()) instanceof IResource) {
            IResource iResource = (IResource)e;
            if (iResource.getType() == 1) {
                iResource = iResource.getParent();
            }
            if (iResource instanceof IFolder || iResource instanceof IProject) {
                String string = iResource.getLocation().toOSString();
                this.newFileCreationPage.setContainerFullPath(iResource.getFullPath());
                String string2 = AcadEditorPlugin.INSTANCE.getString("_UI_AdaptorEditorFilenameDefaultBase");
                String string3 = AcadEditorPlugin.INSTANCE.getString("_UI_AdapterEditorFilenameExtension");
                String string4 = string2 + "." + string3;
                int n = 1;
                while (((IContainer)iResource).findMember(string4) != null) {
                    string4 = string2 + n + "." + string3;
                    ++n;
                }
                this.newFileCreationPage.setFileName(string4);
            }
        }
    }

    public IFile getModelFile() {
        return this.newFileCreationPage.getModelFile();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ConfigLogTemplatePage
    extends WizardPage
    implements SelectionListener,
    ModifyListener {
        String templateLogName;
        Button browseBtn;
        protected Text templateLog;

        public ConfigLogTemplatePage(String string) {
            super(string);
        }

        public void createControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.verticalSpacing = 12;
            composite2.setLayout((Layout)gridLayout);
            GridData gridData = new GridData();
            gridData.verticalAlignment = 4;
            gridData.grabExcessVerticalSpace = true;
            gridData.horizontalAlignment = 4;
            composite2.setLayoutData((Object)gridData);
            gridLayout = new Label(composite2, 16384);
            gridLayout.setText(AcadEditorPlugin.getDefault().getString("LOG_NAME_LABEL"));
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.horizontalSpan = 2;
            gridLayout.setLayoutData((Object)gridData);
            this.templateLog = new Text(composite2, 2048);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.templateLog.setLayoutData((Object)gridData);
            this.browseBtn = new Button(composite2, 8);
            this.browseBtn.setText(AcadEditorPlugin.getDefault().getString("BROWSE"));
            this.browseBtn.addSelectionListener((SelectionListener)this);
            this.templateLog.addModifyListener((ModifyListener)this);
            this.setControl((Control)composite2);
            this.setPageComplete(this.isPageComplete());
            WorkbenchHelp.setHelp((Control)composite, (String)ContextIds.ACAD_EDITOR_WIZARDPAGE_LOG_FILE);
        }

        public boolean isPageComplete() {
            String string = this.getTemplateLogName();
            return string != null && string.length() != 0;
        }

        public boolean performFinish() {
            this.templateLogName = this.getTemplateLogName();
            return true;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell());
            fileDialog.setFileName(this.templateLog.getText().concat(File.separator).concat("*"));
            String string = fileDialog.open();
            if (string != null) {
                this.templateLog.setText(string);
                this.setPageComplete(this.isPageComplete());
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            this.templateLogName = this.templateLog.getText();
            this.setPageComplete(this.isPageComplete());
        }

        public String getTemplateLogName() {
            return this.templateLogName == null ? this.templateLog.getText() : this.templateLogName;
        }

        public Text getTemplateLog() {
            return this.templateLog;
        }

        public void setTemplateLog(Text text) {
            this.templateLog = text;
        }
    }

    public class AdaptorModelWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        protected IFile modelFile;
        protected String encoding;
        protected CCombo encodingField;

        public AdaptorModelWizardNewFileCreationPage(String string, IStructuredSelection iStructuredSelection) {
            super(string, iStructuredSelection);
        }

        protected void createAdvancedControls(Composite composite) {
            super.createAdvancedControls(composite);
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            composite2.setLayout((Layout)gridLayout);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            composite2.setLayoutData((Object)gridData);
            Label label = new Label(composite2, 16384);
            label.setText(AcadEditorPlugin.INSTANCE.getString("_UI_XMLEncoding"));
            Object object = new GridData();
            ((GridData)object).horizontalAlignment = 4;
            label.setLayoutData(object);
            this.encodingField = new CCombo(composite2, 2048);
            object = new GridData();
            ((GridData)object).horizontalAlignment = 4;
            ((GridData)object).grabExcessHorizontalSpace = true;
            this.encodingField.setLayoutData(object);
            object = new StringTokenizer(AcadEditorPlugin.INSTANCE.getString("_UI_XMLEncodingChoices"));
            while (((StringTokenizer)object).hasMoreTokens()) {
                this.encodingField.add(((StringTokenizer)object).nextToken());
            }
            if (this.encodingField.getItemCount() > 1) {
                this.encodingField.select(1);
            } else {
                this.encodingField.select(0);
            }
        }

        public String getEncoding() {
            return this.encoding == null ? this.encodingField.getText() : this.encoding;
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String string = AcadEditorPlugin.INSTANCE.getString("_UI_AdapterEditorFilenameExtension");
                String string2 = new Path(this.getFileName()).getFileExtension();
                if (string2 == null || !string2.equals(string)) {
                    this.setErrorMessage(AcadEditorPlugin.INSTANCE.getString("_WARN_FilenameExtension", new Object[]{string}));
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean performFinish() {
            this.modelFile = this.getModelFile();
            this.encoding = this.getEncoding();
            return true;
        }

        public IFile getModelFile() {
            return this.modelFile == null ? ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName())) : this.modelFile;
        }
    }
}

