/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.PropertyType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.provider.PropertyTypeItemProvider;
import org.eclipse.hyades.logging.adapter.model.internal.unit.provider.UnitItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PropertySection
extends Composite
implements IDetails,
ModifyListener,
INotifyChangedListener {
    protected Text nameText;
    protected Text valueText;
    protected boolean isDisplaying;
    protected PropertyType currentSelection;
    protected PropertyTypeItemProvider itemProvider;
    protected UnitItemProviderAdapterFactory itemFactory = new UnitItemProviderAdapterFactory();

    public PropertySection(RuleBuilderWidgetFactory ruleBuilderWidgetFactory, Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 5;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_PNAME"), 0);
        this.nameText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.nameText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_PVALUE"), 0);
        this.valueText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.valueText.setLayoutData((Object)new GridData(768));
        this.valueText.addModifyListener((ModifyListener)this);
        this.nameText.addModifyListener((ModifyListener)this);
        this.itemProvider = (PropertyTypeItemProvider)this.itemFactory.createPropertyTypeAdapter();
        this.itemProvider.addListener(this);
    }

    public void display(EObject eObject) {
        if (eObject != null) {
            AcadGuiModelManager.setCurrentModel((ContextInstanceType)eObject.eContainer().eContainer());
        }
        if (this.currentSelection == eObject) {
            return;
        }
        if (this.valueText.isFocusControl() || this.nameText.isFocusControl()) {
            return;
        }
        this.currentSelection = (PropertyType)eObject;
        this.isDisplaying = true;
        this.valueText.setText(this.currentSelection.getPropertyValue() == null ? "" : this.currentSelection.getPropertyValue());
        this.nameText.setText(this.currentSelection.getPropertyName() == null ? "" : this.currentSelection.getPropertyName());
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(EObject eObject) {
        this.currentSelection = (PropertyType)eObject;
        this.currentSelection.setPropertyName(this.nameText.getText());
        this.currentSelection.setPropertyValue(this.valueText.getText());
        return false;
    }

    public void setFocusToText() {
        this.nameText.setFocus();
        this.nameText.selectAll();
    }

    public void modifyText(ModifyEvent modifyEvent) {
        String string;
        if (this.isDisplaying || this.currentSelection == null) {
            return;
        }
        if (modifyEvent.getSource() == this.valueText) {
            String string2 = this.valueText.getText();
            if (!string2.equals(this.currentSelection.getPropertyValue())) {
                if (string2.length() == 0 && this.currentSelection.getPropertyValue() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, PropertyTypeItemProvider.VALUE);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string2);
                }
            }
        } else if (modifyEvent.getSource() == this.nameText && !(string = this.nameText.getText()).equals(this.currentSelection.getPropertyName())) {
            if (string.length() == 0 && this.currentSelection.getPropertyName() == null) {
                return;
            }
            IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, PropertyTypeItemProvider.NAME);
            if (iItemPropertyDescriptor != null) {
                iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
    }

    public void notifyChanged(Notification notification) {
        Object object = notification.getNotifier();
        if (object == null || object != this.currentSelection) {
            return;
        }
        this.display((EObject)this.currentSelection);
    }
}

