/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.parser.SubstitutionRuleType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.provider.ParserItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.parser.provider.SubstitutionRuleTypeItemProvider;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RuleSection
extends Composite
implements IDetails,
ModifyListener,
SelectionListener,
INotifyChangedListener {
    protected Text matchText;
    protected Text positionsText;
    protected Text substituteText;
    protected Button useBuiltInFunction;
    protected boolean isDisplaying;
    protected SubstitutionRuleType currentSelection;
    protected SubstitutionRuleTypeItemProvider itemProvider;
    protected ParserItemProviderAdapterFactory itemFactory = new ParserItemProviderAdapterFactory();
    private Text substitutionExtensionClassText;
    private Text timeFormatText;

    public RuleSection(RuleBuilderWidgetFactory ruleBuilderWidgetFactory, Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 5;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_SUBST_POS"), 0);
        this.positionsText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.positionsText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_SUBST_MATCH"), 0);
        this.matchText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.matchText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_SUBST_SUBST"), 0);
        this.substituteText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.substituteText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_SubstitutionExtensionClass"), 0);
        this.substitutionExtensionClassText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.substitutionExtensionClassText.setLayoutData((Object)new GridData(768));
        this.substitutionExtensionClassText.setToolTipText(AcadEditorPlugin.getPlugin().getString("SINCE_1_3"));
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_TimeFormat"), 0);
        this.timeFormatText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.timeFormatText.setLayoutData((Object)new GridData(768));
        this.timeFormatText.setToolTipText(AcadEditorPlugin.getPlugin().getString("SINCE_1_3"));
        label = ruleBuilderWidgetFactory.createLabel(this, "", 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.useBuiltInFunction = ruleBuilderWidgetFactory.createButton(this, AcadEditorPlugin.getPlugin().getString("_SUBST_USE_BUILT_FCT"), 32);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.useBuiltInFunction.setLayoutData((Object)gridData);
        this.positionsText.addModifyListener((ModifyListener)this);
        this.matchText.addModifyListener((ModifyListener)this);
        this.substituteText.addModifyListener((ModifyListener)this);
        this.substitutionExtensionClassText.addModifyListener((ModifyListener)this);
        this.timeFormatText.addModifyListener((ModifyListener)this);
        this.useBuiltInFunction.addSelectionListener((SelectionListener)this);
        this.itemProvider = (SubstitutionRuleTypeItemProvider)this.itemFactory.createSubstitutionRuleTypeAdapter();
        this.itemProvider.addListener(this);
    }

    public void display(EObject eObject) {
        if (this.currentSelection == eObject) {
            return;
        }
        if (this.positionsText.isFocusControl() || this.matchText.isFocusControl() || this.substituteText.isFocusControl() || this.useBuiltInFunction.isFocusControl()) {
            return;
        }
        this.currentSelection = (SubstitutionRuleType)eObject;
        this.isDisplaying = true;
        this.matchText.setText(this.currentSelection.getMatch() == null ? "" : this.currentSelection.getMatch());
        this.positionsText.setText(this.currentSelection.getPositions() == null ? "" : this.currentSelection.getPositions());
        this.substituteText.setText(this.currentSelection.getSubstitute() == null ? "" : this.currentSelection.getSubstitute());
        this.useBuiltInFunction.setSelection(this.currentSelection.isUseBuiltInFunction());
        this.substitutionExtensionClassText.setText(this.currentSelection.getSubstitutionExtensionClass() == null ? "" : this.currentSelection.getSubstitutionExtensionClass());
        this.timeFormatText.setText(this.currentSelection.getTimeFormat() == null ? "" : this.currentSelection.getTimeFormat());
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(EObject eObject) {
        this.currentSelection = (SubstitutionRuleType)eObject;
        this.currentSelection.setPositions(this.positionsText.getText());
        this.currentSelection.setMatch(this.matchText.getText());
        this.currentSelection.setSubstitute(this.substituteText.getText());
        this.currentSelection.setSubstitutionExtensionClass(this.substitutionExtensionClassText.getText());
        this.currentSelection.setTimeFormat(this.timeFormatText.getText());
        this.currentSelection.setUseBuiltInFunction(this.useBuiltInFunction.getSelection());
        return false;
    }

    public void setFocusToText() {
        this.substituteText.setFocus();
        this.substituteText.selectAll();
    }

    public void modifyText(ModifyEvent modifyEvent) {
        String string;
        if (this.isDisplaying || this.currentSelection == null) {
            return;
        }
        if (modifyEvent.getSource() == this.matchText) {
            String string2 = this.matchText.getText();
            if (!string2.equals(this.currentSelection.getMatch())) {
                if (string2.length() == 0 && this.currentSelection.getMatch() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, SubstitutionRuleTypeItemProvider.MATCH);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string2);
                }
            }
        } else if (modifyEvent.getSource() == this.positionsText) {
            String string3 = this.positionsText.getText();
            if (!string3.equals(this.currentSelection.getPositions())) {
                if (string3.length() == 0 && this.currentSelection.getPositions() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, SubstitutionRuleTypeItemProvider.POSITIONS);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string3);
                }
            }
        } else if (modifyEvent.getSource() == this.substituteText) {
            String string4 = this.substituteText.getText();
            if (!string4.equals(this.currentSelection.getSubstitute())) {
                if (string4.length() == 0 && this.currentSelection.getSubstitute() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, SubstitutionRuleTypeItemProvider.SUBSTITUTE);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string4);
                }
            }
        } else if (modifyEvent.getSource() == this.substitutionExtensionClassText) {
            String string5 = this.substitutionExtensionClassText.getText();
            if (!string5.equals(this.currentSelection.getSubstitutionExtensionClass())) {
                if (string5.length() == 0 && this.currentSelection.getSubstitutionExtensionClass() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, SubstitutionRuleTypeItemProvider.SUBSTITUTION_EXTENSION_CLASS);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string5);
                }
            }
        } else if (modifyEvent.getSource() == this.timeFormatText && !(string = this.timeFormatText.getText()).equals(this.currentSelection.getTimeFormat())) {
            if (string.length() == 0 && this.currentSelection.getTimeFormat() == null) {
                return;
            }
            IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, SubstitutionRuleTypeItemProvider.TIME_FORMAT);
            if (iItemPropertyDescriptor != null) {
                iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
    }

    public void notifyChanged(Notification notification) {
        Object object = notification.getNotifier();
        if (object == null || object != this.currentSelection) {
            return;
        }
        this.display((EObject)this.currentSelection);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, SubstitutionRuleTypeItemProvider.MATCH);
        this.currentSelection.setUseBuiltInFunction(this.useBuiltInFunction.getSelection());
        String string = this.currentSelection.getMatch();
        if (iItemPropertyDescriptor != null) {
            iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }
}

