/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.views;

import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.logging.adapter.Adapter;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.PropertyType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.util.ResultQueue;
import org.eclipse.hyades.logging.adapter.ui.internal.util.ResultQueueEntry;
import org.eclipse.hyades.logging.adapter.ui.internal.util.TestContextListener;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.hyades.logging.adapter.ui.internal.views.ContentView;
import org.eclipse.hyades.logging.adapter.ui.internal.views.LogView;
import org.eclipse.hyades.logging.adapter.ui.internal.views.ResultView;
import org.eclipse.hyades.logging.core.ISerializableAsXml;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AcadGuiModel {
    protected ContextInstanceType context;
    protected String logContent = "";
    protected Adapter adaptor;
    protected TestContextListener contextListener;
    private ResultQueue resultQueue = new ResultQueue();
    private int resultQueueCursor;
    private int resultQueueBeginCount;
    private boolean cycling = false;
    protected int startRecord = 1;

    public AcadGuiModel() {
        this.resultQueue.setMaxSize(10);
        this.resultQueueCursor = -1;
    }

    public ResultQueueEntry getFirstEvent() {
        ResultQueueEntry resultQueueEntry = (ResultQueueEntry)this.resultQueue.getFirstEntry();
        this.resultQueueCursor = 0;
        return resultQueueEntry;
    }

    public ResultQueueEntry getLastEvent() {
        ResultQueueEntry resultQueueEntry = (ResultQueueEntry)this.resultQueue.getLastEntry();
        this.resultQueueCursor = this.resultQueue.getSize() - 1;
        return resultQueueEntry;
    }

    public ResultQueueEntry getNextEvent() {
        ResultQueueEntry resultQueueEntry = null;
        if (this.resultQueueCursor == this.resultQueue.getMaxSize() - 1) {
            this.resultQueue.remove();
            ++this.resultQueueBeginCount;
            resultQueueEntry = (ResultQueueEntry)this.resultQueue.get(this.resultQueueCursor);
        } else {
            resultQueueEntry = this.resultQueueCursor >= this.resultQueue.getSize() - 1 ? (ResultQueueEntry)this.resultQueue.get(this.resultQueueCursor) : (ResultQueueEntry)this.resultQueue.get(++this.resultQueueCursor);
        }
        return resultQueueEntry;
    }

    public boolean hasNext() {
        return this.getEventCount() > 0L && this.resultQueueCursor < this.resultQueue.getSize();
    }

    public boolean hasPrevious() {
        return this.getEventCount() > 0L && this.resultQueueCursor > 0;
    }

    public ResultQueueEntry getPreviousEvent() {
        ResultQueueEntry resultQueueEntry = null;
        resultQueueEntry = this.resultQueueCursor > 0 ? (ResultQueueEntry)this.resultQueue.get(--this.resultQueueCursor) : (ResultQueueEntry)this.resultQueue.get(this.resultQueueCursor);
        return resultQueueEntry;
    }

    public void loadTemplateFile() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block13: {
                    block12: {
                        block11: {
                            try {
                                try {
                                    AcadGuiModel.this.cycling = true;
                                    AcadGuiModel.this.resetValues();
                                    SensorConfigType sensorConfigType = AcadGuiModelManager.getLogForConfiguration(AcadGuiModel.this);
                                    if (sensorConfigType == null || AcadGuiModel.getProperty(sensorConfigType, "fileName") == null) {
                                        AcadGuiModel.this.updateTestShow();
                                        Object var5_3 = null;
                                        break block11;
                                    }
                                    String string = AcadGuiModel.this.context.eResource().getURI().path();
                                    if (string != null) {
                                        IResource iResource;
                                        if (string.startsWith("/resource")) {
                                            string = string.substring(10);
                                        }
                                        if ((iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(string))) != null || iResource.exists()) {
                                            string = iResource.getLocation().toOSString();
                                        }
                                    }
                                    if (AcadGuiModel.this.adaptor != null) {
                                        AcadGuiModel.this.resultQueue.flush();
                                        AcadGuiModel.this.resultQueue = null;
                                        AcadGuiModel.this.resultQueueBeginCount = 0;
                                        AcadGuiModel.this.resultQueueCursor = -1;
                                        AcadGuiModel.this.adaptor.hardStop();
                                        AcadGuiModel.this.resultQueue = new ResultQueue();
                                        LogView.getLogView(true).setContent("");
                                        ResultView.getResultView(true).setResult("");
                                        AcadGuiModel.this.setLogContent("");
                                    }
                                    try {
                                        AcadGuiModel.this.adaptor = new Adapter();
                                        AcadGuiModel.this.adaptor.setComponentConfigPath(string);
                                        AcadGuiModel.this.adaptor.setContextConfigPath(string);
                                        AcadGuiModel.this.adaptor.start(true, true);
                                    }
                                    catch (AdapterException adapterException) {
                                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)AcadEditorPlugin.getDefault().getString("STR_CONFIGURATION_FATAL_ERROR"), (String)(adapterException.getLocalizedMessage() == null ? AcadEditorPlugin.getDefault().getString("STR_CONFIGURATION_UNKNOWN_ERROR") : adapterException.getLocalizedMessage()));
                                    }
                                    break block12;
                                }
                                catch (Exception exception) {
                                    Status status = new Status(4, AcadEditorPlugin.getDefault().getPluginId(), 0, exception.getMessage(), (Throwable)exception);
                                    AcadEditorPlugin.getDefault().logMessage((IStatus)status, true);
                                    Object var5_5 = null;
                                    AcadGuiModel.this.cycling = false;
                                    break block13;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var5_6 = null;
                                AcadGuiModel.this.cycling = false;
                                throw throwable;
                            }
                        }
                        AcadGuiModel.this.cycling = false;
                        return;
                    }
                    Object var5_4 = null;
                    AcadGuiModel.this.cycling = false;
                }
                AcadGuiModel.this.updateTestShow();
            }
        });
    }

    public static PropertyType getProperty(SensorConfigType sensorConfigType, String string) {
        if (sensorConfigType == null || string == null) {
            return null;
        }
        Iterator iterator = sensorConfigType.getProperty().iterator();
        while (iterator.hasNext()) {
            PropertyType propertyType = (PropertyType)iterator.next();
            if (!string.equals(propertyType.getPropertyName())) continue;
            return propertyType;
        }
        return null;
    }

    public void updateTestShow() {
        LogView logView = LogView.getLogView(true);
        if (logView != null) {
            if (this.getEventCount() > 0L) {
                ContentView contentView;
                ResultView resultView = ResultView.getResultView(false);
                if (resultView != null) {
                    resultView.reset();
                }
                if ((contentView = ContentView.getContentView(false)) != null) {
                    contentView.showLog();
                    contentView.set_Title();
                }
                logView.showFirstEvent();
            } else {
                logView.reset();
                logView.enableActions();
                logView.set_Title();
            }
        }
    }

    public void updateResult() {
        ISerializableAsXml iSerializableAsXml;
        if (this.cycling) {
            return;
        }
        ResultView resultView = ResultView.getResultView(true);
        if (resultView != null && this.resultQueueCursor >= 0 && (iSerializableAsXml = (ISerializableAsXml)((ResultQueueEntry)this.resultQueue.get((int)this.resultQueueCursor)).formatterOutput) != null) {
            resultView.setResult(iSerializableAsXml.externalizeCanonicalXmlString());
        }
    }

    public void updateTemplateLog() {
        if (this.cycling) {
            return;
        }
        LogView logView = LogView.getLogView(true);
        if (logView != null) {
            logView.set_Title();
            logView.enableActions();
        }
    }

    public void updateLogContent() {
        if (this.cycling) {
            return;
        }
        ContentView contentView = ContentView.getContentView(false);
        if (contentView != null && this.resultQueueCursor < 0) {
            contentView.setContent(this.logContent);
        }
    }

    public long getCurrentCount() {
        return this.resultQueueCursor + this.resultQueueBeginCount;
    }

    public long getEventCount() {
        return this.resultQueueBeginCount + this.resultQueue.getSize();
    }

    public void dispose() {
        this.logContent = "";
        this.resultQueueBeginCount = 0;
        this.resultQueueCursor = -1;
        this.resultQueue.flush();
        this.resultQueue = null;
        this.context = null;
        this.adaptor = null;
        if (this.contextListener != null) {
            this.contextListener.setContext(null);
        }
        this.contextListener = null;
        LogView logView = LogView.getLogView(false);
        if (logView != null) {
            logView.reset();
        }
    }

    public void resetValues() {
        this.logContent = "";
    }

    public ContextInstanceType getContextInstance() {
        return this.context;
    }

    public void setContextInstance(ContextInstanceType contextInstanceType) {
        this.context = contextInstanceType;
    }

    public String getLogContent() {
        return this.logContent;
    }

    public void setLogContent(String string) {
        this.logContent = string;
    }

    public TestContextListener getContextListener() {
        return this.contextListener;
    }

    public void setContextListener(TestContextListener testContextListener) {
        this.contextListener = testContextListener;
    }

    public ResultQueue getResultQueue() {
        return this.resultQueue;
    }

    public int getResultQueueBeginCount() {
        return this.resultQueueBeginCount;
    }

    public int getStartRecord() {
        return this.startRecord;
    }

    public void setStartRecord(int n) {
        this.startRecord = n;
    }
}

