/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.commons;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.eclipse.hyades.internal.logging.core.XmlGenerator;
import org.eclipse.hyades.logging.core.IExternalizableToXml;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.StartSituation;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryContext;

public class FileLogger
implements Log {
    public static final int TRACE_LEVEL = 0;
    public static final int DEBUG_LEVEL = 1;
    public static final int INFO_LEVEL = 2;
    public static final int WARN_LEVEL = 3;
    public static final int ERROR_LEVEL = 4;
    public static final int FATAL_LEVEL = 5;
    private static final String[] LEVEL_NAMES = new String[]{"TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL"};
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private int level = 3;
    private String name = null;
    private XmlGenerator xmlGenerator = null;
    private BufferedWriter fileWriter = null;
    private String fileName = null;
    private CommonBaseEvent startEvent = null;
    private CommonBaseEvent stopEvent = null;
    private static String localHostIP = null;

    public FileLogger(String string) {
        this.name = string;
        this.xmlGenerator = new XmlGenerator(string);
        this.createStartStopEvents();
        this.configure();
    }

    public boolean isTraceEnabled() {
        return this.level <= 0;
    }

    public boolean isDebugEnabled() {
        return this.level <= 1;
    }

    public boolean isInfoEnabled() {
        return this.level <= 2;
    }

    public boolean isWarnEnabled() {
        return this.level <= 3;
    }

    public boolean isErrorEnabled() {
        return this.level <= 4;
    }

    public boolean isFatalEnabled() {
        return this.level <= 5;
    }

    public void trace(Object object) {
        if (this.isTraceEnabled()) {
            this.write(this.convertToXML(object));
        }
    }

    public void trace(Object object, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.write(this.convertToXML(object));
            this.write(this.convertToXML(throwable));
        }
    }

    public void debug(Object object) {
        if (this.isDebugEnabled()) {
            this.write(this.convertToXML(object));
        }
    }

    public void debug(Object object, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.write(this.convertToXML(object));
            this.write(this.convertToXML(throwable));
        }
    }

    public void info(Object object) {
        if (this.isInfoEnabled()) {
            this.write(this.convertToXML(object));
        }
    }

    public void info(Object object, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.write(this.convertToXML(object));
            this.write(this.convertToXML(throwable));
        }
    }

    public void warn(Object object) {
        if (this.isWarnEnabled()) {
            this.write(this.convertToXML(object));
        }
    }

    public void warn(Object object, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.write(this.convertToXML(object));
            this.write(this.convertToXML(throwable));
        }
    }

    public void error(Object object) {
        if (this.isErrorEnabled()) {
            this.write(this.convertToXML(object));
        }
    }

    public void error(Object object, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.write(this.convertToXML(object));
            this.write(this.convertToXML(throwable));
        }
    }

    public void fatal(Object object) {
        if (this.isFatalEnabled()) {
            this.write(this.convertToXML(object));
        }
    }

    public void fatal(Object object, Throwable throwable) {
        if (this.isFatalEnabled()) {
            this.write(this.convertToXML(object));
            this.write(this.convertToXML(throwable));
        }
    }

    public String getName() {
        return this.name;
    }

    public synchronized void setFileName(String string) throws IllegalArgumentException {
        this.fileName = string;
        try {
            this.openLogFile();
        }
        catch (IOException iOException) {
            this.fileName = null;
            throw new IllegalArgumentException("Invalid log file path");
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public final void finalize() {
        this.closeLogFile();
    }

    public boolean isLogging() {
        return this.fileWriter != null;
    }

    private void closeLogFile() {
        if (this.isLogging()) {
            this.writeStopEvent();
            try {
                this.fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.fileWriter = null;
    }

    private void openLogFile() throws IOException {
        this.fileWriter = new BufferedWriter(new FileWriter(this.fileName, true));
        this.writeStartEvent();
    }

    public int getLevel() {
        return this.level;
    }

    public String getLevelAsString() {
        return LEVEL_NAMES[this.level];
    }

    public synchronized void setLevel(int n) throws IllegalArgumentException {
        if (!this.isValidLevel(n)) {
            throw new IllegalArgumentException("Invalid logging level");
        }
        this.level = n;
    }

    public synchronized void setLevelAsString(String string) throws IllegalArgumentException {
        this.setLevel(this.getLevelInteger(string));
    }

    private int getLevelInteger(String string) {
        block5: {
            if (string == null || string.trim().length() == 0) break block5;
            String string2 = string.trim();
            int n = 0;
            while (n < LEVEL_NAMES.length) {
                if (string2.equalsIgnoreCase(LEVEL_NAMES[n])) {
                    return n;
                }
                ++n;
            }
            try {
                int n2 = Integer.parseInt(string2);
                if (this.isValidLevel(n2)) {
                    return n2;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return -1;
    }

    private boolean isValidLevel(int n) {
        return n >= 0 || n <= 5;
    }

    private boolean isValidLevelString(String string) {
        return this.isValidLevel(this.getLevelInteger(string));
    }

    private String convertToXML(Object object) {
        if (object instanceof IExternalizableToXml) {
            return ((IExternalizableToXml)object).externalizeCanonicalXmlString();
        }
        this.xmlGenerator.reset(LEVEL_NAMES[this.level], false, 4);
        return this.xmlGenerator.objectToXML(object);
    }

    private void write(String string) {
        block2: {
            if (!this.isLogging()) break block2;
            try {
                this.fileWriter.write(string);
                this.fileWriter.flush();
                this.fileWriter.write(LINE_SEPARATOR);
                this.fileWriter.flush();
            }
            catch (IOException iOException) {}
        }
    }

    private void configure() {
        String string = System.getProperty("org.eclipse.hyades.logging.commons.FileLogger.FileName");
        if (string != null && string.trim().length() > 0) {
            this.setFileName(string);
        }
        if ((string = System.getProperty("org.eclipse.hyades.logging.commons.FileLogger.Level")) != null && string.trim().length() > 0 && this.isValidLevelString(string)) {
            this.setLevelAsString(string);
        }
    }

    private void createStartStopEvents() {
        EventFactory eventFactory = EventFactoryContext.getInstance().getEventFactoryHome("org.eclipse.hyades.logging.events.cbe.impl.SimpleEventFactoryHomeImpl").getEventFactory(this.name);
        this.startEvent = eventFactory.createCommonBaseEvent();
        ComponentIdentification componentIdentification = eventFactory.createComponentIdentification();
        componentIdentification.setLocation(localHostIP);
        componentIdentification.setLocationType("IPV4");
        componentIdentification.setComponent("org.eclipse.hyades.logging.commons");
        componentIdentification.setSubComponent("FileLogger");
        componentIdentification.setComponentIdType("Application");
        componentIdentification.setComponentType("ApacheCommonsLog");
        this.startEvent.setSourceComponentId(componentIdentification);
        StartSituation startSituation = eventFactory.createStartSituation();
        startSituation.setReasoningScope("INTERNAL");
        startSituation.setSituationQualifier("START COMPLETED");
        startSituation.setSuccessDisposition("SUCCESSFUL");
        Situation situation = eventFactory.createSituation();
        situation.setCategoryName("StartSituation");
        situation.setSituationType((SituationType)startSituation);
        this.startEvent.setSituation(situation);
        this.stopEvent = eventFactory.createCommonBaseEvent();
        ComponentIdentification componentIdentification2 = eventFactory.createComponentIdentification();
        componentIdentification2.setLocation(localHostIP);
        componentIdentification2.setLocationType("IPV4");
        componentIdentification2.setComponent("org.eclipse.hyades.logging.commons");
        componentIdentification2.setSubComponent("FileLogger");
        componentIdentification2.setComponentIdType("Application");
        componentIdentification2.setComponentType("ApacheCommonsLog");
        this.stopEvent.setSourceComponentId(componentIdentification2);
        StartSituation startSituation2 = eventFactory.createStartSituation();
        startSituation2.setReasoningScope("INTERNAL");
        startSituation2.setSituationQualifier("STOP COMPLETED");
        startSituation2.setSuccessDisposition("SUCCESSFUL");
        Situation situation2 = eventFactory.createSituation();
        situation2.setCategoryName("StopSituation");
        situation2.setSituationType((SituationType)startSituation2);
        this.stopEvent.setSituation(situation2);
    }

    private void writeStartEvent() {
        this.startEvent.setCreationTimeAsLong(System.currentTimeMillis());
        this.write(this.convertToXML(this.startEvent));
    }

    private void writeStopEvent() {
        this.stopEvent.setCreationTimeAsLong(System.currentTimeMillis());
        this.write(this.convertToXML(this.stopEvent));
    }

    static {
        try {
            localHostIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            localHostIP = "127.0.0.1";
        }
    }
}

