/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.sample.loganalyzer;

import java.lang.reflect.InvocationTargetException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.logging.parsers.ApacheAccessLogParser;
import org.eclipse.hyades.logging.parsers.ApacheErrorLogParser;
import org.eclipse.hyades.logging.parsers.Parser;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.trace.sample.HyadesSamplePlugin;
import org.eclipse.hyades.trace.sample.loganalyzer.AnalyzeCorrelateOperation;
import org.eclipse.hyades.trace.sample.loganalyzer.AnalyzeLogAction;
import org.eclipse.hyades.trace.sample.loganalyzer.CorrelateLogAction;
import org.eclipse.hyades.trace.sample.loganalyzer.LogAnalyzerCreationPage;
import org.eclipse.hyades.trace.sample.loganalyzer.LogAnalyzerSamplePage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.util.CoreUtil;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizard;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizardPage;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.ZipAdjusterCreationWizard;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class LogAnalyzerCreationWizard
extends ZipAdjusterCreationWizard {
    LogAnalyzerCreationPage pageOne = null;
    LogAnalyzerSamplePage pageTwo = null;
    private ResourceBundle resourceBundle;

    protected void addZipExtensions() {
        this.addZipExtension("trcpxmi");
        this.addZipExtension("trcaxmi");
        this.addZipExtension("trcdbxmi");
        this.setResourceBundle(HyadesSamplePlugin.getInstance().getResourceBundle());
    }

    protected void logError(String string) {
        HyadesSamplePlugin.logError(string);
    }

    protected CreationWizardPage createWizardPage(String string, IConfigurationElement iConfigurationElement) {
        if (string.equals("newProject1")) {
            this.pageTwo = new LogAnalyzerSamplePage((CreationWizard)this, string, iConfigurationElement, this.pageOne);
            return this.pageTwo;
        }
        this.pageOne = new LogAnalyzerCreationPage((CreationWizard)this, string, iConfigurationElement);
        return this.pageOne;
    }

    public boolean correlateAccessLog(AnalyzeCorrelateOperation analyzeCorrelateOperation) {
        CorrelateLogAction correlateLogAction = null;
        WorkspaceModifyDelegatingOperation workspaceModifyDelegatingOperation = new WorkspaceModifyDelegatingOperation(correlateLogAction);
        TRCMonitor tRCMonitor = analyzeCorrelateOperation.getTRCMonitor();
        correlateLogAction = new CorrelateLogAction();
        correlateLogAction.setMofObject((EObject)tRCMonitor);
        workspaceModifyDelegatingOperation = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)correlateLogAction);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)workspaceModifyDelegatingOperation);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleException(invocationTargetException.getTargetException());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        correlateLogAction.dispose();
        return true;
    }

    public boolean analyzeErrorLog(String string, String string2, String string3, AnalyzeCorrelateOperation analyzeCorrelateOperation) {
        AnalyzeLogAction analyzeLogAction = null;
        TRCAgentProxy tRCAgentProxy = analyzeCorrelateOperation.getAgent().getAgentProxy();
        analyzeLogAction = new AnalyzeLogAction();
        analyzeLogAction.setSymptomDBPath(string3);
        analyzeLogAction.setProjectName(string);
        analyzeLogAction.setSDBFileName(string2);
        analyzeLogAction.setMofObject((EObject)tRCAgentProxy);
        WorkspaceModifyDelegatingOperation workspaceModifyDelegatingOperation = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)analyzeLogAction);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)workspaceModifyDelegatingOperation);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleException(invocationTargetException.getTargetException());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public AnalyzeCorrelateOperation importLogFile(String string, Parser parser, String string2) {
        IWorkbenchPage iWorkbenchPage;
        INavigator iNavigator = null;
        AnalyzeCorrelateOperation analyzeCorrelateOperation = null;
        try {
            iWorkbenchPage = UIPlugin.getActivePage();
            iNavigator = (INavigator)iWorkbenchPage.showView("org.eclipse.hyades.log.ui.internal.navigator.LogNavigator");
        }
        catch (Exception exception) {
            return null;
        }
        analyzeCorrelateOperation = new AnalyzeCorrelateOperation(parser, string2);
        analyzeCorrelateOperation.setFViewer(iNavigator);
        analyzeCorrelateOperation.setLogFilePath(string);
        analyzeCorrelateOperation.setProjectName(this.pageOne.getProjectName());
        analyzeCorrelateOperation.setTcMonitor("LogCorrelationAnalyzerSample_TCMonitor");
        iWorkbenchPage = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)analyzeCorrelateOperation);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)iWorkbenchPage);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleException(invocationTargetException.getTargetException());
            return null;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        analyzeCorrelateOperation.dispose();
        return analyzeCorrelateOperation;
    }

    protected boolean finishWork() {
        AnalyzeCorrelateOperation analyzeCorrelateOperation = this.importLogFile(this.pageTwo.getLogPath(), (Parser)new ApacheAccessLogParser(), HyadesSamplePlugin.getString("LOG_FILE_LABEL"));
        AnalyzeCorrelateOperation analyzeCorrelateOperation2 = this.importLogFile(this.pageTwo.getErrorLogPath(), (Parser)new ApacheErrorLogParser(), HyadesSamplePlugin.getString("ERRORLOG_FILE_LABEL"));
        if (this.pageTwo.getAnalyzeLogButton().getSelection()) {
            this.analyzeErrorLog(this.pageTwo.getProjectName(), this.pageTwo.getSDBFileName(), this.pageTwo.getSymptomDBFilePath(), analyzeCorrelateOperation2);
        }
        if (this.pageTwo.getCorrelateLogButton().getSelection()) {
            this.correlateAccessLog(analyzeCorrelateOperation);
        }
        return true;
    }

    private void handleException(Throwable throwable) {
        this.logError(CoreUtil.getStackTrace((Throwable)throwable));
        String[] stringArray = new String[]{IDialogConstants.OK_LABEL};
        MessageDialog messageDialog = new MessageDialog(this.getShell(), this.getString("W_ERROR"), null, this.getString("ERR_UNABLE_CREATE"), 1, stringArray, 0);
    }

    protected String getString(String string) {
        if (this.resourceBundle != null) {
            try {
                return this.resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return string;
    }

    protected String getString(String string, String[] stringArray) {
        String string2 = this.getString(string);
        int n = stringArray.length;
        while (n > 0) {
            string2 = StringUtil.replace((String)string2, (String)("%" + n), (String)stringArray[n - 1]);
            --n;
        }
        return string2;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public LogAnalyzerSamplePage getPageTwo() {
        return this.pageTwo;
    }
}

