/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.preferences;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.CBEFilterUI;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.RecordChangeEvent;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogAnalyzerFilterPrefPage
implements SelectionListener {
    private boolean sevHasChanged = false;
    private CBEFilterUI _options;
    private IPreferenceStore _preferenceStore;
    private boolean filterHasChanged = false;

    public LogAnalyzerFilterPrefPage(IPreferenceStore iPreferenceStore) {
        this._preferenceStore = iPreferenceStore;
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        composite2.setLayoutData((Object)gridData);
        this._options = new CBEFilterUI();
        this._options.createControl(composite2);
        this.initializeValues();
        this._options.addListener(this);
        WorkbenchHelp.setHelp((Control)composite2, (String)ContextIds.ACTLOG_PREF_FILTER_PROPERTIES);
        return composite2;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return LogUIPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench iWorkbench) {
    }

    private void initializeDefaults() {
        IPreferenceStore iPreferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        this._options.initializeValues(true);
    }

    private void initializeValues() {
        IPreferenceStore iPreferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        this._options.initializeValues(false);
    }

    protected void performDefaults() {
        this.initializeDefaults();
    }

    public boolean performOk() {
        if (!this.storeValues()) {
            return false;
        }
        LogUIPlugin.getDefault().savePluginPreferences();
        this._options.removeListener(this);
        if (this.filterHasChanged) {
            LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(1, this));
        }
        if (this.sevHasChanged) {
            LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(2, this));
        }
        this.filterHasChanged = false;
        this.sevHasChanged = false;
        return true;
    }

    public boolean performApply() {
        if (!this.storeValues()) {
            return false;
        }
        LogUIPlugin.getDefault().savePluginPreferences();
        if (this.filterHasChanged) {
            LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(1, this));
        }
        if (this.sevHasChanged) {
            LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(2, this));
        }
        this.filterHasChanged = false;
        this.sevHasChanged = false;
        return true;
    }

    private boolean storeValues() {
        return this._options.storeValues(this._preferenceStore);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        Widget widget = selectionEvent.widget;
        if (widget instanceof Button && (((Button)widget).getStyle() & 0x20) == 32) {
            this.sevHasChanged = true;
        } else if (widget == this._options.getControl()) {
            this.sevHasChanged = true;
            this.filterHasChanged = true;
        } else {
            this.filterHasChanged = true;
        }
    }
}

