/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.views;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.analysis.engine.ISymptomDatabase;
import org.eclipse.hyades.analysis.engine.Incident;
import org.eclipse.hyades.analysis.engine.Solution;
import org.eclipse.hyades.models.internal.sdb.SDBFactory;
import org.eclipse.hyades.models.internal.sdb.SDBMatchPattern;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;
import org.eclipse.hyades.models.internal.sdb.impl.SDBResourceSetImpl;

final class XMISymptomDatabase
implements ISymptomDatabase {
    private SDBRuntime fDatabase = null;
    private String symptomDBPath = null;

    XMISymptomDatabase() {
    }

    public String getPath() {
        return this.symptomDBPath;
    }

    public synchronized boolean load() {
        this.unload();
        this.fDatabase = this.loadDatabase(this.symptomDBPath);
        return this.fDatabase != null;
    }

    public synchronized boolean unload() {
        SDBResourceSetImpl sDBResourceSetImpl = SDBResourceSetImpl.getInstance();
        if (this.fDatabase != null && sDBResourceSetImpl != null) {
            sDBResourceSetImpl.getResources().remove((Object)this.fDatabase.eResource());
        }
        this.fDatabase = null;
        return true;
    }

    public synchronized boolean merge(String string) {
        SDBRuntime sDBRuntime = this.loadDatabase(string);
        if (sDBRuntime == null) {
            return false;
        }
        if (this.fDatabase == null) {
            this.fDatabase = sDBRuntime;
        } else {
            EList eList = sDBRuntime.getSymptoms();
            int n = 0;
            while (n < eList.size()) {
                SDBSymptom sDBSymptom;
                SDBSymptom sDBSymptom2 = (SDBSymptom)eList.get(n);
                boolean bl = false;
                EList eList2 = this.fDatabase.getSymptoms();
                int n2 = 0;
                while (n2 < eList2.size()) {
                    sDBSymptom = (SDBSymptom)eList2.get(n2);
                    if (sDBSymptom2.getDescription().equals(sDBSymptom.getDescription())) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    EList eList3;
                    sDBSymptom = SDBFactory.eINSTANCE.createSDBSymptom();
                    sDBSymptom.setDescription(sDBSymptom2.getDescription());
                    this.fDatabase.getSymptoms().add((Object)sDBSymptom);
                    EList eList4 = sDBSymptom2.getPatterns();
                    int n3 = 0;
                    while (n3 < eList4.size()) {
                        eList3 = (SDBMatchPattern)eList4.get(n3);
                        SDBMatchPattern sDBMatchPattern = SDBFactory.eINSTANCE.createSDBMatchPattern();
                        sDBMatchPattern.setName(eList3.getName());
                        sDBMatchPattern.setValue(eList3.getValue());
                        sDBSymptom.getPatterns().add((Object)sDBMatchPattern);
                        ++n3;
                    }
                    eList3 = sDBSymptom2.getSolutions();
                    int n4 = 0;
                    while (n4 < eList3.size()) {
                        SDBSolution sDBSolution = (SDBSolution)eList3.get(n4);
                        SDBSolution sDBSolution2 = SDBFactory.eINSTANCE.createSDBSolution();
                        sDBSolution2.setDescription(sDBSolution.getDescription());
                        sDBSymptom.getSolutions().add((Object)sDBSolution2);
                        this.fDatabase.getSolutions().add((Object)sDBSolution2);
                        ++n4;
                    }
                }
                ++n;
            }
        }
        return true;
    }

    public Solution[] getSolutions(Incident incident) {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Object[] getDirectives(Incident var1_1) {
        block8: {
            var2_2 = new ArrayList<SDBSymptom>();
            if (this.fDatabase == null || (var3_3 = var1_1.getMessageId()) == null || var3_3.trim().equals("")) break block8;
            var4_4 = this.fDatabase.getSymptoms();
            var6_5 = false;
            var7_6 = 0;
            while (var7_6 < var4_4.size()) {
                block9: {
                    block10: {
                        var8_7 = (SDBSymptom)var4_4.get(var7_6);
                        if (var8_7 == null) break block9;
                        var9_8 = var8_7.getPatterns();
                        if (var9_8.size() != 0) break block10;
                        var6_5 = true;
                        if (!var8_7.getDescription().trim().equals("") && var3_3.indexOf(var8_7.getDescription()) != -1) ** GOTO lbl-1000
                        var6_5 = false;
                        break block9;
                    }
                    var10_9 = 0;
                    var6_5 = var9_8.size() > 0;
                    var11_10 = 0;
                    while (var11_10 < var9_8.size()) {
                        var12_11 = (SDBMatchPattern)var9_8.get(var11_10);
                        if (var12_11.getValue().equals("")) {
                            ++var10_9;
                        } else if (var3_3.indexOf(var12_11.getValue()) == -1) {
                            var6_5 = false;
                            break;
                        }
                        ++var11_10;
                    }
                    if (var10_9 != var9_8.size()) ** GOTO lbl-1000
                    var6_5 = true;
                    if (var3_3.indexOf(var8_7.getDescription()) == -1) {
                        var6_5 = false;
                    } else if (var6_5) {
                        var2_2.add(var8_7);
                    }
                }
                ++var7_6;
            }
        }
        return var2_2.toArray();
    }

    private SDBRuntime loadDatabase(String string) {
        try {
            Resource resource = null;
            SDBResourceSetImpl sDBResourceSetImpl = SDBResourceSetImpl.getInstance();
            if (sDBResourceSetImpl != null) {
                resource = string.startsWith("platform:/resource") ? sDBResourceSetImpl.getResource(URI.createURI((String)string), true) : sDBResourceSetImpl.getResource(URI.createFileURI((String)string), true);
            }
            Iterator iterator = resource.getContents().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof SDBRuntime)) continue;
                return (SDBRuntime)e;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return null;
    }

    public boolean replace(String string) {
        this.symptomDBPath = string;
        if (this.symptomDBPath == null) {
            return this.unload();
        }
        return this.load();
    }
}

