/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.eclipse.hyades.internal.logging.core.XmlGenerator;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.Parser;

public class LocalLogParserLoader
implements Log {
    private Hashtable parserParameters = null;
    private Parser parser = null;
    private XmlGenerator xmlGenerator = new XmlGenerator();
    private XMLLoader xmlLoader = null;
    private boolean first = true;
    public static final int TRACE_LEVEL = 0;
    public static final int DEBUG_LEVEL = 1;
    public static final int INFO_LEVEL = 2;
    public static final int WARN_LEVEL = 3;
    public static final int ERROR_LEVEL = 4;
    public static final int FATAL_LEVEL = 5;
    private int loggingLevel;

    public LocalLogParserLoader(Parser parser, Hashtable hashtable) {
        this.parser = parser;
        this.parserParameters = hashtable;
        this.loggingLevel = 0;
        this.xmlGenerator.reset(null, true, 8);
    }

    public void setXMLLoader(XMLLoader xMLLoader) {
        this.xmlLoader = xMLLoader;
    }

    public void startParsing() throws LogParserException {
        this.parser.setUserInput(this.parserParameters);
        this.parser.parse((Log)this);
    }

    private void logXMLToModel(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        this.xmlLoader.loadEvent(byArray, byArray.length);
    }

    public boolean isTraceEnabled() {
        return this.loggingLevel <= 0;
    }

    public boolean isDebugEnabled() {
        return this.loggingLevel <= 1;
    }

    public boolean isInfoEnabled() {
        return this.loggingLevel <= 2;
    }

    public boolean isWarnEnabled() {
        return this.loggingLevel <= 3;
    }

    public boolean isErrorEnabled() {
        return this.loggingLevel <= 4;
    }

    public boolean isFatalEnabled() {
        return this.loggingLevel <= 5;
    }

    public void trace(Object object) {
        try {
            if (this.isTraceEnabled()) {
                this.logXMLToModel(this.xmlGenerator.objectToXML(object));
            }
        }
        catch (Throwable throwable) {}
    }

    public void trace(Object object, Throwable throwable) {
        try {
            if (this.isTraceEnabled()) {
                this.logXMLToModel(this.xmlGenerator.objectToXML(object));
            }
        }
        catch (Throwable throwable2) {}
    }

    public void debug(Object object) {
        try {
            if (this.isDebugEnabled()) {
                this.logXMLToModel(this.xmlGenerator.objectToXML(object));
            }
        }
        catch (Throwable throwable) {}
    }

    public void debug(Object object, Throwable throwable) {
        try {
            if (this.isDebugEnabled()) {
                this.logXMLToModel(this.xmlGenerator.objectToXML(object));
            }
        }
        catch (Throwable throwable2) {}
    }

    public void info(Object object) {
        try {
            if (this.isInfoEnabled()) {
                this.logXMLToModel(this.xmlGenerator.objectToXML(object));
            }
        }
        catch (Throwable throwable) {}
    }

    public void info(Object object, Throwable throwable) {
        try {
            if (this.isInfoEnabled()) {
                this.logXMLToModel(this.xmlGenerator.objectToXML(object));
            }
        }
        catch (Throwable throwable2) {}
    }

    public void warn(Object object) {
        try {
            if (this.isWarnEnabled()) {
                this.logXMLToModel(this.xmlGenerator.objectToXML(object));
            }
        }
        catch (Throwable throwable) {}
    }

    public void warn(Object object, Throwable throwable) {
        try {
            if (this.isWarnEnabled()) {
                this.logXMLToModel(this.xmlGenerator.objectToXML(object));
            }
        }
        catch (Throwable throwable2) {}
    }

    public void error(Object object) {
        try {
            if (this.isErrorEnabled()) {
                this.logXMLToModel(this.xmlGenerator.objectToXML(object));
            }
        }
        catch (Throwable throwable) {}
    }

    public void error(Object object, Throwable throwable) {
        try {
            if (this.isErrorEnabled()) {
                this.logXMLToModel(this.xmlGenerator.objectToXML(object));
            }
        }
        catch (Throwable throwable2) {}
    }

    public void fatal(Object object) {
        try {
            if (this.isFatalEnabled()) {
                this.logXMLToModel(this.xmlGenerator.objectToXML(object));
            }
        }
        catch (Throwable throwable) {}
    }

    public void fatal(Object object, Throwable throwable) {
        try {
            if (this.isFatalEnabled()) {
                this.logXMLToModel(this.xmlGenerator.objectToXML(object));
            }
        }
        catch (Throwable throwable2) {}
    }
}

