/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.wizards.LogSetDialog;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class LogSetUI
implements Listener,
SelectionListener {
    private Text txtLogSetName;
    private LogSetDialog dialog;
    private org.eclipse.swt.widgets.List lstLogSets;
    private Button btnRename;
    private Button btnRemove;
    private Label lblError;

    public LogSetUI(LogSetDialog logSetDialog) {
        this.dialog = logSetDialog;
    }

    public void createContent(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = GridUtil.createFill();
        gridData.widthHint = 400;
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this.createWidgets(composite2, n);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.txtLogSetName) {
            if (this.txtLogSetName.getText().length() == 0 || this.dialog.getLogSets().get(this.txtLogSetName.getText()) != null) {
                this.dialog.setOKButtonEnabled(false);
            } else {
                this.dialog.setOKButtonEnabled(true);
            }
            if (this.dialog.getLogSets().get(this.txtLogSetName.getText()) != null) {
                this.lblError.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOGSET_ERR"));
            } else {
                this.lblError.setText("");
            }
            this.dialog.setDefaultLogSet(this.txtLogSetName.getText());
        } else if (event.widget == this.lstLogSets) {
            if (!this.lstLogSets.getItem(this.lstLogSets.getSelectionIndex()).equals(this.dialog.getDefaultLogSet())) {
                this.dialog.setLogSetSelectionChanged(true);
            }
            this.dialog.setDefaultLogSet(this.lstLogSets.getItem(this.lstLogSets.getSelectionIndex()));
        } else if (event.widget == this.btnRename) {
            LogSetDialog logSetDialog = new LogSetDialog(this.dialog.getShell(), 3);
            logSetDialog.setLogSets(this.dialog.getLogSets());
            logSetDialog.setLogSetName(this.lstLogSets.getItem(this.lstLogSets.getSelectionIndex()));
            int n = this.lstLogSets.getSelectionIndex();
            if (logSetDialog.open() == 0) {
                this.renameLogSet(n, this.lstLogSets.getItem(n), logSetDialog.getDefaultLogSet());
            }
        } else if (event.widget == this.btnRemove) {
            Map map = this.dialog.getLogSets();
            String string = this.lstLogSets.getItem(this.lstLogSets.getSelectionIndex());
            map.remove(string);
            this.lstLogSets.remove(this.lstLogSets.getSelectionIndex());
            if (string.equals(this.dialog.getDefaultLogSet())) {
                if (this.lstLogSets.getItemCount() > 0) {
                    this.dialog.setDefaultLogSet(this.lstLogSets.getItem(0));
                } else {
                    this.dialog.setDefaultLogSet(null);
                }
                this.dialog.setLogSetSelectionChanged(true);
            }
            if (string.equals(this.dialog.getCurrentLogSet())) {
                this.dialog.setCurrentLogSetChanged(true);
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.btnRemove != null && this.btnRename != null) {
            if (this.lstLogSets.getSelectionIndex() < 0) {
                this.btnRemove.setEnabled(false);
                this.btnRename.setEnabled(false);
            } else {
                this.btnRemove.setEnabled(true);
                this.btnRename.setEnabled(true);
            }
        }
    }

    private void createWidgets(Composite composite, int n) {
        switch (n) {
            case 0: {
                this.createNewLogSetUI(composite);
                break;
            }
            case 1: {
                this.createOpenLogSetUI(composite);
                break;
            }
            case 2: {
                this.createEditLogSetUI(composite);
                break;
            }
            case 3: {
                this.createRenameLogSetUI(composite);
            }
        }
    }

    private void createNewLogSetUI(Composite composite) {
        Label label = new Label(composite, 64);
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        gridData.heightHint = this.computeLabelMinHeight(label);
        label.setLayoutData((Object)gridData);
        label.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_NEW_MSG"));
        this.createSpace(composite);
        Label label2 = new Label(composite, 0);
        gridData = new GridData(1);
        label2.setLayoutData((Object)gridData);
        label2.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_SET_LBL"));
        this.txtLogSetName = new Text(composite, 2048);
        gridData = GridUtil.createHorizontalFill();
        this.txtLogSetName.setLayoutData((Object)gridData);
        this.lblError = new Label(composite, 64);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        this.lblError.setLayoutData((Object)gridData);
        this.lblError.setForeground(JFaceColors.getErrorText((Display)this.dialog.getShell().getDisplay()));
        this.txtLogSetName.addListener(24, (Listener)this);
    }

    private void createRenameLogSetUI(Composite composite) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData(1);
        label.setLayoutData((Object)gridData);
        label.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_SET_LBL"));
        this.txtLogSetName = new Text(composite, 2048);
        gridData = GridUtil.createHorizontalFill();
        this.txtLogSetName.setLayoutData((Object)gridData);
        this.txtLogSetName.setText(this.dialog.getLogSetName() != null ? this.dialog.getLogSetName() : "");
        this.txtLogSetName.selectAll();
        this.lblError = new Label(composite, 64);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        this.lblError.setLayoutData((Object)gridData);
        this.lblError.setForeground(JFaceColors.getErrorText((Display)this.dialog.getShell().getDisplay()));
        this.txtLogSetName.addListener(24, (Listener)this);
    }

    private void createOpenLogSetUI(Composite composite) {
        Label label = new Label(composite, 64);
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        gridData.heightHint = this.computeLabelMinHeight(label);
        label.setLayoutData((Object)gridData);
        label.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_OPEN_MSG"));
        this.createSpace(composite);
        Label label2 = new Label(composite, 0);
        gridData = GridUtil.createHorizontalFill();
        label2.setLayoutData((Object)gridData);
        label2.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_SETS"));
        this.lstLogSets = new org.eclipse.swt.widgets.List(composite, 2816);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        this.lstLogSets.setLayoutData((Object)gridData);
        this.loadLogSetsList();
        this.selectDefaultLogSet();
        this.lstLogSets.addListener(13, (Listener)this);
        this.lstLogSets.addSelectionListener((SelectionListener)this);
    }

    private void createEditLogSetUI(Composite composite) {
        Label label = new Label(composite, 64);
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_EDIT_MSG"));
        this.createSpace(composite);
        Label label2 = new Label(composite, 0);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        label2.setLayoutData((Object)gridData);
        label2.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_SETS"));
        this.lstLogSets = new org.eclipse.swt.widgets.List(composite, 2816);
        gridData = GridUtil.createHorizontalFill();
        gridData.widthHint = 300;
        this.lstLogSets.setLayoutData((Object)gridData);
        Composite composite2 = new Composite(composite, 0);
        composite.setLayoutData((Object)GridUtil.createFill());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        this.btnRename = new Button(composite2, 8);
        int n = this.computeButtonsMinWidth((Control)this.btnRename);
        this.btnRename.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_RENAME_SET"));
        GridData gridData2 = GridUtil.createHorizontalFill();
        gridData2.widthHint = n;
        gridData2.horizontalAlignment = 2;
        this.btnRename.setLayoutData((Object)gridData2);
        this.btnRemove = new Button(composite2, 8);
        this.btnRemove.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_REMOVE_SET"));
        gridData2 = GridUtil.createHorizontalFill();
        gridData2.widthHint = n;
        gridData2.horizontalAlignment = 2;
        this.btnRemove.setLayoutData((Object)gridData2);
        this.loadLogSetsList();
        this.selectDefaultLogSet();
        this.lstLogSets.addListener(13, (Listener)this);
        this.btnRename.addListener(13, (Listener)this);
        this.btnRemove.addListener(13, (Listener)this);
        this.updateButtons();
    }

    private void loadLogSetsList() {
        Set set = this.dialog.getLogSets().keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.lstLogSets.add((String)iterator.next());
        }
    }

    private void createSpace(Composite composite) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
    }

    private void renameLogSet(int n, String string, String string2) {
        Map map = this.dialog.getLogSets();
        List list = (List)map.get(string);
        map.remove(string);
        map.put(string2, list);
        this.lstLogSets.remove(n);
        this.lstLogSets.add(string2, n);
        if (string.equals(this.dialog.getDefaultLogSet())) {
            this.dialog.setDefaultLogSet(string2);
        }
        if (string.equals(this.dialog.getCurrentLogSet())) {
            this.dialog.setCurrentLogSetChanged(true);
        }
    }

    private void selectDefaultLogSet() {
        String string = this.dialog.getDefaultLogSet();
        if (string != null) {
            this.lstLogSets.setSelection(new String[]{string});
        }
    }

    private int computeButtonsMinWidth(Control control) {
        String string = LogUIPlugin.getResourceString("STR_IMPORT_LOG_RENAME_SET");
        String string2 = LogUIPlugin.getResourceString("STR_IMPORT_LOG_REMOVE_SET");
        int n = Math.max(string.length(), string2.length());
        GC gC = new GC((Drawable)control);
        gC.setFont(control.getFont());
        FontMetrics fontMetrics = gC.getFontMetrics();
        return Math.max(Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)(n + 4)), 90);
    }

    private int computeLabelMinHeight(Label label) {
        GC gC = new GC((Drawable)label);
        gC.setFont(label.getFont());
        FontMetrics fontMetrics = gC.getFontMetrics();
        return Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)2) + 5;
    }

    public String getLogSetName() {
        if (this.txtLogSetName != null) {
            return this.txtLogSetName.getText();
        }
        if (this.lstLogSets != null) {
            return this.lstLogSets.getItem(this.lstLogSets.getSelectionIndex());
        }
        return null;
    }

    public String[] getLogSets() {
        if (this.lstLogSets != null) {
            return this.lstLogSets.getItems();
        }
        return null;
    }

    public void setTextSelection() {
        this.txtLogSetName.selectAll();
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        int n = this.lstLogSets.getSelectionIndex();
        if (n > -1 && !this.lstLogSets.getItem(n).equals(this.dialog.getDefaultLogSet())) {
            this.dialog.setLogSetSelectionChanged(true);
        }
        this.dialog.setDefaultLogSet(this.lstLogSets.getItem(this.lstLogSets.getSelectionIndex()));
        this.dialog.close();
    }
}

