/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.hyades.ui.sample.svg.generator.DataInputProcessingException;
import org.eclipse.hyades.ui.sample.svg.generator.DataRange;
import org.eclipse.hyades.ui.sample.svg.generator.DataSet;
import org.eclipse.hyades.ui.sample.svg.generator.ECMAScriptGenerator;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicAttributes;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicDocumentProperties;
import org.eclipse.hyades.ui.sample.svg.generator.IDataInputConstants;
import org.eclipse.hyades.ui.sample.svg.generator.IDataInputProcessingExceptionCodes;
import org.eclipse.hyades.ui.sample.svg.generator.IGraphicDocumentStyle;
import org.eclipse.hyades.ui.sample.svg.generator.PieChartDataRetriever;
import org.eclipse.hyades.ui.sample.svg.generator.SVGDocumentGenerator;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGPieChart
extends SVGDocumentGenerator
implements IGraphicDocumentStyle,
IDataInputProcessingExceptionCodes,
IDataInputConstants,
Serializable {
    private final PieChartDataRetriever dataRetriever;
    private final int NINETY_DEG = 1;
    private final int NEGATIVE_NINETY_DEG = 2;
    private final int ONE_EIGHTY_DEG = 3;
    private final int ZERO_DEG = 4;

    public SVGPieChart() {
        this.graphicType = "pie";
        this.dataRetriever = new PieChartDataRetriever();
    }

    public Document generateGraphicDocument(GraphicDocumentProperties graphicDocumentProperties) throws DataInputProcessingException {
        String[] stringArray;
        Object object;
        double d;
        double d2;
        GraphicAttributes graphicAttributes = this.createGraphicAttributes(graphicDocumentProperties);
        Document document = graphicAttributes.getDataDocument();
        int n = 0;
        try {
            n = this.dataRetriever.getNumberOfDatasets(document);
        }
        catch (DataInputProcessingException dataInputProcessingException) {
            dataInputProcessingException.setWidgetType(this.graphicType);
            throw dataInputProcessingException;
        }
        DataRange dataRange = null;
        Object var6_7 = null;
        DataSet[] dataSetArray = null;
        String[] stringArray2 = null;
        try {
            dataRange = this.dataRetriever.getDataRange(document, "");
        }
        catch (DataInputProcessingException dataInputProcessingException) {
            dataInputProcessingException.setWidgetType(this.graphicType);
            throw dataInputProcessingException;
        }
        dataSetArray = new DataSet[n];
        int n2 = 0;
        while (n2 < n) {
            dataSetArray[n2] = this.dataRetriever.getDatasetWithPosition(document, Integer.toString(n2));
            ++n2;
        }
        stringArray2 = this.getLegendFlyOverLabels(dataSetArray);
        double d3 = graphicAttributes.getGraphicWidth();
        double d4 = graphicAttributes.getGraphicHeight();
        int n3 = (int)(d4 * 0.152);
        if (!graphicAttributes.isLegendSuppressed()) {
            d2 = this.getMaxLengthOfLegendLabel(graphicAttributes, dataSetArray);
            if (d2 > (d = (double)(graphicAttributes.getGraphicWidth() / 3))) {
                d2 = d;
            }
            d3 -= d2 + 12.0;
        }
        double d5 = d3 * 0.5;
        d2 = d4 >= d3 ? d3 * 0.245 : d4 * 0.233;
        d = d4 * 0.52;
        String string = "translate(" + d5 + "," + d + ")";
        Document document2 = this.createSvgDocument(document.getImplementation(), Short.toString(graphicAttributes.getGraphicWidth()), Short.toString(graphicAttributes.getGraphicHeight()));
        Element element = document2.getDocumentElement();
        this.registerEventHandler(element, "onload", "init(evt)");
        this.addDefinitions(document2, graphicAttributes, n);
        this.addJavaScriptFunctions(document2, graphicAttributes, n);
        if (!graphicAttributes.isOutlineSuppressed()) {
            this.addOutline(document2, graphicAttributes);
        }
        if (!graphicAttributes.isTimestampSuppressed()) {
            try {
                object = this.dataRetriever.getTimestamp(document);
                stringArray = GraphicAttributes.parseISO8601Date((String)object);
                this.addTimeStamp(document2, graphicAttributes, (String)(stringArray == null ? object : graphicAttributes.formatDate((Date)stringArray)));
            }
            catch (DataInputProcessingException dataInputProcessingException) {
                dataInputProcessingException.setWidgetType(this.graphicType);
                throw dataInputProcessingException;
            }
        }
        if (!graphicAttributes.isTitlebarSuppressed()) {
            this.addTitleBar(document2, graphicAttributes);
        }
        if (!graphicAttributes.isUserPreferencesSuppressed() && graphicAttributes.getSvgFormatOnly()) {
            this.addPreferenceIcon(document2, graphicAttributes);
        }
        try {
            object = this.dataRetriever.getTitles(document);
            this.addTitles(document2, graphicAttributes, element, (Hashtable)object, d5, n3);
        }
        catch (DataInputProcessingException dataInputProcessingException) {
            dataInputProcessingException.setWidgetType(this.graphicType);
            throw dataInputProcessingException;
        }
        object = document2.createElement("g");
        this.addPieSlices(document2, graphicAttributes, element, dataSetArray, d2, d5, d, string);
        if (!graphicAttributes.isLegendSuppressed()) {
            try {
                stringArray = this.dataRetriever.getLegendLabels(document);
                this.addLegend(document2, graphicAttributes, (Element)object, stringArray, stringArray2, (int)d3, n3);
            }
            catch (DataInputProcessingException dataInputProcessingException) {
                dataInputProcessingException.setWidgetType(this.graphicType);
                throw dataInputProcessingException;
            }
        }
        element.appendChild((Node)object);
        return document2;
    }

    protected void addJavaScriptFunctions(Document document, GraphicAttributes graphicAttributes, int n) {
        Element element = document.getDocumentElement();
        super.addJavaScriptFunctions(document, graphicAttributes, n, 0, 0, 0, 0);
        Element element2 = document.createElement("script");
        element2.setAttribute("type", "text/ecmascript");
        element.appendChild(element2);
        ECMAScriptGenerator eCMAScriptGenerator = new ECMAScriptGenerator();
        StringBuffer stringBuffer = new StringBuffer(eCMAScriptGenerator.generatePieChartHelperFunctions());
        CDATASection cDATASection = document.createCDATASection(stringBuffer.toString());
        element2.appendChild(cDATASection);
    }

    private void addTitles(Document document, GraphicAttributes graphicAttributes, Element element, Hashtable hashtable, double d, int n) {
        int n2 = 0;
        int n3 = 10;
        Element element2 = document.createElement("g");
        String string = null;
        string = (String)hashtable.get("valueTitle");
        if (string != null) {
            element2 = document.createElement("g");
            element2.setAttribute("id", "labelsValues0");
            element2.setAttribute("class", "labelsValues anchorAtMiddle");
            element.appendChild(element2);
            this.addLabel(document, graphicAttributes, element2, string, null, d, (double)graphicAttributes.getGraphicHeight() * 0.9, n2);
        }
        if ((string = (String)hashtable.get("totalTitle")) != null) {
            element2 = document.createElement("g");
            element2.setAttribute("id", "labelsValues1");
            element2.setAttribute("class", "legendTitle anchorAtStart");
            element.appendChild(element2);
            this.addLabel(document, graphicAttributes, element2, string, null, n3, n + 10, n2);
        }
    }

    private void addDefaultInternalStylesheet(Document document, GraphicAttributes graphicAttributes, Element element, int n) {
        StringBuffer stringBuffer = new StringBuffer(" .st1{fill-rule:nonzero;clip-rule:nonzero;stroke:#000000;stroke-miterlimit:4;} .outline{stroke-width:0.75pt; stroke:#666666; fill:#ffffff;} .keyline{stroke-width:0.75pt; stroke:#666666;} .graphTitle {font-weight:bold; font-style:normal; font-size:11pt; fill:#000000; stroke-width:0.75pt;} .labelsValues {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000;} .dataValues {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000;} .timeStamp {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000; text-anchor:end; opacity:0.5} .legendTitle {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000; text-anchor:start; opacity:0.6} .legendData {font-weight:normal; font-style:normal; font-size:9pt; text-anchor:start; fill:#000000;} .anchorAtEnd {text-anchor: end;} .anchorAtStart {text-anchor: start;} .anchorAtMiddle {text-anchor: middle;}");
        stringBuffer.append(" ");
        stringBuffer.append(" .pievalues{stroke:none; font-weight:normal; font-style:normal; font-size:8pt; fill:#000000; text-anchor: middle;}.wedgeTick{fill:none;} .wedgeOutline{fill:none;} .wedgeColor{fill:#CCCCCC;stroke:none;}");
        String[] stringArray = (String[])graphicAttributes.getGraphicColorPalette().get(graphicAttributes.getGraphicColorPaletteName());
        int n2 = stringArray.length;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            n4 = (n3 + 1) % n2;
            n4 = n4 == 0 ? n2 - 1 : n4 - 1;
            stringBuffer.append(" .dataset" + n3 + "{stroke:black; fill:" + stringArray[n4] + ";}");
            if (!graphicAttributes.isLegendSuppressed()) {
                stringBuffer.append(" .shape" + n3 + "{stroke:none; fill:" + stringArray[n4] + ";}");
            }
            ++n3;
        }
        CDATASection cDATASection = document.createCDATASection(stringBuffer.toString());
        Element element2 = document.createElement("style");
        element2.setAttribute("id", "defaultStyleRules");
        element2.setAttribute("type", "text/css");
        element2.appendChild(cDATASection);
        element.appendChild(element2);
    }

    private void addDefinitions(Document document, GraphicAttributes graphicAttributes, int n) {
        Element element = super.addDefinitions(document, graphicAttributes);
        this.addDefaultInternalStylesheet(document, graphicAttributes, element, n);
        Element element2 = document.createElement("g");
        element2.setAttribute("id", "tickline");
        Element element3 = document.createElement("polyline");
        element3.setAttribute("class", "grid");
        element3.setAttribute("points", "0 0 8 0");
        element2.appendChild(element3);
        element.appendChild(element2);
    }

    private void addPieSlices(Document document, GraphicAttributes graphicAttributes, Element element, DataSet[] dataSetArray, double d, double d2, double d3, String string) {
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        Element element2 = document.createElement("g");
        element2.setAttribute("id", "exactValues");
        element2.setAttribute("onclick", "toggleVisibility(\"exactValues\")");
        element2.setAttribute("visibility", "hidden");
        element.appendChild(element2);
        Element element3 = document.createElement("g");
        element3.setAttribute("id", "percentValues");
        element3.setAttribute("onclick", "toggleVisibility(\"percentValues\")");
        element3.setAttribute("visibility", "hidden");
        element.appendChild(element3);
        Element element4 = document.createElement("g");
        element4.setAttribute("id", "bothValues");
        element4.setAttribute("onclick", "toggleVisibility(\"bothValues\")");
        element.appendChild(element4);
        int n = 0;
        while (n < dataSetArray.length) {
            d4 += dataSetArray[n].getTotal();
            ++n;
        }
        int n2 = 0;
        while (n2 < dataSetArray.length) {
            d5 = dataSetArray[n2].getTotal();
            d6 = d4 > 0.0 ? d5 / d4 : 0.0;
            d7 = d6 * 360.0;
            d9 = d7 * 0.01745329252;
            d10 = Math.cos(d9) * d;
            d11 = Math.sin(d9) * d;
            String string2 = "M " + d + " 0 ";
            if (d7 == 360.0) {
                string2 = string2 + " A " + d + " " + d + " 0 0 0 " + -d + " 0 " + " A " + d + " " + d + " 0 0 0 " + d + " 0 ";
            } else if (d7 != 0.0) {
                string2 = string2 + " A " + d + " " + d + " 0 " + (d7 < 180.0 ? 0 : 1) + " 0 " + d10 + " " + -d11;
            }
            string2 = string2 + " L 0 0  Z";
            String string3 = n2 == 0 ? string : string + " rotate(-" + d8 + ")";
            Element element5 = document.createElement("g");
            element5.setAttribute("id", "pieColour" + n2);
            element5.setAttribute("class", "dataset" + n2);
            element5.setAttribute("onclick", "toggleVisibility(\"pieColour\");");
            element.appendChild(element5);
            Element element6 = document.createElement("path");
            element6.setAttribute("transform", string3);
            element6.setAttribute("d", string2);
            element5.appendChild(element6);
            String string4 = graphicAttributes.formatPercentage(d6);
            String string5 = graphicAttributes.formatNumber(d5);
            this.addLabels(document, graphicAttributes, element4, element2, element3, n2, string4, d7, d8, string5, d, d2, d3, string);
            d8 += d7;
            ++n2;
        }
    }

    private void addLabels(Document document, GraphicAttributes graphicAttributes, Element element, Element element2, Element element3, int n, String string, double d, double d2, String string2, double d3, double d4, double d5, String string3) {
        double d6 = (d / 2.0 + d2) * 0.01745329252;
        double d7 = Math.cos(-1.0 * d6) * d3;
        double d8 = Math.sin(-1.0 * d6) * d3;
        String string4 = "";
        int n2 = 0;
        if (d5 + d8 > d5 && d5 + d8 >= d5 + 0.875 * d3) {
            string4 = "rotate(90," + d7 + "," + d8 + ")";
            n2 = 1;
        } else if (d5 + d8 < d5 && d5 + d8 <= d5 - 0.875 * d3) {
            string4 = "rotate(-90," + d7 + "," + d8 + ")";
            n2 = 2;
        } else if (d4 + d7 < d4) {
            string4 = "rotate(180," + d7 + "," + d8 + ")";
            n2 = 3;
        } else {
            n2 = 4;
        }
        Element element4 = document.createElement("use");
        element4.setAttribute("xlink:href", "#tickline");
        element4.setAttribute("x", Double.toString(d7));
        element4.setAttribute("y", Double.toString(d8));
        element4.setAttribute("transform", string3 + string4);
        element2.appendChild(element4);
        element3.appendChild(element4);
        element.appendChild(element4);
        String string5 = d4 + d7 >= d4 ? "pieValues anchorAtStart" : "pieValues anchorAtEnd";
        String string6 = string + ",  " + string2;
        String string7 = string;
        Vector vector = this.calculateLabelPositions(d4, d7, d8, n2, string6);
        double d9 = Double.parseDouble(vector.firstElement().toString());
        double d10 = Double.parseDouble(vector.lastElement().toString());
        element4 = document.createElement("text");
        element4.setAttribute("x", Double.toString(d9));
        element4.setAttribute("y", Double.toString(-1.0 * d10));
        element4.setAttribute("transform", string3);
        element4.setAttribute("class", string5 + " shape" + n);
        element4.appendChild(document.createTextNode(string7));
        element3.appendChild(element4);
        element4 = document.createElement("text");
        element4.setAttribute("x", Double.toString(d9));
        element4.setAttribute("y", Double.toString(-1.0 * d10));
        element4.setAttribute("transform", string3);
        element4.setAttribute("class", string5 + " shape" + n);
        element4.appendChild(document.createTextNode(string2));
        element2.appendChild(element4);
        element4 = document.createElement("text");
        element4.setAttribute("x", Double.toString(d9));
        element4.setAttribute("y", Double.toString(-1.0 * d10));
        element4.setAttribute("transform", string3);
        element4.setAttribute("class", string5 + " shape" + n);
        element4.appendChild(document.createTextNode(string6));
        element.appendChild(element4);
    }

    private Vector calculateLabelPositions(double d, double d2, double d3, int n, String string) {
        double d4 = 0.0;
        double d5 = 0.0;
        Vector<Double> vector = new Vector<Double>(2);
        if (d + d2 < d) {
            if (n == 2) {
                d4 = d2 + 2.0;
                d5 = -d3 + 12.0;
            } else if (n == 1) {
                d4 = d2 + 2.0;
                d5 = -d3 - 20.0;
            } else if (n == 3) {
                d4 = d2 - 10.0;
                d5 = -d3 - 1.0;
            }
        } else if (n == 2) {
            d4 = d2 - 3.0;
            d5 = -d3 + 12.0;
        } else if (n == 1) {
            d4 = d2 - 3.0;
            d5 = -d3 - 20.0;
        } else if (n == 4) {
            d4 = d2 + 10.0;
            d5 = -d3 - 1.0;
        }
        vector.add(new Double(d4));
        vector.add(new Double(d5));
        return vector;
    }

    private void getConfigAttributes(GraphicAttributes graphicAttributes) throws DataInputProcessingException {
        Hashtable hashtable = this.dataRetriever.getConfigurationAttributes(graphicAttributes.getConfigDocument(), graphicAttributes.getDataDocument());
        if (hashtable == null) {
            return;
        }
        String string = (String)hashtable.get("width");
        String string2 = (String)hashtable.get("height");
        String string3 = (String)hashtable.get("title");
        String string4 = (String)hashtable.get("timestampPrefix");
        String string5 = (String)hashtable.get("legendTitle");
        if (string != null) {
            graphicAttributes.setGraphicWidth(string);
        }
        if (string2 != null) {
            graphicAttributes.setGraphicHeight(string2);
        }
        if (string3 != null) {
            graphicAttributes.setGraphicTitle(string3);
        }
        if (string4 != null) {
            graphicAttributes.setGraphicTimestampPrefix(string4);
        }
        if (string5 != null) {
            graphicAttributes.setGraphicLegendTitle(string5);
        }
    }

    private GraphicAttributes createGraphicAttributes(GraphicDocumentProperties graphicDocumentProperties) throws DataInputProcessingException {
        GraphicAttributes graphicAttributes = new GraphicAttributes();
        graphicAttributes.setGraphicWidth("450");
        graphicAttributes.setPreferencesPage("prefs_pie.htm");
        graphicAttributes.setPreferencesPageWidth("430");
        graphicAttributes.setPreferencesPageHeight("460");
        graphicAttributes.setConfigDocument(graphicDocumentProperties.getConfigDocument());
        graphicAttributes.setDataDocument(graphicDocumentProperties.getDataDocument());
        this.getConfigAttributes(graphicAttributes);
        graphicAttributes.setAttributesFrom(graphicDocumentProperties);
        return graphicAttributes;
    }
}

