/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.recorder.ui.dialogs;

import org.eclipse.hyades.execution.recorder.RecorderPlugin;
import org.eclipse.hyades.internal.execution.recorder.local.RecorderClient;
import org.eclipse.hyades.internal.execution.testgen.ui.TestgenUIUtility;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;

public class RecorderProgressDialog
extends Dialog {
    private ProgressBar progressBar;
    private boolean ready;
    private Label infoText;
    private RecorderClient client;

    public RecorderProgressDialog() {
        super(Display.getDefault().getActiveShell());
    }

    public RecorderProgressDialog(RecorderClient recorderClient) {
        super(Display.getDefault().getActiveShell());
        this.client = recorderClient;
    }

    protected Control createContents(Composite composite) {
        this.getShell().setText(RecorderPlugin.getResourceString("RecorderProgressDialog.TITLE"));
        int n = 400;
        int n2 = 150;
        Composite composite2 = composite.getParent();
        if (composite2 == null) {
            composite2 = composite;
        }
        composite.setBounds(composite2.getBounds().x + composite2.getBounds().width / 2 - n / 2, composite2.getBounds().y + composite2.getBounds().height / 2 - n2 / 2, n, n2);
        GridData gridData = new GridData(1808);
        gridData.heightHint = n2;
        gridData.widthHint = n;
        composite.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite, 0);
        gridData = new GridData(1808);
        gridData.heightHint = n2;
        gridData.widthHint = n;
        composite3.setLayoutData((Object)gridData);
        TestgenUIUtility.assignFormLayout((Composite)composite3);
        this.progressBar = new ProgressBar(composite3, 0);
        this.progressBar.setMaximum(100);
        this.progressBar.setMinimum(0);
        this.progressBar.setSelection(0);
        try {
            TestgenUIUtility.layoutCompositelInFormLayout((Control)this.progressBar, (int)45, (int)15, (int)10, (int)90, (int)0, (int)0, (int)0, (int)0);
        }
        catch (TestgenUIUtility.TestGenUIException testGenUIException) {
            testGenUIException.printStackTrace();
        }
        this.infoText = TestgenUIUtility.createLabel((Composite)composite3, (String)RecorderPlugin.getResourceString("RecorderProgressDialog.DEFAULT_MESSAGE"), null);
        try {
            FontData[] fontDataArray = composite3.getFont().getFontData();
            int n3 = 10;
            int n4 = 0;
            while (n4 < fontDataArray.length) {
                if (fontDataArray[n4].getHeight() > n3) {
                    n3 = fontDataArray[n4].getHeight();
                }
                ++n4;
            }
            TestgenUIUtility.layoutCompositelInFormLayout((Control)this.infoText, (int)60, (int)(n3 + 6), (int)10, (int)100, (int)0, (int)0, (int)0, (int)0);
        }
        catch (TestgenUIUtility.TestGenUIException testGenUIException) {
            testGenUIException.printStackTrace();
        }
        this.setReady();
        return composite;
    }

    public void setProgress(int n) {
        this.progressBar.setSelection(n);
    }

    public synchronized boolean isReady() {
        return this.ready;
    }

    public synchronized void setReady() {
        this.ready = true;
    }

    public void setMessage(String string) {
        this.infoText.setText(string);
    }

    public void complete() {
        this.close();
    }

    public void setMaxProgress(int n) {
        if (n > 0) {
            this.progressBar.setMaximum(n);
        }
    }

    public boolean close() {
        this.client.setProgressDlg(null);
        return super.close();
    }
}

