/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import org.eclipse.hyades.execution.core.DaemonConnectException;
import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener;
import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.UnknownDaemonException;
import org.eclipse.hyades.execution.core.file.IFileManager;
import org.eclipse.hyades.execution.invocation.Marshaller;
import org.eclipse.hyades.execution.local.SessionImpl;
import org.eclipse.hyades.execution.local.SessionStub;
import org.eclipse.hyades.execution.local.file.FileManagerImpl;
import org.eclipse.hyades.internal.execution.local.common.Console;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.local.control.AgentFactory;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.ConnectionListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.NoSuchApplicationException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessActiveException;
import org.eclipse.hyades.internal.execution.local.control.ProcessFactory;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.internal.execution.security.DuplicateUserException;
import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;

public class NodeImpl
implements INode {
    private String name;
    private Object sessionLock = new Object();
    private boolean connected = false;
    private static final boolean DEBUG = true;
    IFileManager fileManager;

    public NodeImpl(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISession connect(String string, Principal principal) throws UnknownDaemonException, DaemonConnectException, UnknownHostException {
        Node node = null;
        try {
            node = principal == null ? NodeFactory.createNode(this.name) : NodeFactory.createNode(this.name, principal);
        }
        catch (DuplicateUserException duplicateUserException) {
            throw duplicateUserException;
        }
        catch (UnknownHostException unknownHostException) {
            throw unknownHostException;
        }
        try {
            node.connect(Integer.parseInt(string));
        }
        catch (SecureConnectionRequiredException secureConnectionRequiredException) {
            throw secureConnectionRequiredException;
        }
        catch (LoginFailedException loginFailedException) {
            throw loginFailedException;
        }
        catch (AgentControllerUnavailableException agentControllerUnavailableException) {
            throw agentControllerUnavailableException;
        }
        node.getConnection().addConnectionListener(new ConnectionListener(){

            public void connectionClosed(Connection connection) {
            }
        });
        Process process = ProcessFactory.createProcess(node, "HyadesTestingSession");
        this.captureConsoleOutput(process);
        Agent agent = AgentFactory.createAgent(process, "RemoteSession", "HyadesSession");
        agent.setAutoAttach(true);
        SessionStub sessionStub = new SessionStub((IExecutionComponent)new SessionImpl(this, agent));
        Marshaller.addInstanceToMap((Integer)sessionStub.getUniqueId(), (Object)sessionStub);
        try {
            process.setParameters("org.eclipse.hyades.execution.remote.NodeImpl " + sessionStub.getUniqueId().toString());
        }
        catch (ProcessActiveException processActiveException) {
            // empty catch block
        }
        process.addProcessListener(new ProcessListener(){

            public void processLaunched(Process process) {
            }

            public void processExited(Process process) {
                NodeImpl.this.releaseSessionLock();
            }
        });
        sessionStub.addExecutionComponentStateChangeListener(new IExecutionComponentStateChangeListener(){

            public void stateChanged(ExecutionComponentStateChangeEvent executionComponentStateChangeEvent) {
                if (executionComponentStateChangeEvent.getState() == 2) {
                    NodeImpl.this.releaseSessionLock();
                }
            }
        });
        try {
            process.launch();
            process.getProcessId();
        }
        catch (InactiveProcessException inactiveProcessException) {
        }
        catch (NoSuchApplicationException noSuchApplicationException) {
        }
        catch (ProcessActiveException processActiveException) {
        }
        catch (NotConnectedException notConnectedException) {}
        while (!this.connected) {
            Object object = this.sessionLock;
            synchronized (object) {
                try {
                    this.sessionLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.fileManager = new FileManagerImpl(node.getConnection());
        return sessionStub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSessionLock() {
        Object object = this.sessionLock;
        synchronized (object) {
            this.connected = true;
            this.sessionLock.notify();
        }
    }

    private void captureConsoleOutput(Process process) {
        Console console = process.getConsole();
        console.setDataProcessor(new DataProcessor(){

            public void incommingData(byte[] byArray, int n, InetAddress inetAddress) {
                System.out.print("====>");
                System.out.print(new String(byArray, 0, n));
                System.out.flush();
            }

            public void incommingData(char[] cArray, int n, InetAddress inetAddress) {
                System.out.print("====>");
                System.out.print(new String(cArray, 0, n));
                System.out.flush();
            }

            public void invalidDataType(byte[] byArray, int n, InetAddress inetAddress) {
            }

            public void waitingForData() {
            }
        });
    }

    public IFileManager getFileManager() {
        return this.fileManager;
    }
}

