/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketException;
import org.eclipse.hyades.execution.core.file.IFileLocater;
import org.eclipse.hyades.execution.core.file.IFileLocation;
import org.eclipse.hyades.execution.core.file.IFileManager;
import org.eclipse.hyades.execution.core.impl.ExecutionComponentImpl;
import org.eclipse.hyades.execution.local.file.FileLocaterImpl;
import org.eclipse.hyades.internal.execution.file.FileServiceConstants;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.Message;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.ConnectionImpl;
import org.eclipse.hyades.internal.execution.local.control.SecureConnectionImpl;

public class FileManagerImpl
extends ExecutionComponentImpl
implements IFileManager {
    private IFileLocater locator;
    private Connection connection;

    public FileManagerImpl(Connection connection) {
        this.locator = new FileLocaterImpl(connection);
        this.connection = connection;
    }

    public void getFile(String string, String string2) throws IOException {
        IFileLocation iFileLocation = this.locator.getFile(string2);
        String string3 = null;
        File file = new File(string);
        string3 = file.getParent();
        File file2 = new File(string3);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        file.createNewFile();
        if (this.connection instanceof SecureConnectionImpl) {
            SecureResourceConnection secureResourceConnection = new SecureResourceConnection();
            try {
                secureResourceConnection.connect(this.connection.getNode(), iFileLocation.getPort());
            }
            catch (AgentControllerUnavailableException agentControllerUnavailableException) {}
        } else if (this.connection instanceof ConnectionImpl) {
            ResourceConnection resourceConnection = new ResourceConnection();
            try {
                resourceConnection.setParams(string2, 1L);
                resourceConnection.setInputStream(null);
                resourceConnection.setOutputStream(new FileOutputStream(file));
                resourceConnection.connect(this.connection.getNode(), iFileLocation.getPort());
            }
            catch (AgentControllerUnavailableException agentControllerUnavailableException) {
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
        }
    }

    public void deleteFile(String string) throws IOException {
        this.locator.deleteFile(string);
    }

    public void putFile(String string, String string2) throws IOException {
        block7: {
            File file;
            IFileLocation iFileLocation;
            block6: {
                iFileLocation = this.locator.putFile(string2);
                file = new File(string);
                if (!(this.connection instanceof SecureConnectionImpl)) break block6;
                SecureResourceConnection secureResourceConnection = new SecureResourceConnection();
                try {
                    secureResourceConnection.connect(this.connection.getNode(), iFileLocation.getPort());
                }
                catch (AgentControllerUnavailableException agentControllerUnavailableException) {}
                break block7;
            }
            if (!(this.connection instanceof ConnectionImpl)) break block7;
            ResourceConnection resourceConnection = new ResourceConnection();
            try {
                resourceConnection.setParams(string2, 2L);
                resourceConnection.setInputStream(new FileInputStream(file));
                resourceConnection.setOutputStream(null);
                resourceConnection.connect(this.connection.getNode(), iFileLocation.getPort());
            }
            catch (AgentControllerUnavailableException agentControllerUnavailableException) {}
        }
    }

    class SecureResourceConnection
    extends SecureConnectionImpl {
        SecureResourceConnection() {
        }

        protected void init() {
        }
    }

    class ResourceConnection
    extends ConnectionImpl {
        private FileOutputStream stream;
        private InputStream inStream;
        private OutputStream outStream;
        private String fileName;
        private long operation;

        ResourceConnection() {
        }

        protected void init() {
            try {
                this._socket.setSoTimeout(1000);
                this._socket.setTcpNoDelay(true);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            new SocketReader().run();
        }

        public void setStream(FileOutputStream fileOutputStream) {
            this.stream = fileOutputStream;
        }

        public void setInputStream(InputStream inputStream) {
            this.inStream = inputStream;
        }

        public void setOutputStream(OutputStream outputStream) {
            this.outStream = outputStream;
        }

        public void setParams(String string, long l) {
            this.fileName = string;
            this.operation = l;
        }

        class SocketReader
        implements Runnable,
        FileServiceConstants,
        Constants {
            private boolean _isComplete = false;
            private byte[] buffer = new byte[1024];
            private byte[] tempFileName = ResourceConnection.access$000(ResourceConnection.this).getBytes();
            private int byteCount = 0;

            SocketReader() {
            }

            public void run() {
                try {
                    OutputStream outputStream = ResourceConnection.this._socket.getOutputStream();
                    long l = ResourceConnection.this.fileName.length();
                    int n = 0;
                    n = Message.writeRALongToBuffer(this.buffer, 0, ResourceConnection.this.operation);
                    n = Message.writeRALongToBuffer(this.buffer, n, l);
                    System.arraycopy(this.tempFileName, 0, this.buffer, n, ResourceConnection.this.fileName.length());
                    outputStream.write(this.buffer);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (ResourceConnection.this.inStream == null) {
                    try {
                        ResourceConnection.this.inStream = ResourceConnection.this._socket.getInputStream();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (ResourceConnection.this.outStream == null) {
                    try {
                        ResourceConnection.this.outStream = ResourceConnection.this._socket.getOutputStream();
                    }
                    catch (IOException iOException) {}
                }
                while (!this._isComplete) {
                    try {
                        int n = ResourceConnection.this.inStream.read(this.buffer);
                        if (n == -1) break;
                        this.byteCount += n;
                        ResourceConnection.this.outStream.write(this.buffer, 0, n);
                    }
                    catch (InterruptedIOException interruptedIOException) {
                    }
                    catch (SocketException socketException) {
                        break;
                    }
                    catch (IOException iOException) {
                        break;
                    }
                }
                ResourceConnection.this.disconnect();
                try {
                    ResourceConnection.this.outStream.close();
                    ResourceConnection.this.inStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

