/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.control;

import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.hyades.edit.datapool.IDatapoolCell;
import org.eclipse.hyades.edit.datapool.IDatapoolRecord;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class DatapoolClipboard {
    private static final String SEPERATOR = "\t";
    private static final String LINEFEED = "\n";
    private static final String CARRIAGERETURN = "\r";
    private static final String CRLF = "\r\n";
    private Vector recordData = new Vector();
    private Vector recordStringData = new Vector();
    private Object cellData = null;
    private Object cellStringData = null;
    private Clipboard clipboard = null;
    private static final DatapoolClipboard instance = new DatapoolClipboard();

    public static DatapoolClipboard getInstance() {
        return instance;
    }

    protected DatapoolClipboard() {
    }

    public void addRecordData(IDatapoolRecord iDatapoolRecord) {
        if (iDatapoolRecord == null) {
            return;
        }
        int n = iDatapoolRecord.getCellCount();
        Object[] objectArray = new Object[n];
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            IDatapoolCell iDatapoolCell = (IDatapoolCell)iDatapoolRecord.getCell(n2);
            objectArray[n2] = iDatapoolCell.getClonedCellValue();
            stringArray[n2] = iDatapoolCell.getStringValue();
            ++n2;
        }
        this.recordData.add(objectArray);
        this.recordStringData.add(stringArray);
    }

    public void addCellData(IDatapoolCell iDatapoolCell) {
        this.cellData = iDatapoolCell.getClonedCellValue();
        this.cellStringData = iDatapoolCell.getStringValue();
    }

    public Object getCellData() {
        TextTransfer textTransfer = TextTransfer.getInstance();
        String string = (String)this.clipboard.getContents((Transfer)textTransfer);
        if (string.equals(this.cellStringData)) {
            return this.cellData;
        }
        return string;
    }

    public Object[] getRecordDataSet() {
        Object[] objectArray;
        Object object;
        TextTransfer textTransfer = TextTransfer.getInstance();
        String string = (String)this.clipboard.getContents((Transfer)textTransfer);
        StringTokenizer stringTokenizer = new StringTokenizer(string, LINEFEED);
        int n = 0;
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (((String)object).endsWith(CARRIAGERETURN)) {
                object = ((String)object).replaceAll(CARRIAGERETURN, new String());
            }
            if (!((String)(object = MessageFormat.format("{0}{1}", objectArray = new Object[]{object, LINEFEED}))).equals(this.constructClipboardData()[n])) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            return this.recordData.toArray();
        }
        object = new Vector();
        objectArray = new StringTokenizer(string, LINEFEED);
        while (objectArray.hasMoreTokens()) {
            String string2 = objectArray.nextToken();
            if (string2.endsWith(CARRIAGERETURN)) {
                string2 = string2.replaceAll(CARRIAGERETURN, new String());
            }
            int n2 = string2.indexOf(SEPERATOR);
            int n3 = 1;
            while (n2 != -1) {
                ++n3;
                n2 = string2.indexOf(SEPERATOR, n2 + 1);
            }
            String[] stringArray = new String[n3];
            n = 0;
            n2 = string2.indexOf(SEPERATOR);
            while (n2 != -1) {
                stringArray[n] = string2.substring(0, n2);
                string2 = string2.substring(n2 + 1);
                n2 = string2.indexOf(SEPERATOR);
                ++n;
            }
            stringArray[n] = string2;
            ((Vector)object).add(stringArray);
        }
        return ((Vector)object).toArray();
    }

    public void update() {
        TextTransfer textTransfer = TextTransfer.getInstance();
        if (this.recordStringData.size() > 0) {
            int n = this.recordStringData.size();
            Transfer[] transferArray = new Transfer[n];
            Object[] objectArray = this.constructClipboardData();
            int n2 = 0;
            while (n2 < n) {
                transferArray[n2] = textTransfer;
                ++n2;
            }
            this.clipboard.setContents(objectArray, transferArray);
        } else {
            Object[] objectArray = new Object[]{this.cellData};
            Transfer[] transferArray = new Transfer[]{textTransfer};
            this.clipboard.setContents(objectArray, transferArray);
        }
    }

    public boolean isEmpty() {
        String string;
        if (this.recordData != null && !this.recordData.isEmpty()) {
            return false;
        }
        if (this.cellData != null) {
            return false;
        }
        TextTransfer textTransfer = TextTransfer.getInstance();
        return this.clipboard == null || textTransfer == null || this.clipboard.isDisposed() || (string = (String)this.clipboard.getContents((Transfer)textTransfer)) == null;
    }

    public void clear() {
        this.recordData.clear();
        this.recordStringData.clear();
        this.cellData = null;
        this.cellStringData = null;
    }

    public void setClipboard(Clipboard clipboard) {
        if (this.clipboard == null || this.clipboard.isDisposed()) {
            this.clipboard = clipboard;
        }
    }

    private String[] constructClipboardData() {
        if (this.recordStringData.size() > 0) {
            int n = this.recordStringData.size();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                Object[] objectArray;
                Object[] objectArray2 = (Object[])this.recordStringData.get(n2);
                String string = new String();
                int n3 = 0;
                while (n3 < objectArray2.length) {
                    if (n3 == 0) {
                        string = (String)objectArray2[n3];
                    } else {
                        objectArray = new Object[]{string, SEPERATOR, (String)objectArray2[n3]};
                        string = MessageFormat.format("{0}{1}{2}", objectArray);
                    }
                    ++n3;
                }
                objectArray = new Object[]{string, LINEFEED};
                stringArray[n2] = string = MessageFormat.format("{0}{1}", objectArray);
                ++n2;
            }
            return stringArray;
        }
        String[] stringArray = new String[]{new String()};
        return stringArray;
    }
}

