/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.control;

import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.datapool.internal.action.CopyAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.CutAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.DeleteColumnAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.DeleteRowAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.DeleteRowGroupAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.EditColumnAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.EditRowAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.EditRowGroupAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.InsertColumnAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.InsertRowAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.InsertRowGroupAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.PasteAction;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolClipboard;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTable;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ui.actions.ActionFactory;

public class DatapoolMenuManager {
    private InsertRowAction insertRowAction = null;
    private DeleteRowAction deleteRowAction = null;
    private EditRowAction editRowAction = null;
    private InsertColumnAction insertColumnAction = null;
    private DeleteColumnAction deleteColumnAction = null;
    private EditColumnAction editColumnAction = null;
    private InsertRowGroupAction insertRowGroupAction = null;
    private DeleteRowGroupAction deleteRowGroupAction = null;
    private EditRowGroupAction editRowGroupAction = null;
    private CutAction cutAction = null;
    private CopyAction copyAction = null;
    private PasteAction pasteAction = null;
    private DatapoolTable table = null;
    private Vector customActions = null;
    private String vendorID = null;
    private boolean showRowGroupActions = true;
    private boolean showColumnActions = true;
    private boolean showRowActions = true;
    private boolean showEditActions = true;

    public DatapoolMenuManager(DatapoolTable datapoolTable, String string, boolean bl, boolean bl2, boolean bl3) {
        if (datapoolTable == null) {
            return;
        }
        this.table = datapoolTable;
        this.customActions = new Vector();
        this.vendorID = string;
        this.showRowGroupActions = bl;
        this.showColumnActions = bl2;
        this.showRowActions = bl3;
        this.makeActions();
    }

    private void makeActions() {
        block5: {
            TableViewer tableViewer = this.table.getViewer();
            this.insertRowAction = new InsertRowAction((ISelectionProvider)tableViewer, this.table);
            this.deleteRowAction = new DeleteRowAction((ISelectionProvider)tableViewer, this.table);
            this.editRowAction = new EditRowAction((ISelectionProvider)tableViewer, this.table);
            this.insertColumnAction = new InsertColumnAction((ISelectionProvider)tableViewer, this.table);
            this.deleteColumnAction = new DeleteColumnAction((ISelectionProvider)tableViewer, this.table);
            this.editColumnAction = new EditColumnAction((ISelectionProvider)tableViewer, this.table);
            this.insertRowGroupAction = new InsertRowGroupAction((ISelectionProvider)tableViewer, this.table);
            this.deleteRowGroupAction = new DeleteRowGroupAction((ISelectionProvider)tableViewer, this.table);
            this.editRowGroupAction = new EditRowGroupAction((ISelectionProvider)tableViewer, this.table);
            this.cutAction = new CutAction((ISelectionProvider)tableViewer, this.table);
            this.copyAction = new CopyAction((ISelectionProvider)tableViewer, this.table);
            this.pasteAction = new PasteAction((ISelectionProvider)tableViewer, this.table);
            this.table.getIDatapoolPart().getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
            this.table.getIDatapoolPart().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
            this.table.getIDatapoolPart().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
            if (this.vendorID == null) {
                return;
            }
            IExtensionPoint iExtensionPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.hyades.test.ui.datapool.menuExtension");
            if (iExtensionPoint == null) break block5;
            try {
                IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
                int n = 0;
                while (n < iConfigurationElementArray.length) {
                    String string = iConfigurationElementArray[n].getAttribute("vendorID");
                    if (this.vendorID.equals(string)) {
                        String string2 = iConfigurationElementArray[n].getAttribute("displayName");
                        IDatapoolAction iDatapoolAction = (IDatapoolAction)iConfigurationElementArray[n].createExecutableExtension("actionClass");
                        this.customActions.add(iDatapoolAction);
                        iDatapoolAction.setDatapoolTable(this.table);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {}
        }
    }

    public void addActions(IMenuManager iMenuManager) {
        MenuManager menuManager = (MenuManager)iMenuManager;
        if (this.showRowGroupActions) {
            menuManager.add((IAction)this.insertRowGroupAction);
            menuManager.add((IAction)this.deleteRowGroupAction);
            menuManager.add((IAction)this.editRowGroupAction);
        }
        if (this.showRowActions) {
            menuManager.add((IAction)this.insertRowAction);
            menuManager.add((IAction)this.deleteRowAction);
            menuManager.add((IAction)this.editRowAction);
        }
        if (this.showColumnActions) {
            menuManager.add((IAction)this.insertColumnAction);
            menuManager.add((IAction)this.deleteColumnAction);
            menuManager.add((IAction)this.editColumnAction);
        }
        if (this.showEditActions) {
            menuManager.add((IAction)this.cutAction);
            menuManager.add((IAction)this.copyAction);
            menuManager.add((IAction)this.pasteAction);
        }
        int n = 0;
        while (n < this.customActions.size()) {
            IAction iAction = (IAction)this.customActions.get(n);
            menuManager.add(iAction);
            ++n;
        }
    }

    public void setDisplayMode(int n) {
        boolean bl = !DatapoolClipboard.getInstance().isEmpty();
        switch (n) {
            case 0: {
                this.insertRowGroupAction.aboutToShow(true);
                this.deleteRowGroupAction.aboutToShow(true);
                this.editRowGroupAction.aboutToShow(true);
                this.insertRowAction.aboutToShow(true);
                this.deleteRowAction.aboutToShow(true);
                this.editRowAction.aboutToShow(true);
                this.insertColumnAction.aboutToShow(true);
                this.deleteColumnAction.aboutToShow(false);
                this.editColumnAction.aboutToShow(false);
                this.cutAction.aboutToShow(true);
                this.cutAction.aboutToShow(true);
                this.copyAction.aboutToShow(true);
                this.pasteAction.aboutToShow(bl);
                break;
            }
            case 1: {
                this.insertRowGroupAction.aboutToShow(true);
                this.deleteRowGroupAction.aboutToShow(true);
                this.editRowGroupAction.aboutToShow(true);
                this.insertRowAction.aboutToShow(true);
                this.deleteRowAction.aboutToShow(true);
                this.editRowAction.aboutToShow(true);
                this.insertColumnAction.aboutToShow(true);
                this.deleteColumnAction.aboutToShow(true);
                this.editColumnAction.aboutToShow(true);
                this.cutAction.aboutToShow(true);
                this.copyAction.aboutToShow(true);
                this.pasteAction.aboutToShow(bl);
                break;
            }
            case 2: 
            case 4: {
                this.insertRowGroupAction.aboutToShow(true);
                this.deleteRowGroupAction.aboutToShow(false);
                this.editRowGroupAction.aboutToShow(false);
                this.insertRowAction.aboutToShow(!this.showRowGroupActions);
                this.deleteRowAction.aboutToShow(false);
                this.editRowAction.aboutToShow(false);
                this.insertColumnAction.aboutToShow(true);
                this.deleteColumnAction.aboutToShow(false);
                this.editColumnAction.aboutToShow(false);
                this.cutAction.aboutToShow(false);
                this.copyAction.aboutToShow(false);
                this.pasteAction.aboutToShow(false);
                break;
            }
            case 3: {
                this.insertRowGroupAction.aboutToShow(true);
                this.deleteRowGroupAction.aboutToShow(false);
                this.editRowGroupAction.aboutToShow(false);
                this.insertRowAction.aboutToShow(!this.showRowGroupActions);
                this.deleteRowAction.aboutToShow(false);
                this.editRowAction.aboutToShow(false);
                this.insertColumnAction.aboutToShow(true);
                this.deleteColumnAction.aboutToShow(true);
                this.editColumnAction.aboutToShow(false);
                this.cutAction.aboutToShow(false);
                this.copyAction.aboutToShow(false);
                this.pasteAction.aboutToShow(false);
                break;
            }
            case 5: {
                this.insertRowGroupAction.aboutToShow(false);
                this.deleteRowGroupAction.aboutToShow(false);
                this.editRowGroupAction.aboutToShow(false);
                this.insertRowAction.aboutToShow(false);
                this.deleteRowAction.aboutToShow(false);
                this.editRowAction.aboutToShow(false);
                this.insertColumnAction.aboutToShow(false);
                this.deleteColumnAction.aboutToShow(false);
                this.editColumnAction.aboutToShow(false);
                this.cutAction.aboutToShow(false);
                this.copyAction.aboutToShow(true);
                this.pasteAction.aboutToShow(false);
                break;
            }
            default: {
                this.insertRowAction.aboutToShow(true);
                this.deleteRowAction.aboutToShow(true);
                this.editRowAction.aboutToShow(true);
                this.insertRowGroupAction.aboutToShow(true);
                this.deleteRowGroupAction.aboutToShow(true);
                this.editRowGroupAction.aboutToShow(true);
                this.insertColumnAction.aboutToShow(true);
                this.deleteColumnAction.aboutToShow(true);
                this.editColumnAction.aboutToShow(true);
                this.cutAction.aboutToShow(true);
                this.copyAction.aboutToShow(true);
                this.pasteAction.aboutToShow(false);
            }
        }
    }
}

