/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.control;

import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolCell;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolFactory;
import org.eclipse.hyades.edit.datapool.IDatapoolListener;
import org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord;
import org.eclipse.hyades.test.ui.datapool.DatapoolPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolClipboard;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolMenuManager;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTableUtil;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolAddDialogSimple;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolColumnDialog;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolDeleteColumnDialog;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolRowDialog;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolRowGroupDialog;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolPart;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IValidateValueClass;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IValueClassFactory;
import org.eclipse.hyades.test.ui.datapool.internal.util.TypeChecker;
import org.eclipse.hyades.test.ui.datapool.internal.util.ValueClassMap;
import org.eclipse.hyades.test.ui.datapool.internal.util.ValueObject;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DatapoolTable
implements IMenuListener,
SelectionListener,
IDatapoolListener {
    private static final String START_LITERAL = "<Literal>";
    private static final String END_LITERAL = "</Literal>";
    private static final String TAG_DATA = "data";
    private static final String TAG_RECORD = "record";
    private static final String TAG_VARIABLE = "variable";
    private static final String TAG_VARIABLE_INDEX = "variableIndex";
    private static final String TAG_EQUIVALENCE_CLASS = "equivalenceClass";
    private static final int MAX_TABLE_WIDTH = 60000;
    private static final int MAX_TABLE_HEIGHT = 120000;
    private IDatapool datapool = null;
    private Table table = null;
    private DatapoolTableUtil tableUtil = null;
    private TableViewer viewer = null;
    private Composite parent = null;
    private Menu contextMenu = null;
    private TableCursor cursor = null;
    private ControlEditor controlEditor = null;
    private IDatapoolPart datapoolPart = null;
    private IDatapoolFactory datapoolFactory = null;
    private CellEditor cellEditor = null;
    private DatapoolMenuManager datapoolMenuManager = null;
    private boolean ignoreECNotification = false;
    private boolean controlKeyDown = false;
    private boolean altKeyDown = false;
    private boolean alreadySaved = false;
    private boolean isInputValid = true;
    private boolean showEquivlenceClasses = true;
    private boolean showVariables = true;
    private boolean showRecords = true;
    private boolean isF2Mode = false;
    private FocusListener focusListener;
    private ICellEditorListener cellEditorListener;
    private String vendorID = null;
    protected SelectionListener headerListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            DatapoolTable.this.datapoolPart.notifyEdit();
            if (DatapoolTable.this.datapoolPart.isReadOnly()) {
                return;
            }
            DatapoolTable.this.clearCellEditor();
            TableColumn tableColumn = (TableColumn)selectionEvent.widget;
            DatapoolTable.this.editColumnAux(tableColumn);
        }
    };
    private ControlListener resizeListener = new ControlAdapter(){

        public void controlMoved(ControlEvent controlEvent) {
        }

        public void controlResized(ControlEvent controlEvent) {
            DatapoolTable.this.resetScrollBarSize(true);
        }
    };
    protected ControlListener resizeColumnListener = new ControlAdapter(){

        public void controlMoved(ControlEvent controlEvent) {
        }

        public void controlResized(ControlEvent controlEvent) {
            if (DatapoolTable.this.cursor != null && !DatapoolTable.this.cursor.isDisposed() && DatapoolTable.this.table.getSelectionIndex() > 0 && DatapoolTable.this.cursor.getColumn() > 0) {
                DatapoolTable.this.cursor.setSelection(DatapoolTable.this.table.getSelectionIndex(), DatapoolTable.this.cursor.getColumn());
            }
            DatapoolTable.this.resetScrollBarSize(false);
        }
    };

    private void clearCellEditor() {
        this.clearCellEditor(this.cellEditor);
    }

    private void clearCellEditor(CellEditor cellEditor) {
        if (cellEditor != null) {
            cellEditor.dispose();
            cellEditor = null;
        }
    }

    public DatapoolTable(Composite composite, IDatapoolPart iDatapoolPart, IDatapool iDatapool, IDatapoolFactory iDatapoolFactory, String string) {
        this.vendorID = string;
        ValueClassMap.setVendorID(string);
        this.DatapoolTableConstructor(composite, iDatapoolPart, iDatapool, iDatapoolFactory);
    }

    public DatapoolTable(Composite composite, IDatapoolPart iDatapoolPart, IDatapool iDatapool, IDatapoolFactory iDatapoolFactory) {
        this.DatapoolTableConstructor(composite, iDatapoolPart, iDatapool, iDatapoolFactory);
    }

    private void DatapoolTableConstructor(Composite composite, IDatapoolPart iDatapoolPart, IDatapool iDatapool, IDatapoolFactory iDatapoolFactory) {
        if (composite == null || iDatapool == null || iDatapoolPart == null || iDatapoolFactory == null) {
            return;
        }
        this.datapool = iDatapool;
        this.parent = composite;
        this.datapoolFactory = iDatapoolFactory;
        this.setWaitCursor();
        this.setVendorConfiguration();
        this.datapoolPart = iDatapoolPart;
        DatapoolClipboard.getInstance().setClipboard(iDatapoolPart.getClipboard());
        this.createTable(composite);
        this.tableUtil = new DatapoolTableUtil(this);
        this.createMenu();
        this.table.addSelectionListener((SelectionListener)this);
        iDatapool.addDatapoolListener((IDatapoolListener)this);
        this.datapoolMenuManager = new DatapoolMenuManager(this, this.vendorID, this.showEquivlenceClasses, this.showVariables, this.showRecords);
        this.setMenuMode(this.datapoolMenuManager);
        try {
            composite.getParent().getParent().addControlListener(this.resizeListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.unsetWaitCursor();
    }

    private void createMenu() {
        MenuManager menuManager = new MenuManager("#DatapoolEditor");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        this.contextMenu = menuManager.createContextMenu((Control)this.table);
        this.table.setMenu(this.contextMenu);
    }

    private void createTable(Composite composite) {
        this.table = new Table(composite, 67584);
        this.viewer = new TableViewer(this.table);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 60000;
        gridData.heightHint = 120000;
        this.table.setLayoutData((Object)gridData);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(100, false));
        this.table.setLayout((Layout)tableLayout);
        if (this.isWithoutColumns()) {
            this.makeHeaderColumn();
        } else {
            this.makeColumns();
        }
        if (!this.isWithoutRows()) {
            this.makeRows();
        }
        this.createCursor();
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 262144 && (keyEvent.stateMask & 0x20000) != 0) {
                    return;
                }
                if (keyEvent.keyCode == 131072 && (keyEvent.stateMask & 0x40000) != 0) {
                    return;
                }
                if (keyEvent.keyCode != 262144 && (keyEvent.stateMask & 0x40000) != 0) {
                    return;
                }
                if (keyEvent.keyCode != 131072 && (keyEvent.stateMask & 0x20000) != 0) {
                    return;
                }
                if (DatapoolTable.this.table.getItemCount() != 0) {
                    TableItem[] tableItemArray = DatapoolTable.this.table.getSelection();
                    TableItem tableItem = tableItemArray.length == 0 ? DatapoolTable.this.table.getItem(DatapoolTable.this.table.getTopIndex()) : tableItemArray[0];
                    DatapoolTable.this.table.showItem(tableItem);
                    if (DatapoolTable.this.cursor != null && !DatapoolTable.this.cursor.isDisposed()) {
                        DatapoolTable.this.cursor.setSelection(tableItem, 0);
                        DatapoolTable.this.cursor.setVisible(true);
                        DatapoolTable.this.cursor.setFocus();
                    }
                }
            }
        });
        this.table.addMouseListener((MouseListener)new TableMouseAdapter());
    }

    private void createCursor() {
        if (this.datapool.getEquivalenceClassCount() == 0 || this.datapool.getEquivalenceClassCount() == 1 && this.datapool.getEquivalenceClass(0).getRecordCount() == 0) {
            return;
        }
        this.cursor = new TableCursor(this.table, 0);
        this.controlEditor = new ControlEditor((Composite)this.cursor);
        this.controlEditor.grabHorizontal = true;
        this.controlEditor.grabVertical = true;
        this.cursor.setMenu(this.contextMenu);
        this.cursor.addSelectionListener((SelectionListener)new CursorSelectionAdapter(this.cursor, this.cellEditor, this.datapoolPart));
        this.cursor.addKeyListener((KeyListener)new CursorKeyAdapter(this.cursor, this.cellEditor, this.datapoolPart));
        this.cursor.addMouseListener((MouseListener)new CursorMouseAdapter(this.cursor, this.cellEditor, this.datapoolPart));
        if (this.table.getItemCount() > 0) {
            this.table.select(0);
            this.cursor.setSelection(0, 0);
        }
    }

    private void setWaitCursor() {
        if (this.parent == null) {
            return;
        }
        Display display = this.parent.getShell().getDisplay();
        Cursor cursor = new Cursor((Device)display, 1);
        this.setDisplayCursor(cursor);
    }

    private void unsetWaitCursor() {
        this.setDisplayCursor(null);
    }

    private void setDisplayCursor(Cursor cursor) {
        if (this.parent == null) {
            return;
        }
        Display display = this.parent.getShell().getDisplay();
        Shell[] shellArray = display.getShells();
        int n = 0;
        while (n < shellArray.length) {
            shellArray[n].setCursor(cursor);
            ++n;
        }
    }

    private void applyEditingValue(Object object, boolean bl) {
        if (this.cursor != null && this.cursor.getColumn() > 0) {
            if (object == null) {
                return;
            }
            String string = object.toString();
            TableItem tableItem = this.cursor.getRow();
            int n = this.cursor.getColumn();
            if (tableItem == null || tableItem.isDisposed()) {
                return;
            }
            IDatapoolCell[] iDatapoolCellArray = (IDatapoolCell[])tableItem.getData(TAG_DATA);
            IDatapoolCell iDatapoolCell = iDatapoolCellArray[this.cursor.getColumn() - 1];
            if (string.equals(iDatapoolCell.getStringValue())) {
                if (bl) {
                    this.clearCellEditor();
                }
                return;
            }
            iDatapoolCell.setCellValue(object);
            tableItem.setText(this.cursor.getColumn(), string);
            this.cursor.setSelection(this.table.getSelectionIndex(), this.cursor.getColumn());
            this.datapoolPart.markDirty();
            if (bl) {
                this.clearCellEditor();
            }
        }
    }

    private void makeColumns() {
        this.makeHeaderColumn();
        int n = 0;
        while (n < this.datapool.getVariableCount()) {
            TableColumn tableColumn = new TableColumn(this.table, 0, n + 1);
            IDatapoolVariable iDatapoolVariable = (IDatapoolVariable)this.datapool.getVariable(n);
            tableColumn.setResizable(true);
            IDatapoolSuggestedType iDatapoolSuggestedType = (IDatapoolSuggestedType)iDatapoolVariable.getSuggestedType();
            String string = new String();
            if (iDatapoolSuggestedType != null) {
                // empty if block
            }
            string = iDatapoolSuggestedType.getSuggestedClassName();
            tableColumn.setText(iDatapoolVariable.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + string);
            tableColumn.setData(TAG_VARIABLE, (Object)iDatapoolVariable);
            tableColumn.setData(TAG_VARIABLE_INDEX, (Object)new Integer(n));
            tableColumn.setWidth(100);
            tableColumn.addSelectionListener(this.headerListener);
            tableColumn.addControlListener(this.resizeColumnListener);
            ++n;
        }
    }

    private void makeHeaderColumn() {
        TableColumn tableColumn = new TableColumn(this.table, 0, 0);
        tableColumn.setResizable(true);
        if (!this.showEquivlenceClasses) {
            tableColumn.setWidth(20);
        } else {
            tableColumn.setWidth(100);
        }
        tableColumn.setData(TAG_VARIABLE, null);
        tableColumn.addControlListener(this.resizeColumnListener);
    }

    private void makeRows() {
        int n = 0;
        while (n < this.datapool.getEquivalenceClassCount()) {
            IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(n);
            int n2 = 0;
            while (n2 < iDatapoolEquivalenceClass.getRecordCount()) {
                IDatapoolCell iDatapoolCell;
                org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)iDatapoolEquivalenceClass.getRecord(n2);
                int n3 = iDatapoolRecord.getCellCount();
                String[] stringArray = new String[this.datapool.getVariableCount() + 1];
                IDatapoolCell[] iDatapoolCellArray = new IDatapoolCell[this.datapool.getVariableCount()];
                stringArray[0] = this.showEquivlenceClasses ? iDatapoolEquivalenceClass.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + String.valueOf(n2) : String.valueOf(n2);
                int n4 = 0;
                while (n4 < n3) {
                    iDatapoolCell = (IDatapoolCell)iDatapoolRecord.getCell(n4);
                    IDatapoolVariable iDatapoolVariable = (IDatapoolVariable)iDatapoolCell.getCellVariable();
                    int n5 = this.findColumnIndex(iDatapoolVariable.getName());
                    String string = new String();
                    if (iDatapoolCell.getStringValue() != null) {
                        string = iDatapoolCell.getStringValue();
                    }
                    stringArray[n5] = string;
                    iDatapoolCellArray[n5 - 1] = iDatapoolCell;
                    ++n4;
                }
                iDatapoolCell = new TableItem(this.table, 0);
                iDatapoolCell.setText(stringArray);
                iDatapoolCell.setData(TAG_DATA, (Object)iDatapoolCellArray);
                iDatapoolCell.setData(TAG_RECORD, (Object)iDatapoolRecord);
                iDatapoolCell.setData(TAG_EQUIVALENCE_CLASS, (Object)iDatapoolEquivalenceClass);
                ++n2;
            }
            ++n;
        }
    }

    private boolean isWithoutRows() {
        if (this.datapool.getEquivalenceClassCount() > 0) {
            if (this.datapool.getEquivalenceClassCount() == 1) {
                IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(0);
                return iDatapoolEquivalenceClass.getRecordCount() == 0;
            }
            return false;
        }
        return true;
    }

    private boolean isWithoutColumns() {
        return this.datapool.getVariableCount() == 0;
    }

    private int findColumnIndex(String string) {
        int n = 0;
        while (n < this.table.getColumnCount()) {
            TableColumn tableColumn = this.table.getColumn(n);
            IDatapoolVariable iDatapoolVariable = (IDatapoolVariable)tableColumn.getData(TAG_VARIABLE);
            if (iDatapoolVariable != null && string.equals(iDatapoolVariable.getName())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void setScrollBars() {
        Point point = this.cursor.getLocation();
        Composite composite = this.parent.getParent().getParent();
        if (composite != null && composite instanceof ScrolledComposite) {
            int n = composite.getBounds().height;
            int n2 = composite.getBounds().width;
            int n3 = point.x - n2 + this.cursor.getBounds().width + 30;
            int n4 = point.y - n + this.cursor.getBounds().height + 53;
            ((ScrolledComposite)composite).setOrigin(n3, n4);
        }
    }

    private void resizeScrollBars() {
        block10: {
            try {
                Composite composite = this.parent.getParent().getParent();
                int n = composite.getHorizontalBar().getMaximum();
                int n2 = composite.getVerticalBar().getMaximum();
                int n3 = composite.getBounds().height;
                int n4 = composite.getBounds().width;
                int n5 = this.table.getBounds().width;
                int n6 = this.table.getBounds().height;
                int n7 = 0;
                int n8 = 68;
                int n9 = 0;
                while (n9 < this.table.getColumnCount()) {
                    n7 += this.table.getColumn(n9).getWidth();
                    ++n9;
                }
                int n10 = 0;
                while (n10 < this.table.getItemCount()) {
                    TableItem tableItem = this.table.getItem(n10);
                    n8 += tableItem.getBounds((int)0).height + 1;
                    ++n10;
                }
                if (n7 < n4) {
                    composite.getHorizontalBar().setVisible(false);
                } else {
                    composite.getHorizontalBar().setVisible(true);
                    if (n < 119) {
                        composite.getHorizontalBar().setMaximum(n7 - n4 + 44);
                    } else {
                        composite.getHorizontalBar().setMaximum(n7 + 12);
                    }
                }
                if (n8 < n3) {
                    composite.getVerticalBar().setVisible(false);
                    break block10;
                }
                composite.getVerticalBar().setVisible(true);
                if (n2 < 119) {
                    composite.getVerticalBar().setMaximum(n8 - n3 + 58);
                    break block10;
                }
                composite.getVerticalBar().setMaximum(n8 - 12);
            }
            catch (Exception exception) {}
        }
    }

    private void resetScrollBarSize(boolean bl) {
        block10: {
            try {
                Composite composite = this.table.getParent().getParent().getParent();
                int n = composite.getHorizontalBar().getMaximum();
                int n2 = composite.getVerticalBar().getMaximum();
                int n3 = composite.getBounds().height;
                int n4 = composite.getBounds().width;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                while (n7 < this.table.getColumnCount()) {
                    n5 += this.table.getColumn(n7).getWidth();
                    ++n7;
                }
                int n8 = 0;
                while (n8 < this.table.getItemCount()) {
                    TableItem tableItem = this.table.getItem(n8);
                    n6 += tableItem.getBounds((int)0).height + 1;
                    ++n8;
                }
                if (n5 + 14 < n4) {
                    n5 = 0;
                }
                if (n6 < n3) {
                    n6 = 0;
                }
                if (bl) {
                    composite.getHorizontalBar().setMaximum(n + n5 - 60000 - 26);
                    composite.getVerticalBar().setMaximum(n2 + n6 - 120000 - 4);
                    break block10;
                }
                if (n < 119) {
                    composite.getHorizontalBar().setMaximum(n5 - n4 + 44);
                } else {
                    composite.getHorizontalBar().setMaximum(n5 + 12);
                }
                if (n2 < 119) {
                    composite.getVerticalBar().setMaximum(n6 - n3 + 58);
                    break block10;
                }
                composite.getVerticalBar().setMaximum(n6 - 12);
            }
            catch (Exception exception) {}
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        int n;
        int n2 = this.table.getSelectionIndex();
        if (this.cursor != null && !this.cursor.isDisposed() && (n = this.cursor.getColumn()) >= 0) {
            this.cursor.setSelection(n2, n);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        this.datapoolMenuManager.addActions(iMenuManager);
        this.setMenuMode(this.datapoolMenuManager);
    }

    private void setMenuMode(DatapoolMenuManager datapoolMenuManager) {
        if (datapoolMenuManager == null) {
            return;
        }
        int n = 0;
        if (this.cursor != null && !this.cursor.isDisposed()) {
            n = this.cursor.getColumn() == 0 ? 0 : 1;
        }
        if (this.table.getSelectionIndex() == -1) {
            n = 2;
        }
        if (this.datapool.getEquivalenceClassCount() == 0 && this.datapool.getVariableCount() > 0) {
            n = 3;
        }
        if (this.datapool.getEquivalenceClassCount() == 0 && this.datapool.getVariableCount() == 0) {
            n = 4;
        }
        if (this.datapoolPart.isReadOnly()) {
            n = 5;
        }
        datapoolMenuManager.setDisplayMode(n);
    }

    public void insertRowGroup() {
        DatapoolRowGroupDialog datapoolRowGroupDialog;
        if (!this.showEquivlenceClasses) {
            return;
        }
        TableItem tableItem = null;
        if (this.cursor != null && !this.cursor.isDisposed()) {
            tableItem = this.cursor.getRow();
        }
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = null;
        if (tableItem != null) {
            iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
        }
        if ((datapoolRowGroupDialog = new DatapoolRowGroupDialog(Display.getCurrent().getActiveShell(), this.datapool, this.table, null, iDatapoolEquivalenceClass, DatapoolPlugin.getResourceString("DATA_ROW_GRP_DLG_TITLE_INS"))).open() == 0) {
            this.setWaitCursor();
            String string = datapoolRowGroupDialog.getName();
            if (string != null && string.length() != 0) {
                IDatapoolEquivalenceClass iDatapoolEquivalenceClass2 = null;
                if (this.datapool.getEquivalenceClassCount() == 1 && this.datapool.getEquivalenceClass(0).getRecordCount() == 0) {
                    iDatapoolEquivalenceClass2 = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(0);
                } else {
                    iDatapoolEquivalenceClass2 = this.datapool.constructEquivalenceClass();
                    int n = datapoolRowGroupDialog.getInsertionIndex();
                    this.datapool.insertEquivalenceClass(iDatapoolEquivalenceClass2, n + 1);
                }
                iDatapoolEquivalenceClass2.setName(string);
                org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = iDatapoolEquivalenceClass2.constructRecord(this.createCells(this.datapool));
                iDatapoolEquivalenceClass2.insertRecord(iDatapoolRecord, 0);
            }
            this.unsetWaitCursor();
        }
    }

    public void deleteRowGroup() {
        if (!this.showEquivlenceClasses) {
            return;
        }
        TableItem tableItem = null;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        tableItem = this.cursor.getRow();
        this.setWaitCursor();
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
        int n = this.datapool.getEquivalenceClassIndexById(iDatapoolEquivalenceClass.getId());
        this.datapool.removeEquivalenceClass(n);
        this.unsetWaitCursor();
    }

    public void editRowGroup() {
        TableItem tableItem = null;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        tableItem = this.cursor.getRow();
        this.editRowGroupAux(tableItem);
    }

    private void editRowGroupAux(TableItem tableItem) {
        DatapoolRowGroupDialog datapoolRowGroupDialog;
        if (!this.showEquivlenceClasses) {
            return;
        }
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = null;
        if (tableItem != null) {
            iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
        }
        int n = -1;
        if (iDatapoolEquivalenceClass != null) {
            n = this.datapool.getEquivalenceClassIndexById(iDatapoolEquivalenceClass.getId());
        }
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass2 = null;
        if (n != -1 && n != 0) {
            iDatapoolEquivalenceClass2 = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(n - 1);
        }
        if ((datapoolRowGroupDialog = new DatapoolRowGroupDialog(Display.getCurrent().getActiveShell(), this.datapool, this.table, iDatapoolEquivalenceClass, iDatapoolEquivalenceClass2, DatapoolPlugin.getResourceString("DATA_ROW_GRP_DLG_TITLE_EDIT"))).open() == 0) {
            int n2;
            this.setWaitCursor();
            String string = datapoolRowGroupDialog.getName();
            if (!iDatapoolEquivalenceClass.getName().equals(string)) {
                iDatapoolEquivalenceClass.setName(string);
            }
            if ((n2 = datapoolRowGroupDialog.getInsertionIndex()) == n - 1) {
                this.unsetWaitCursor();
                return;
            }
            this.datapool.moveEquivalenceClass(n, n2);
            this.unsetWaitCursor();
        }
    }

    public void insertRow() {
        DatapoolRowDialog datapoolRowDialog;
        TableItem tableItem = null;
        if (this.cursor != null && !this.cursor.isDisposed()) {
            tableItem = this.cursor.getRow();
        }
        if (!this.showRecords) {
            return;
        }
        if (!this.showEquivlenceClasses) {
            if (this.datapool.getEquivalenceClassCount() == 0) {
                this.setWaitCursor();
                IDatapoolEquivalenceClass iDatapoolEquivalenceClass = this.datapool.constructEquivalenceClass();
                this.datapool.insertEquivalenceClass(iDatapoolEquivalenceClass, 0);
                iDatapoolEquivalenceClass.setName(this.vendorID);
                org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = iDatapoolEquivalenceClass.constructRecord(this.createCells(this.datapool));
                iDatapoolEquivalenceClass.insertRecord(iDatapoolRecord, 0);
                this.unsetWaitCursor();
                return;
            }
            if (this.datapool.getEquivalenceClassCount() == 1 && this.datapool.getEquivalenceClass(0).getRecordCount() == 0) {
                this.setWaitCursor();
                IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(0);
                iDatapoolEquivalenceClass.setName(this.vendorID);
                org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = iDatapoolEquivalenceClass.constructRecord(this.createCells(this.datapool));
                iDatapoolEquivalenceClass.insertRecord(iDatapoolRecord, 0);
                this.unsetWaitCursor();
                return;
            }
            if (tableItem != null) {
                DatapoolAddDialogSimple datapoolAddDialogSimple;
                int n = this.table.indexOf(tableItem);
                IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
                org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)tableItem.getData(TAG_RECORD);
                if (iDatapoolEquivalenceClass == null || iDatapoolRecord == null) {
                    return;
                }
                if (iDatapoolEquivalenceClass.getRecordCount() == 0) {
                    return;
                }
                org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord2 = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)iDatapoolEquivalenceClass.getRecord(0);
                if (iDatapoolRecord2.equals(iDatapoolRecord)) {
                    datapoolAddDialogSimple = new DatapoolAddDialogSimple(Display.getCurrent().getActiveShell(), DatapoolPlugin.getResourceString("DATA_ADD_ROW_TITLE"));
                    if (datapoolAddDialogSimple.open() == 0) {
                        n += datapoolAddDialogSimple.getIndexAdjustment();
                    } else {
                        return;
                    }
                }
                this.setWaitCursor();
                datapoolAddDialogSimple = iDatapoolEquivalenceClass.constructRecord(this.createCells(this.datapool));
                iDatapoolEquivalenceClass.insertRecord((org.eclipse.hyades.edit.datapool.IDatapoolRecord)datapoolAddDialogSimple, n + 1);
                this.unsetWaitCursor();
                return;
            }
        }
        if ((datapoolRowDialog = new DatapoolRowDialog(Display.getCurrent().getActiveShell(), this.datapool, this.table, null, tableItem, DatapoolPlugin.getResourceString("DATA_ROW_DLG_TITLE_INS"))).open() == 0) {
            this.setWaitCursor();
            int n = datapoolRowDialog.getInsertionEquivalenceClassIndex();
            int n2 = datapoolRowDialog.getInsertionRecordIndex();
            if (n != -1 && n2 != -1) {
                IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(n);
                org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = iDatapoolEquivalenceClass.constructRecord(this.createCells(this.datapool));
                iDatapoolEquivalenceClass.insertRecord(iDatapoolRecord, n2 + 1);
            } else {
                IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(n);
                org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = iDatapoolEquivalenceClass.constructRecord(this.createCells(this.datapool));
                iDatapoolEquivalenceClass.insertRecord(iDatapoolRecord, 0);
            }
            this.unsetWaitCursor();
        }
    }

    public void deleteRow() {
        if (!this.showRecords) {
            return;
        }
        TableItem tableItem = null;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        tableItem = this.cursor.getRow();
        this.setWaitCursor();
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
        org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)tableItem.getData(TAG_RECORD);
        int n = this.datapool.getEquivalenceClassIndexById(iDatapoolEquivalenceClass.getId());
        int n2 = this.getRecordIndex(iDatapoolEquivalenceClass, iDatapoolRecord);
        iDatapoolEquivalenceClass.removeRecord(n2);
        if (iDatapoolEquivalenceClass.getRecordCount() == 0) {
            this.ignoreECNotification = true;
            this.datapool.removeEquivalenceClass(n);
        }
        this.unsetWaitCursor();
    }

    public void editRow() {
        TableItem tableItem = null;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        tableItem = this.cursor.getRow();
        this.editRowAux(tableItem);
    }

    private void editRowAux(TableItem tableItem) {
        DatapoolRowDialog datapoolRowDialog;
        if (!this.showRecords) {
            return;
        }
        int n = this.table.getSelectionIndex();
        TableItem tableItem2 = null;
        if (n != 0) {
            tableItem2 = this.table.getItem(n - 1);
        }
        if ((datapoolRowDialog = new DatapoolRowDialog(Display.getCurrent().getActiveShell(), this.datapool, this.table, tableItem, tableItem2, DatapoolPlugin.getResourceString("DATA_ROW_DLG_TITLE_EDIT"))).open() == 0) {
            this.setWaitCursor();
            IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
            int n2 = this.datapool.getEquivalenceClassIndexById(iDatapoolEquivalenceClass.getId());
            org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)tableItem.getData(TAG_RECORD);
            int n3 = this.getRecordIndex(iDatapoolEquivalenceClass, iDatapoolRecord);
            int n4 = datapoolRowDialog.getInsertionEquivalenceClassIndex();
            int n5 = datapoolRowDialog.getInsertionRecordIndex();
            if (n2 == n4) {
                if (n3 != n5 + 1) {
                    if (n5 > n3) {
                        iDatapoolEquivalenceClass.moveRecord(n3, n5);
                    } else {
                        iDatapoolEquivalenceClass.moveRecord(n3, n5 + 1);
                    }
                }
            } else if (n4 != -1 && n5 != -1) {
                IDatapoolEquivalenceClass iDatapoolEquivalenceClass2 = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(n4);
                iDatapoolEquivalenceClass.removeRecord(n3);
                iDatapoolEquivalenceClass2.insertRecord(iDatapoolRecord, n5 + 1);
                if (iDatapoolEquivalenceClass.getRecordCount() == 0) {
                    this.ignoreECNotification = true;
                    this.datapool.removeEquivalenceClass(n2);
                }
            } else {
                IDatapoolEquivalenceClass iDatapoolEquivalenceClass3 = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(n4);
                iDatapoolEquivalenceClass.removeRecord(n3);
                iDatapoolEquivalenceClass3.insertRecord(iDatapoolRecord, 0);
                if (iDatapoolEquivalenceClass.getRecordCount() == 0) {
                    this.ignoreECNotification = true;
                    this.datapool.removeEquivalenceClass(n2);
                }
            }
            this.unsetWaitCursor();
        }
    }

    public void insertColumn() {
        DatapoolColumnDialog datapoolColumnDialog;
        if (!this.showVariables) {
            return;
        }
        int n = -1;
        if (this.cursor != null && !this.cursor.isDisposed()) {
            n = this.cursor.getColumn();
        }
        TableColumn tableColumn = null;
        if (n > 0) {
            tableColumn = this.table.getColumn(n);
        }
        IDatapoolVariable iDatapoolVariable = null;
        if (tableColumn != null) {
            iDatapoolVariable = (IDatapoolVariable)tableColumn.getData(TAG_VARIABLE);
        }
        if ((datapoolColumnDialog = new DatapoolColumnDialog(Display.getCurrent().getActiveShell(), this.datapool, null, iDatapoolVariable, DatapoolPlugin.getResourceString("DATA_COL_DLG_TITLE_INS"))).open() == 0) {
            this.setWaitCursor();
            IDatapoolVariable iDatapoolVariable2 = this.datapool.constructVariable();
            iDatapoolVariable2.setName(datapoolColumnDialog.getName());
            IDatapoolSuggestedType iDatapoolSuggestedType = (IDatapoolSuggestedType)iDatapoolVariable2.getSuggestedType();
            this.setVariableType(iDatapoolSuggestedType, datapoolColumnDialog.getType());
            iDatapoolVariable2.setSuggestedType(iDatapoolSuggestedType);
            int n2 = this.findColumnIndex(datapoolColumnDialog.getInsertionVariableName());
            if (n2 == -1) {
                n2 = 0;
            }
            this.datapool.insertVariable(iDatapoolVariable2, n2);
            this.unsetWaitCursor();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteColumn() {
        if (!this.showVariables) {
            return;
        }
        if (this.cursor == null || this.cursor.isDisposed()) {
            if (this.table.getItemCount() != 0 || this.tableUtil.getColumnCount() <= 0) return;
            DatapoolDeleteColumnDialog datapoolDeleteColumnDialog = new DatapoolDeleteColumnDialog(Display.getCurrent().getActiveShell(), this.datapool);
            if (datapoolDeleteColumnDialog.open() != 0) return;
            this.setWaitCursor();
            String string = datapoolDeleteColumnDialog.getDeletedVariableID();
            int n = this.datapool.getVariableIndexById(string);
            this.datapool.removeVariable(n);
            this.unsetWaitCursor();
            return;
        } else {
            int n = this.cursor.getColumn();
            int n2 = this.table.getSelectionIndex();
            if (n < 1) {
                return;
            }
            this.setWaitCursor();
            TableColumn tableColumn = this.table.getColumn(n);
            IDatapoolVariable iDatapoolVariable = (IDatapoolVariable)tableColumn.getData(TAG_VARIABLE);
            int n3 = this.datapool.getVariableIndexById(iDatapoolVariable.getId());
            this.datapool.removeVariable(n3);
            this.unsetWaitCursor();
        }
    }

    public void editColumn() {
        int n = this.cursor.getColumn();
        TableColumn tableColumn = this.table.getColumn(n);
        this.editColumnAux(tableColumn);
    }

    private void editColumnAux(TableColumn tableColumn) {
        if (!this.showVariables) {
            return;
        }
        int n = this.table.indexOf(tableColumn);
        TableColumn tableColumn2 = null;
        if (n != 0) {
            tableColumn2 = this.table.getColumn(n - 1);
        }
        IDatapoolVariable iDatapoolVariable = null;
        if (tableColumn2 != null) {
            iDatapoolVariable = (IDatapoolVariable)tableColumn2.getData(TAG_VARIABLE);
        }
        IDatapoolVariable iDatapoolVariable2 = (IDatapoolVariable)tableColumn.getData(TAG_VARIABLE);
        DatapoolColumnDialog datapoolColumnDialog = new DatapoolColumnDialog(Display.getCurrent().getActiveShell(), this.datapool, iDatapoolVariable2, iDatapoolVariable, DatapoolPlugin.getResourceString("DATA_COL_DLG_TITLE_EDIT"));
        if (datapoolColumnDialog.open() == 0) {
            this.setWaitCursor();
            String string = datapoolColumnDialog.getName();
            String string2 = datapoolColumnDialog.getType();
            String string3 = datapoolColumnDialog.getInsertionVariableID();
            String string4 = new String();
            if (iDatapoolVariable != null) {
                string4 = iDatapoolVariable.getId();
            }
            IDatapoolSuggestedType iDatapoolSuggestedType = (IDatapoolSuggestedType)iDatapoolVariable2.getSuggestedType();
            if (string.equals(iDatapoolVariable2.getName()) && string2.equals(iDatapoolSuggestedType.getSuggestedClassName()) && string3.equals(string4)) {
                this.unsetWaitCursor();
                return;
            }
            iDatapoolVariable2.setName(datapoolColumnDialog.getName());
            this.setVariableType(iDatapoolSuggestedType, datapoolColumnDialog.getType());
            iDatapoolVariable2.setSuggestedType(iDatapoolSuggestedType);
            Integer n2 = (Integer)tableColumn.getData(TAG_VARIABLE_INDEX);
            int n3 = this.findColumnIndex(datapoolColumnDialog.getInsertionVariableName());
            if (n3 == n - 1) {
                this.unsetWaitCursor();
                return;
            }
            if (n3 == -1) {
                this.datapool.moveVariable(n - 1, 0);
            } else if (n3 > n) {
                this.datapool.moveVariable(n - 1, n3 - 1);
            } else {
                this.datapool.moveVariable(n - 1, n3);
            }
            this.unsetWaitCursor();
        }
    }

    public void clearCell() {
        this.applyEditingValue(new String(), true);
    }

    public void variableAdded(IDatapool iDatapool, int n) {
        int n2;
        TableColumn tableColumn = new TableColumn(this.table, 0, n + 1);
        IDatapoolVariable iDatapoolVariable = (IDatapoolVariable)iDatapool.getVariable(n);
        tableColumn.setResizable(true);
        IDatapoolSuggestedType iDatapoolSuggestedType = (IDatapoolSuggestedType)iDatapoolVariable.getSuggestedType();
        String string = new String();
        if (iDatapoolSuggestedType != null) {
            // empty if block
        }
        string = iDatapoolSuggestedType.getSuggestedClassName();
        tableColumn.setText(iDatapoolVariable.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + string);
        tableColumn.setData(TAG_VARIABLE, (Object)iDatapoolVariable);
        tableColumn.setData(TAG_VARIABLE_INDEX, (Object)new Integer(n));
        tableColumn.setWidth(100);
        tableColumn.addSelectionListener(this.headerListener);
        tableColumn.addControlListener(this.resizeColumnListener);
        this.tableUtil.insertColumn(tableColumn, n);
        if (this.cursor != null && !this.cursor.isDisposed() && (n2 = this.table.getSelectionIndex()) >= 0) {
            this.table.setSelection(n2);
            this.cursor.setSelection(n2, n + 1);
            this.cursor.setFocus();
            this.resizeScrollBars();
            this.setScrollBars();
        }
        this.datapoolPart.markDirty();
    }

    public void variableRemoved(IDatapool iDatapool, int n) {
        this.tableUtil.deleteColumn(n + 1);
        if (this.cursor != null && !this.cursor.isDisposed()) {
            if (n > 0) {
                int n2 = this.table.getSelectionIndex();
                if (n2 >= 0) {
                    this.table.select(n2);
                    this.cursor.setSelection(n2, n);
                    this.resizeScrollBars();
                    this.setScrollBars();
                }
            } else {
                this.table.deselectAll();
            }
        }
        this.datapoolPart.markDirty();
    }

    public void variableMoved(IDatapool iDatapool, int n, int n2) {
        int n3;
        this.tableUtil.moveColumn(n + 1, n2 + 1);
        if (this.cursor != null && !this.cursor.isDisposed() && n2 > 0 && (n3 = this.table.getSelectionIndex()) >= 0) {
            this.table.select(n3);
            this.cursor.setSelection(n3, n2);
            this.setScrollBars();
        }
        this.datapoolPart.markDirty();
    }

    public void variableChanged(IDatapool iDatapool, int n) {
        IDatapoolVariable iDatapoolVariable = (IDatapoolVariable)iDatapool.getVariable(n);
        int n2 = this.findColumnIndex(iDatapoolVariable.getName());
        TableColumn tableColumn = this.table.getColumn(n2);
        IDatapoolSuggestedType iDatapoolSuggestedType = (IDatapoolSuggestedType)iDatapoolVariable.getSuggestedType();
        String string = new String();
        if (iDatapoolSuggestedType != null) {
            // empty if block
        }
        string = iDatapoolSuggestedType.getSuggestedClassName();
        tableColumn.setText(iDatapoolVariable.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + string);
        tableColumn.setData(TAG_VARIABLE, (Object)iDatapoolVariable);
        tableColumn.setData(TAG_VARIABLE_INDEX, (Object)new Integer(n));
        this.datapoolPart.markDirty();
    }

    public void variableChanged(IDatapool iDatapool, int n, String string) {
        this.variableChanged(iDatapool, n);
    }

    public void equivalenceClassChanged(IDatapool iDatapool, int n) {
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)iDatapool.getEquivalenceClass(n);
        int n2 = 0;
        while (n2 < iDatapoolEquivalenceClass.getRecordCount()) {
            int n3 = this.findRowIndex(n, n2);
            TableItem tableItem = this.table.getItem(n3);
            tableItem.setText(0, iDatapoolEquivalenceClass.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + String.valueOf(n2));
            if (this.cursor != null && !this.cursor.isDisposed()) {
                this.cursor.redraw();
            }
            this.datapoolPart.markDirty();
            ++n2;
        }
    }

    public void equivalenceClassChanged(IDatapool iDatapool, int n, String string) {
        this.equivalenceClassChanged(iDatapool, n);
    }

    public void equivalenceClassAdded(IDatapool iDatapool, int n) {
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)iDatapool.getEquivalenceClass(n);
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass2 = null;
        int n2 = 0;
        if (n > 0) {
            iDatapoolEquivalenceClass2 = (IDatapoolEquivalenceClass)iDatapool.getEquivalenceClass(n - 1);
            n2 = this.findRowIndex(n - 1, iDatapoolEquivalenceClass2.getRecordCount() - 1) + 1;
        }
        int n3 = 0;
        while (n3 < iDatapoolEquivalenceClass.getRecordCount()) {
            IDatapoolCell iDatapoolCell;
            org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)iDatapoolEquivalenceClass.getRecord(n3);
            String[] stringArray = new String[this.table.getColumnCount()];
            IDatapoolCell[] iDatapoolCellArray = new IDatapoolCell[this.table.getColumnCount() - 1];
            stringArray[0] = iDatapoolEquivalenceClass.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + String.valueOf(n3);
            int n4 = 0;
            while (n4 < iDatapoolRecord.getCellCount()) {
                iDatapoolCell = (IDatapoolCell)iDatapoolRecord.getCell(n4);
                org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable iDatapoolVariable = iDatapoolCell.getCellVariable();
                int n5 = this.findColumnIndex(iDatapoolVariable.getName());
                stringArray[n5] = iDatapoolCell.getStringValue();
                iDatapoolCellArray[n5 - 1] = iDatapoolCell;
                ++n4;
            }
            iDatapoolCell = new TableItem(this.table, 0, n2 + n3);
            iDatapoolCell.setText(stringArray);
            iDatapoolCell.setData(TAG_DATA, (Object)iDatapoolCellArray);
            iDatapoolCell.setData(TAG_RECORD, (Object)iDatapoolRecord);
            iDatapoolCell.setData(TAG_EQUIVALENCE_CLASS, (Object)iDatapoolEquivalenceClass);
            ++n3;
        }
        this.datapoolPart.markDirty();
    }

    public void equivalenceClassRemoved(IDatapool iDatapool, int n) {
        if (this.ignoreECNotification) {
            this.ignoreECNotification = false;
            return;
        }
        int n2 = this.findRowIndex(n, 0);
        TableItem tableItem = this.table.getItem(n2);
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
        boolean bl = true;
        while (bl) {
            this.table.remove(n2);
            if (n2 < this.table.getItemCount()) {
                tableItem = this.table.getItem(n2);
                IDatapoolEquivalenceClass iDatapoolEquivalenceClass2 = (IDatapoolEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
                if (iDatapoolEquivalenceClass2.equals(iDatapoolEquivalenceClass)) continue;
                bl = false;
                continue;
            }
            bl = false;
        }
        this.datapoolPart.markDirty();
        if (this.cursor != null && !this.cursor.isDisposed() && this.table != null) {
            int n3 = this.table.getItemCount();
            if (n3 == 0) {
                this.table.deselectAll();
                this.cursor.dispose();
                return;
            }
            if (n3 > n2) {
                this.table.setSelection(n2);
                this.cursor.setSelection(n2, 0);
                this.resizeScrollBars();
                this.setScrollBars();
                return;
            }
            if (n3 > n2 - 1) {
                this.table.setSelection(n2 - 1);
                this.cursor.setSelection(n2 - 1, 0);
                this.resizeScrollBars();
                this.setScrollBars();
            }
        }
    }

    public void equivalenceClassMoved(IDatapool iDatapool, int n, int n2) {
        int n3;
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass;
        if (n == n2) {
            return;
        }
        int n4 = 0;
        if (n2 != -1) {
            iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)iDatapool.getEquivalenceClass(n2);
            n3 = iDatapoolEquivalenceClass.getRecordCount();
            if (n < n2) {
                --n3;
            }
            n4 = this.findRowIndex(n2, n3);
        }
        iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)iDatapool.getEquivalenceClass(n);
        n3 = iDatapoolEquivalenceClass.getRecordCount();
        int n5 = this.findRowIndex(n, 0);
        int n6 = 0;
        while (n6 < iDatapoolEquivalenceClass.getRecordCount()) {
            if (n > n2) {
                this.tableUtil.moveRow(n5 + n3 - 1, n4);
            } else {
                this.tableUtil.moveRow(n5, n4);
            }
            ++n6;
        }
        if (this.cursor != null && !this.cursor.isDisposed() && this.table != null) {
            this.table.setSelection(n4);
            this.cursor.setSelection(n4, 0);
            this.setScrollBars();
        }
        this.datapoolPart.markDirty();
    }

    public void recordAdded(IDatapool iDatapool, int n, int n2) {
        org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable iDatapoolVariable;
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)iDatapool.getEquivalenceClass(n);
        org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)iDatapoolEquivalenceClass.getRecord(n2);
        String[] stringArray = new String[this.table.getColumnCount()];
        IDatapoolCell[] iDatapoolCellArray = new IDatapoolCell[this.table.getColumnCount() - 1];
        stringArray[0] = this.showEquivlenceClasses ? iDatapoolEquivalenceClass.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + String.valueOf(n2) : String.valueOf(n2);
        int n3 = 0;
        while (n3 < iDatapoolRecord.getCellCount()) {
            IDatapoolCell iDatapoolCell = (IDatapoolCell)iDatapoolRecord.getCell(n3);
            iDatapoolVariable = iDatapoolCell.getCellVariable();
            int n4 = this.findColumnIndex(iDatapoolVariable.getName());
            stringArray[n4] = iDatapoolCell.getStringValue();
            iDatapoolCellArray[n4 - 1] = iDatapoolCell;
            ++n3;
        }
        int n5 = this.findRowIndex(n, n2);
        iDatapoolVariable = new TableItem(this.table, 0, n5);
        iDatapoolVariable.setText(stringArray);
        iDatapoolVariable.setData(TAG_DATA, (Object)iDatapoolCellArray);
        iDatapoolVariable.setData(TAG_RECORD, (Object)iDatapoolRecord);
        iDatapoolVariable.setData(TAG_EQUIVALENCE_CLASS, (Object)iDatapoolEquivalenceClass);
        this.repopulateRowLabels(n);
        if (this.table.getItemCount() == 1) {
            this.createCursor();
        }
        if (this.cursor != null && !this.cursor.isDisposed() && this.table != null) {
            this.table.setSelection(n5);
            this.cursor.setSelection(n5, 0);
            this.cursor.setFocus();
            this.resizeScrollBars();
            this.setScrollBars();
        }
        this.datapoolPart.markDirty();
    }

    public void recordRemoved(IDatapool iDatapool, int n, int n2) {
        int n3 = this.findRowIndex(n, n2);
        this.table.remove(n3);
        this.repopulateRowLabels(n);
        this.datapoolPart.markDirty();
        if (this.cursor != null && !this.cursor.isDisposed() && this.table != null) {
            int n4 = this.table.getItemCount();
            if (n4 == 0) {
                this.table.deselectAll();
                this.cursor.dispose();
                return;
            }
            if (n4 > n3) {
                this.table.setSelection(n3);
                this.cursor.setSelection(n3, 0);
                this.resizeScrollBars();
                this.setScrollBars();
                return;
            }
            if (n4 > n3 - 1) {
                this.table.setSelection(n3 - 1);
                this.cursor.setSelection(n3 - 1, 0);
                this.resizeScrollBars();
                this.setScrollBars();
            }
        }
    }

    public void recordMoved(IDatapool iDatapool, int n, int n2, int n3) {
        int n4 = this.findRowIndex(n, n2);
        int n5 = this.findRowIndex(n, n3);
        this.tableUtil.moveRow(n4, n5);
        this.repopulateRowLabels(n);
        this.datapoolPart.markDirty();
    }

    public void cellChanged(IDatapool iDatapool, int n, int n2, int n3) {
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)iDatapool.getEquivalenceClass(n);
        org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)iDatapoolEquivalenceClass.getRecord(n2);
        IDatapoolVariable iDatapoolVariable = (IDatapoolVariable)iDatapool.getVariable(n3);
        IDatapoolCell iDatapoolCell = null;
        int n4 = 0;
        while (n4 < iDatapoolRecord.getCellCount()) {
            iDatapoolCell = (IDatapoolCell)iDatapoolRecord.getCell(n4);
            if (iDatapoolCell.getCellVariable().equals(iDatapoolVariable)) break;
            iDatapoolCell = null;
            ++n4;
        }
        if (iDatapoolCell != null) {
            String string = iDatapoolCell.getStringValue();
            int n5 = this.findRowIndex(n, n2);
            TableItem tableItem = this.table.getItem(n5);
            tableItem.setText(n3 + 1, string);
            this.cursor.setSelection(n5, n + 1);
            this.datapoolPart.markDirty();
        }
        this.datapoolPart.markDirty();
    }

    public void equivalenceClassReordered(IDatapool iDatapool, int n) {
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)iDatapool.getEquivalenceClass(n);
        int n2 = 0;
        while (n2 < iDatapoolEquivalenceClass.getRecordCount()) {
            org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)iDatapoolEquivalenceClass.getRecord(n2);
            int n3 = this.findRowIndex(n, n2);
            int n4 = this.findRowIndex(n, iDatapoolRecord);
            this.tableUtil.swapRow(n4, n3);
            ++n2;
        }
        this.datapoolPart.markDirty();
    }

    public void recordChanged(IDatapool iDatapool, int n, int n2) {
    }

    public void save(IDatapool iDatapool) {
        this.alreadySaved = true;
    }

    private int findRowIndex(int n, org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord) {
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(n);
        int n2 = this.findRowIndex(n, 0);
        int n3 = 0;
        while (n3 < iDatapoolEquivalenceClass.getRecordCount()) {
            org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord2 = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)this.table.getItem(n2 + n3).getData(TAG_RECORD);
            if (iDatapoolRecord2.equals(iDatapoolRecord)) {
                return n2 + n3;
            }
            ++n3;
        }
        return -1;
    }

    private int findRowIndex(int n, int n2) {
        int n3 = n2;
        int n4 = 0;
        while (n4 < n) {
            IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(n4);
            n3 += iDatapoolEquivalenceClass.getRecordCount();
            ++n4;
        }
        return n3;
    }

    private void repopulateRowLabels(int n) {
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(n);
        String string = iDatapoolEquivalenceClass.getName();
        int n2 = this.findRowIndex(n, 0);
        int n3 = 0;
        while (n3 < iDatapoolEquivalenceClass.getRecordCount()) {
            if (this.table.getItemCount() > n2 + 1) {
                TableItem tableItem = this.table.getItem(n2 + n3);
                if (this.showEquivlenceClasses) {
                    tableItem.setText(0, string + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + String.valueOf(n3));
                } else {
                    tableItem.setText(0, String.valueOf(n3));
                }
            }
            ++n3;
        }
    }

    private int getRecordIndex(IDatapoolEquivalenceClass iDatapoolEquivalenceClass, org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord) {
        int n = 0;
        while (n < iDatapoolEquivalenceClass.getRecordCount()) {
            IDatapoolRecord iDatapoolRecord2 = iDatapoolEquivalenceClass.getRecord(n);
            if (iDatapoolRecord2.equals(iDatapoolRecord)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private Object[] createCells(IDatapool iDatapool) {
        Object[] objectArray = new Object[iDatapool.getVariableCount()];
        int n = 0;
        while (n < iDatapool.getVariableCount()) {
            objectArray[n] = new String();
            ++n;
        }
        return objectArray;
    }

    private void setVendorConfiguration() {
        block5: {
            if (this.vendorID == null) {
                return;
            }
            IExtensionPoint iExtensionPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.hyades.test.ui.datapool.vendorConfigurationExtension");
            if (iExtensionPoint == null) break block5;
            try {
                IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
                int n = 0;
                while (n < iConfigurationElementArray.length) {
                    String string = iConfigurationElementArray[n].getAttribute("vendorID");
                    if (this.vendorID.equals(string)) {
                        String string2 = iConfigurationElementArray[n].getAttribute("showEquivalenceClassCommands");
                        Boolean bl = Boolean.valueOf(string2);
                        this.showEquivlenceClasses = bl;
                        String string3 = iConfigurationElementArray[n].getAttribute("showVariableCommands");
                        Boolean bl2 = Boolean.valueOf(string3);
                        this.showVariables = bl2;
                        String string4 = iConfigurationElementArray[n].getAttribute("showRecordCommands");
                        Boolean bl3 = Boolean.valueOf(string4);
                        this.showRecords = bl2;
                    }
                    ++n;
                }
            }
            catch (Exception exception) {}
        }
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    private void setVariableType(IDatapoolSuggestedType iDatapoolSuggestedType, String string) {
        if (iDatapoolSuggestedType == null) {
            return;
        }
        if (TypeChecker.getInstance().isBoolean(string)) {
            iDatapoolSuggestedType.setSuggestedType(2);
        } else if (TypeChecker.getInstance().isNumber(string)) {
            iDatapoolSuggestedType.setSuggestedType(1);
        } else if (TypeChecker.getInstance().isString(string)) {
            iDatapoolSuggestedType.setSuggestedType(0);
        } else if (TypeChecker.getInstance().isEnumeration(string)) {
            iDatapoolSuggestedType.setSuggestedType(3);
        } else {
            iDatapoolSuggestedType.setSuggestedType(4);
        }
        iDatapoolSuggestedType.setSuggestedClassName(string);
    }

    public void save() {
        this.datapoolFactory.save(this.datapool);
        this.alreadySaved = true;
    }

    public void dispose() {
        this.clearCellEditor(this.cellEditor);
        if (!this.cursor.isDisposed()) {
            this.cursor.dispose();
        }
        if (!this.contextMenu.isDisposed()) {
            this.contextMenu.dispose();
        }
        if (!this.table.isDisposed()) {
            this.table.dispose();
        }
        if (this.viewer != null) {
            this.viewer = null;
        }
        this.datapool = null;
        this.tableUtil = null;
        this.datapoolPart = null;
        this.datapoolFactory = null;
        this.vendorID = null;
        this.controlEditor = null;
        this.focusListener = null;
        this.cellEditorListener = null;
    }

    public IDatapool getDatapool() {
        return this.datapool;
    }

    public void cut() {
        DatapoolClipboard.getInstance().clear();
        int n = -1;
        if (this.cursor != null && !this.cursor.isDisposed()) {
            n = this.cursor.getColumn();
        }
        if (n == -1) {
            return;
        }
        if (n == 0) {
            this.cutRecords();
        } else {
            this.cutCell();
        }
    }

    public void copy() {
        DatapoolClipboard.getInstance().clear();
        int n = -1;
        if (this.cursor != null && !this.cursor.isDisposed()) {
            n = this.cursor.getColumn();
        }
        if (n == -1) {
            return;
        }
        if (n == 0) {
            this.copyRecords();
        } else {
            this.copyCell();
        }
    }

    public void paste() {
        int n = -1;
        if (this.cursor != null && !this.cursor.isDisposed()) {
            n = this.cursor.getColumn();
        }
        if (n == -1) {
            return;
        }
        if (n == 0) {
            this.pasteRecords();
        } else {
            this.pasteCell();
        }
    }

    private void cutRecords() {
        TableItem[] tableItemArray = this.table.getSelection();
        if (tableItemArray == null || this.table.getSelectionCount() == 0) {
            return;
        }
        int n = 0;
        while (n < tableItemArray.length) {
            this.cutRecord(tableItemArray[n]);
            ++n;
        }
        DatapoolClipboard.getInstance().update();
    }

    private void cutRecord(TableItem tableItem) {
        this.copyRecord(tableItem);
        this.clearRecord(tableItem);
    }

    private void clearRecord(TableItem tableItem) {
        org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)tableItem.getData(TAG_RECORD);
        if (iDatapoolRecord == null || iDatapoolRecord.getCellCount() == 0) {
            return;
        }
        int n = iDatapoolRecord.getCellCount();
        int n2 = 0;
        while (n2 < n) {
            IDatapoolCell iDatapoolCell = (IDatapoolCell)iDatapoolRecord.getCell(n2);
            iDatapoolCell.setCellValue(null);
            tableItem.setText(n2 + 1, new String());
            ++n2;
        }
        this.datapoolPart.markDirty();
    }

    private void cutCell() {
        this.copyCell();
        this.clearCell();
    }

    private void copyRecords() {
        TableItem[] tableItemArray = this.table.getSelection();
        if (tableItemArray == null || this.table.getSelectionCount() == 0) {
            return;
        }
        int n = 0;
        while (n < tableItemArray.length) {
            this.copyRecord(tableItemArray[n]);
            ++n;
        }
        DatapoolClipboard.getInstance().update();
    }

    private void copyRecord(TableItem tableItem) {
        org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)tableItem.getData(TAG_RECORD);
        if (iDatapoolRecord == null || iDatapoolRecord.getCellCount() == 0) {
            return;
        }
        DatapoolClipboard.getInstance().addRecordData(iDatapoolRecord);
    }

    private void copyCell() {
        int n = -1;
        TableItem tableItem = null;
        int n2 = -1;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        n2 = this.cursor.getColumn();
        tableItem = this.cursor.getRow();
        if (tableItem != null) {
            n = this.table.indexOf(tableItem);
        }
        if (n2 == -1 || n == -1 || tableItem == null) {
            return;
        }
        org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)tableItem.getData(TAG_RECORD);
        IDatapoolCell iDatapoolCell = (IDatapoolCell)iDatapoolRecord.getCell(n2 - 1);
        DatapoolClipboard.getInstance().addCellData(iDatapoolCell);
        DatapoolClipboard.getInstance().update();
    }

    private void pasteRecords() {
        Object[] objectArray = new Object[]{DatapoolPlugin.getResourceString("DATA_PASTE_OVERWRITE")};
        String string = MessageFormat.format("{0}", objectArray);
        MessageDialog messageDialog = new MessageDialog(this.parent.getShell(), DatapoolPlugin.getResourceString("PASTE_TEXT"), null, string, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        if (messageDialog.open() != 0) {
            return;
        }
        TableItem[] tableItemArray = this.table.getSelection();
        if (tableItemArray == null || this.table.getSelectionCount() == 0) {
            return;
        }
        TableItem tableItem = tableItemArray[0];
        int n = this.table.indexOf(tableItem);
        Object[] objectArray2 = DatapoolClipboard.getInstance().getRecordDataSet();
        if (objectArray2 == null || objectArray2.length == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < objectArray2.length) {
            Object[] objectArray3;
            if (n + n2 < this.table.getItemCount() && (objectArray3 = (Object[])objectArray2[n2]) != null) {
                TableItem tableItem2 = this.table.getItem(n + n2);
                org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)tableItem2.getData(TAG_RECORD);
                int n3 = 0;
                while (n3 < objectArray3.length) {
                    if (n3 <= iDatapoolRecord.getCellCount()) {
                        IDatapoolCell iDatapoolCell = (IDatapoolCell)iDatapoolRecord.getCell(n3);
                        iDatapoolCell.setCellValue(objectArray3[n3]);
                        tableItem2.setText(n3 + 1, iDatapoolCell.getStringValue());
                        this.datapoolPart.markDirty();
                    }
                    ++n3;
                }
            }
            ++n2;
        }
    }

    private void pasteCell() {
        int n = -1;
        TableItem tableItem = null;
        int n2 = -1;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        n2 = this.cursor.getColumn();
        tableItem = this.cursor.getRow();
        if (tableItem != null) {
            n = this.table.indexOf(tableItem);
        }
        if (n2 == -1 || n == -1 || tableItem == null) {
            return;
        }
        org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)tableItem.getData(TAG_RECORD);
        IDatapoolCell iDatapoolCell = (IDatapoolCell)iDatapoolRecord.getCell(n2 - 1);
        Object object = DatapoolClipboard.getInstance().getCellData();
        iDatapoolCell.setCellValue(object);
        tableItem.setText(n2, iDatapoolCell.getStringValue());
        this.datapoolPart.markDirty();
        this.cursor.redraw();
    }

    public IDatapoolPart getIDatapoolPart() {
        return this.datapoolPart;
    }

    public void refresh() {
        this.refresh(this.datapool);
    }

    public void refresh(IDatapool iDatapool) {
        if (iDatapool == null) {
            return;
        }
        this.datapool = iDatapool;
        iDatapool.addDatapoolListener((IDatapoolListener)this);
        this.refreshColumns();
        this.refreshRows();
    }

    private void refreshColumns() {
        int n;
        int n2 = this.datapool.getVariableCount();
        int n3 = this.tableUtil.getColumnCount() - 1;
        if (this.cursor != null && !this.cursor.isDisposed()) {
            n = this.cursor.getColumn();
            TableItem tableItem = this.cursor.getRow();
            if (n > n2) {
                this.cursor.setSelection(tableItem, n2);
            } else {
                this.cursor.setSelection(tableItem, n);
            }
        }
        if (n3 > n2) {
            n = n3 - n2;
            int n4 = 0;
            while (n4 < n) {
                this.tableUtil.deleteColumn(n2 + 1);
                ++n4;
            }
        }
        n = 0;
        while (n < this.datapool.getVariableCount()) {
            int n5 = n + 1;
            TableColumn tableColumn = null;
            if (n5 < this.tableUtil.getColumnCount()) {
                tableColumn = this.table.getColumn(n5);
            } else {
                tableColumn = new TableColumn(this.table, 0, n5);
                tableColumn.setWidth(100);
                tableColumn.addSelectionListener(this.headerListener);
                tableColumn.addControlListener(this.resizeColumnListener);
            }
            IDatapoolVariable iDatapoolVariable = (IDatapoolVariable)this.datapool.getVariable(n);
            tableColumn.setResizable(true);
            IDatapoolSuggestedType iDatapoolSuggestedType = (IDatapoolSuggestedType)iDatapoolVariable.getSuggestedType();
            String string = new String();
            if (iDatapoolSuggestedType != null) {
                // empty if block
            }
            string = iDatapoolSuggestedType.getSuggestedClassName();
            tableColumn.setText(iDatapoolVariable.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + string);
            tableColumn.setData(TAG_VARIABLE, (Object)iDatapoolVariable);
            tableColumn.setData(TAG_VARIABLE_INDEX, (Object)new Integer(n));
            ++n;
        }
    }

    private void refreshRows() {
        int n;
        TableItem tableItem;
        int n2;
        int n3 = this.table.getItemCount();
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.datapool.getEquivalenceClassCount()) {
            IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(n5);
            n2 = 0;
            while (n2 < iDatapoolEquivalenceClass.getRecordCount()) {
                IDatapoolCell iDatapoolCell;
                tableItem = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)iDatapoolEquivalenceClass.getRecord(n2);
                n = tableItem.getCellCount();
                String[] stringArray = new String[this.datapool.getVariableCount() + 1];
                IDatapoolCell[] iDatapoolCellArray = new IDatapoolCell[this.datapool.getVariableCount()];
                stringArray[0] = this.showEquivlenceClasses ? iDatapoolEquivalenceClass.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + String.valueOf(n2) : String.valueOf(n2);
                int n6 = 0;
                while (n6 < n) {
                    iDatapoolCell = (IDatapoolCell)tableItem.getCell(n6);
                    IDatapoolVariable iDatapoolVariable = (IDatapoolVariable)iDatapoolCell.getCellVariable();
                    int n7 = this.findColumnIndex(iDatapoolVariable.getName());
                    String string = new String();
                    if (iDatapoolCell.getStringValue() != null) {
                        string = iDatapoolCell.getStringValue();
                    }
                    stringArray[n7] = string;
                    iDatapoolCellArray[n7 - 1] = iDatapoolCell;
                    ++n6;
                }
                iDatapoolCell = null;
                iDatapoolCell = n4 < this.table.getItemCount() ? this.table.getItem(n4) : new TableItem(this.table, 0);
                iDatapoolCell.setText(stringArray);
                iDatapoolCell.setData(TAG_DATA, (Object)iDatapoolCellArray);
                iDatapoolCell.setData(TAG_RECORD, (Object)tableItem);
                iDatapoolCell.setData(TAG_EQUIVALENCE_CLASS, (Object)iDatapoolEquivalenceClass);
                ++n4;
                ++n2;
            }
            ++n5;
        }
        int n8 = n4;
        if (this.cursor != null && !this.cursor.isDisposed()) {
            n2 = this.cursor.getColumn();
            tableItem = this.cursor.getRow();
            n = this.table.indexOf(tableItem);
            if (n > n8 - 1) {
                this.table.setSelection(n8 - 1);
                this.cursor.setSelection(n8 - 1, n2);
            } else {
                this.cursor.setSelection(n, n2);
            }
        }
        if (n3 > n8) {
            n2 = n3 - n8;
            int n9 = 0;
            while (n9 < n2) {
                this.table.remove(n8);
                ++n9;
            }
        }
    }

    class TableMouseAdapter
    implements MouseListener {
        TableMouseAdapter() {
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
            if (mouseEvent.button == 3 && DatapoolTable.this.contextMenu.isDisposed()) {
                DatapoolTable.this.createMenu();
                DatapoolTable.this.contextMenu.setEnabled(true);
                DatapoolTable.this.contextMenu.setVisible(true);
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
        }
    }

    class CursorSelectionAdapter
    implements SelectionListener {
        private CellEditor editor = null;
        private TableCursor cursor = null;
        private IDatapoolPart datapoolPart = null;

        public CursorSelectionAdapter(TableCursor tableCursor, CellEditor cellEditor, IDatapoolPart iDatapoolPart) {
            this.editor = cellEditor;
            this.cursor = tableCursor;
            this.datapoolPart = iDatapoolPart;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (this.datapoolPart.isReadOnly()) {
                return;
            }
            DatapoolTable.this.clearCellEditor();
            if (!DatapoolTable.this.isInputValid) {
                return;
            }
            DatapoolTable.this.table.setSelection(new TableItem[]{this.cursor.getRow()});
            DatapoolTable.this.setScrollBars();
            if (DatapoolTable.this.datapoolMenuManager != null) {
                DatapoolTable.this.setMenuMode(DatapoolTable.this.datapoolMenuManager);
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            Object object;
            Object object2;
            this.datapoolPart.notifyEdit();
            if (this.datapoolPart.isReadOnly()) {
                return;
            }
            TableItem tableItem = this.cursor.getRow();
            int n = this.cursor.getColumn();
            TableColumn tableColumn = DatapoolTable.this.table.getColumn(n);
            if (n == 0) {
                if (DatapoolTable.this.controlKeyDown) {
                    DatapoolTable.this.editRowGroupAux(tableItem);
                    DatapoolTable.this.controlKeyDown = false;
                } else {
                    DatapoolTable.this.editRowAux(tableItem);
                }
                return;
            }
            if (DatapoolTable.this.controlKeyDown) {
                DatapoolTable.this.editColumnAux(tableColumn);
                DatapoolTable.this.controlKeyDown = false;
                return;
            }
            IDatapoolCell[] iDatapoolCellArray = (IDatapoolCell[])tableItem.getData(DatapoolTable.TAG_DATA);
            IDatapoolCell iDatapoolCell = iDatapoolCellArray[n - 1];
            Object object3 = iDatapoolCell.getCellValue();
            if (object3 == null) {
                object2 = (IDatapoolVariable)iDatapoolCell.getCellVariable();
                object = (IDatapoolSuggestedType)object2.getSuggestedType();
                String string = object.getSuggestedClassName();
                if (string == null || string.length() == 0) {
                    object3 = new String();
                } else {
                    IValueClassFactory iValueClassFactory = ValueClassMap.getValueClassFactory(string);
                    if (iValueClassFactory != null) {
                        object3 = iValueClassFactory.createEmptyObject();
                    } else {
                        try {
                            Class<?> clazz = Class.forName(string);
                            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                            object3 = constructor.newInstance(new Object[0]);
                        }
                        catch (Exception exception) {
                            object3 = new String();
                        }
                    }
                }
            }
            object2 = new ValueObject(object3);
            DatapoolTable.this.cellEditor = (CellEditor)((ValueObject)object2).getPropertyDisplay((Composite)this.cursor);
            object = iDatapoolCell.getStringValue();
            DatapoolTable.this.cellEditor.getControl().addKeyListener((KeyListener)new TableCellKeyAdapter(DatapoolTable.this.cellEditor, tableItem, n));
            DatapoolTable.this.cellEditor.addListener((ICellEditorListener)new TableCellEditorAdapter(DatapoolTable.this.cellEditor, tableItem, n));
            DatapoolTable.this.controlEditor.setEditor(DatapoolTable.this.cellEditor.getControl());
            DatapoolTable.this.cellEditor.setValidator((ICellEditorValidator)new TableCellValidator(ValueClassMap.getValueValidatorClass(object3)));
            DatapoolTable.this.cellEditor.setFocus();
        }
    }

    class CursorMouseAdapter
    implements MouseListener {
        private CellEditor editor = null;
        private TableCursor cursor = null;
        private IDatapoolPart datapoolPart = null;

        public CursorMouseAdapter(TableCursor tableCursor, CellEditor cellEditor, IDatapoolPart iDatapoolPart) {
            this.editor = cellEditor;
            this.cursor = tableCursor;
            this.datapoolPart = iDatapoolPart;
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            Object object;
            Object object2;
            this.datapoolPart.notifyEdit();
            if (this.datapoolPart.isReadOnly()) {
                return;
            }
            TableItem tableItem = this.cursor.getRow();
            int n = this.cursor.getColumn();
            if (n == 0) {
                DatapoolTable.this.editRowAux(tableItem);
                return;
            }
            IDatapoolCell[] iDatapoolCellArray = (IDatapoolCell[])tableItem.getData(DatapoolTable.TAG_DATA);
            IDatapoolCell iDatapoolCell = iDatapoolCellArray[n - 1];
            Object object3 = iDatapoolCell.getCellValue();
            if (object3 == null) {
                object2 = (IDatapoolVariable)iDatapoolCell.getCellVariable();
                object = (IDatapoolSuggestedType)object2.getSuggestedType();
                String string = object.getSuggestedClassName();
                if (string == null || string.length() == 0) {
                    object3 = new String();
                } else {
                    IValueClassFactory iValueClassFactory = ValueClassMap.getValueClassFactory(string);
                    if (iValueClassFactory != null) {
                        object3 = iValueClassFactory.createEmptyObject();
                    } else {
                        try {
                            Class<?> clazz = Class.forName(string);
                            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                            object3 = constructor.newInstance(new Object[0]);
                        }
                        catch (Exception exception) {
                            object3 = new String();
                        }
                    }
                }
            }
            object2 = new ValueObject(object3);
            DatapoolTable.this.cellEditor = (CellEditor)((ValueObject)object2).getPropertyDisplay((Composite)this.cursor);
            if (DatapoolTable.this.cellEditor != null) {
                DatapoolTable.this.cellEditor.getControl().addKeyListener((KeyListener)new TableCellKeyAdapter(DatapoolTable.this.cellEditor, tableItem, n));
                DatapoolTable.this.cellEditor.getControl().addPaintListener((PaintListener)new TableCellPaintAdapter());
                DatapoolTable.this.cellEditor.addListener((ICellEditorListener)new TableCellEditorAdapter(DatapoolTable.this.cellEditor, tableItem, n));
                DatapoolTable.this.controlEditor.setEditor(DatapoolTable.this.cellEditor.getControl());
                DatapoolTable.this.cellEditor.setValidator((ICellEditorValidator)new TableCellValidator(ValueClassMap.getValueValidatorClass(object3)));
                DatapoolTable.this.cellEditor.setFocus();
                if (DatapoolTable.this.cellEditor instanceof TextCellEditor) {
                    object = tableItem.getText(n);
                    ((Text)DatapoolTable.this.cellEditor.getControl()).setSelection(((String)object).length());
                }
            }
        }

        public void mouseDown(MouseEvent mouseEvent) {
            if (mouseEvent.button == 3) {
                DatapoolTable.this.contextMenu.setEnabled(true);
                DatapoolTable.this.contextMenu.setVisible(true);
            }
            if (mouseEvent.button != 1) {
                return;
            }
            DatapoolTable.this.clearCellEditor();
        }

        public void mouseUp(MouseEvent mouseEvent) {
        }
    }

    class CursorKeyAdapter
    implements KeyListener {
        private CellEditor editor = null;
        private TableCursor cursor = null;
        private IDatapoolPart datapoolPart = null;

        public CursorKeyAdapter(TableCursor tableCursor, CellEditor cellEditor, IDatapoolPart iDatapoolPart) {
            this.editor = cellEditor;
            this.cursor = tableCursor;
            this.datapoolPart = iDatapoolPart;
        }

        public void keyPressed(KeyEvent keyEvent) {
            Object object;
            Object object2;
            if (keyEvent.keyCode == 0x1000013 && (keyEvent.stateMask & 0x40000) != 0 && (keyEvent.stateMask & 0x20000) != 0) {
                if (DatapoolTable.this.contextMenu == null || DatapoolTable.this.contextMenu.isDisposed()) {
                    DatapoolTable.this.createMenu();
                }
                DatapoolTable.this.contextMenu.setEnabled(true);
                DatapoolTable.this.contextMenu.setVisible(true);
                return;
            }
            if (keyEvent.keyCode == 65536) {
                DatapoolTable.this.altKeyDown = true;
            }
            if (keyEvent.keyCode == 262144) {
                DatapoolTable.this.controlKeyDown = true;
            }
            int n = this.cursor.getColumn();
            TableItem tableItem = this.cursor.getRow();
            if (keyEvent.keyCode == 99 && (keyEvent.stateMask & 0x40000) != 0) {
                DatapoolTable.this.copy();
                return;
            }
            if (keyEvent.keyCode == 27 || keyEvent.keyCode == 13 || keyEvent.keyCode == 65536 || keyEvent.keyCode == 0x1000006 || keyEvent.keyCode == 0x1000005 || keyEvent.keyCode == 0x1000007 || keyEvent.keyCode == 0x1000008 || keyEvent.keyCode == 262144 || keyEvent.keyCode == 131072 || keyEvent.keyCode == 0x100000A || keyEvent.keyCode >= 0x100000C && keyEvent.keyCode <= 0x1000015 || keyEvent.keyCode == 121) {
                return;
            }
            if (keyEvent.keyCode == 0x1000002 || keyEvent.keyCode == 0x1000001 || keyEvent.keyCode == 0x1000003 || keyEvent.keyCode == 0x1000004) {
                int n2;
                if (!DatapoolTable.this.isInputValid) {
                    return;
                }
                DatapoolTable.this.clearCellEditor();
                int n3 = DatapoolTable.this.table.indexOf(tableItem);
                if (keyEvent.keyCode == 0x1000002) {
                    n2 = DatapoolTable.this.table.getItemCount();
                    if (n3 < n2) {
                        DatapoolTable.this.table.setSelection(n3);
                    }
                    DatapoolTable.this.setScrollBars();
                }
                if (keyEvent.keyCode == 0x1000001) {
                    if (n3 >= 0) {
                        DatapoolTable.this.table.setSelection(n3);
                    }
                    DatapoolTable.this.setScrollBars();
                }
                if (keyEvent.keyCode == 0x1000004 && n > (n2 = DatapoolTable.this.tableUtil.getColumnCount()) - 1) {
                    this.cursor.setSelection(n3, n - 1);
                }
                return;
            }
            this.datapoolPart.notifyEdit();
            if (this.datapoolPart.isReadOnly()) {
                return;
            }
            if (keyEvent.keyCode == 0x1000009 && (keyEvent.stateMask & 0x40000) != 0) {
                if (n == 0) {
                    DatapoolTable.this.insertRowGroup();
                }
                if (n > 0) {
                    DatapoolTable.this.insertColumn();
                }
                return;
            }
            if (keyEvent.keyCode == 127 && (keyEvent.stateMask & 0x40000) != 0) {
                if (n == 0) {
                    DatapoolTable.this.deleteRowGroup();
                }
                if (n > 0) {
                    DatapoolTable.this.deleteColumn();
                }
                return;
            }
            if (keyEvent.keyCode == 120 && (keyEvent.stateMask & 0x40000) != 0) {
                DatapoolTable.this.cut();
                return;
            }
            if (keyEvent.keyCode == 118 && (keyEvent.stateMask & 0x40000) != 0) {
                DatapoolTable.this.paste();
                return;
            }
            if ((keyEvent.stateMask & 0x40000) != 0 || (keyEvent.stateMask & 0x10000) != 0) {
                return;
            }
            if (keyEvent.keyCode == 0x1000009) {
                if (n == 0) {
                    DatapoolTable.this.insertRow();
                }
                if (n <= 0) {
                    return;
                }
            }
            if (keyEvent.keyCode == 127) {
                if (n == 0) {
                    DatapoolTable.this.deleteRow();
                }
                if (n > 0) {
                    DatapoolTable.this.clearCell();
                }
                return;
            }
            char c = keyEvent.character;
            if (n == 0) {
                DatapoolTable.this.editRowAux(tableItem);
                return;
            }
            IDatapoolCell[] iDatapoolCellArray = (IDatapoolCell[])tableItem.getData(DatapoolTable.TAG_DATA);
            IDatapoolCell iDatapoolCell = iDatapoolCellArray[n - 1];
            Object object3 = iDatapoolCell.getCellValue();
            if (object3 == null) {
                object2 = (IDatapoolVariable)iDatapoolCell.getCellVariable();
                object = (IDatapoolSuggestedType)object2.getSuggestedType();
                String string = object.getSuggestedClassName();
                if (string == null || string.length() == 0) {
                    object3 = new String();
                } else {
                    IValueClassFactory iValueClassFactory = ValueClassMap.getValueClassFactory(string);
                    if (iValueClassFactory != null) {
                        object3 = iValueClassFactory.createEmptyObject();
                    } else {
                        try {
                            Class<?> clazz = Class.forName(string);
                            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                            object3 = constructor.newInstance(new Object[0]);
                        }
                        catch (Exception exception) {
                            object3 = new String();
                        }
                    }
                }
            }
            object2 = new ValueObject(object3);
            DatapoolTable.this.cellEditor = (CellEditor)((ValueObject)object2).getPropertyDisplay((Composite)this.cursor);
            if (DatapoolTable.this.cellEditor != null) {
                DatapoolTable.this.cellEditor.getControl().addKeyListener((KeyListener)new TableCellKeyAdapter(DatapoolTable.this.cellEditor, tableItem, n));
                DatapoolTable.this.cellEditor.getControl().addPaintListener((PaintListener)new TableCellPaintAdapter());
                DatapoolTable.this.cellEditor.addListener((ICellEditorListener)new TableCellEditorAdapter(DatapoolTable.this.cellEditor, tableItem, n));
                DatapoolTable.this.controlEditor.setEditor(DatapoolTable.this.cellEditor.getControl());
                DatapoolTable.this.cellEditor.setValidator((ICellEditorValidator)new TableCellValidator(ValueClassMap.getValueValidatorClass(object3)));
                DatapoolTable.this.cellEditor.setFocus();
                if (DatapoolTable.this.cellEditor instanceof TextCellEditor) {
                    if (keyEvent.keyCode == 8) {
                        DatapoolTable.this.cellEditor.setValue((Object)new String());
                    } else if (keyEvent.keyCode == 0x100000B) {
                        object = tableItem.getText(n);
                        DatapoolTable.this.cellEditor.setValue(object3);
                        ((Text)DatapoolTable.this.cellEditor.getControl()).setSelection(((String)object).length());
                        DatapoolTable.this.isF2Mode = true;
                    } else {
                        object = String.valueOf(c);
                        if (DatapoolTable.this.cellEditor.getValidator() != null && DatapoolTable.this.cellEditor.getValidator().isValid(object) != null) {
                            DatapoolTable.this.isInputValid = false;
                        }
                        DatapoolTable.this.cellEditor.setValue(object);
                        ((Text)DatapoolTable.this.cellEditor.getControl()).setSelection(2);
                    }
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.keyCode == 262144) {
                DatapoolTable.this.controlKeyDown = false;
                return;
            }
            if (DatapoolTable.this.altKeyDown) {
                DatapoolTable.this.altKeyDown = false;
                return;
            }
        }
    }

    class TableCellValidator
    implements ICellEditorValidator {
        IValidateValueClass validator = null;

        public TableCellValidator(IValidateValueClass iValidateValueClass) {
            this.validator = iValidateValueClass;
        }

        public String isValid(Object object) {
            if (this.validator == null) {
                return null;
            }
            if (this.validator.checkValue(object)) {
                return null;
            }
            Error error = this.validator.getError();
            if (error != null) {
                return error.toString();
            }
            return "Error";
        }
    }

    class TableCellKeyAdapter
    implements KeyListener {
        private CellEditor editor = null;
        private TableItem row = null;
        private int rowIndex = -1;
        private int column = -1;

        public TableCellKeyAdapter(CellEditor cellEditor, TableItem tableItem, int n) {
            this.editor = cellEditor;
            this.row = tableItem;
            this.column = n;
            if (tableItem != null) {
                this.rowIndex = DatapoolTable.this.table.indexOf(tableItem);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.character == '\r') {
                if (!DatapoolTable.this.isInputValid) {
                    keyEvent.doit = false;
                    return;
                }
                return;
            }
            if (keyEvent.keyCode == 0x1000013 && (keyEvent.stateMask & 0x40000) != 0 && (keyEvent.stateMask & 0x20000) != 0) {
                if (DatapoolTable.this.contextMenu == null || DatapoolTable.this.contextMenu.isDisposed()) {
                    DatapoolTable.this.createMenu();
                }
                DatapoolTable.this.contextMenu.setEnabled(true);
                DatapoolTable.this.contextMenu.setVisible(true);
                return;
            }
            if (!(DatapoolTable.this.isF2Mode || keyEvent.keyCode != 0x1000002 && keyEvent.keyCode != 0x1000001 && keyEvent.keyCode != 0x1000003 && keyEvent.keyCode != 0x1000004)) {
                if (!DatapoolTable.this.isInputValid) {
                    keyEvent.doit = false;
                    return;
                }
                if (this.editor != null) {
                    if (this.editor.getValue() != null) {
                        this.row.setText(this.column, this.editor.getValue().toString());
                        DatapoolTable.this.applyEditingValue(this.editor.getValue(), true);
                    }
                    DatapoolTable.this.clearCellEditor(this.editor);
                }
                if (DatapoolTable.this.cursor != null && !DatapoolTable.this.cursor.isDisposed()) {
                    if (keyEvent.keyCode == 0x1000002 && this.rowIndex + 1 < DatapoolTable.this.table.getItemCount()) {
                        DatapoolTable.this.cursor.setSelection(this.rowIndex + 1, this.column);
                        DatapoolTable.this.table.setSelection(this.rowIndex + 1);
                        DatapoolTable.this.setScrollBars();
                    }
                    if (keyEvent.keyCode == 0x1000001 && this.rowIndex > 0) {
                        DatapoolTable.this.cursor.setSelection(this.rowIndex - 1, this.column);
                        DatapoolTable.this.table.setSelection(this.rowIndex - 1);
                        DatapoolTable.this.setScrollBars();
                    }
                    if (keyEvent.keyCode == 0x1000004 && this.column + 1 < DatapoolTable.this.table.getColumnCount()) {
                        DatapoolTable.this.cursor.setSelection(this.rowIndex, this.column + 1);
                        DatapoolTable.this.setScrollBars();
                    }
                    if (keyEvent.keyCode == 0x1000003 && this.column > 0) {
                        DatapoolTable.this.cursor.setSelection(this.rowIndex, this.column - 1);
                        DatapoolTable.this.setScrollBars();
                    }
                }
                return;
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.character == '\u001b') {
                DatapoolTable.this.clearCellEditor(this.editor);
                return;
            }
            if (!(keyEvent.keyCode != 0x1000002 && keyEvent.keyCode != 0x1000001 && keyEvent.keyCode != 0x1000003 && keyEvent.keyCode != 0x1000004 || DatapoolTable.this.isInputValid)) {
                keyEvent.doit = false;
                return;
            }
        }
    }

    class TableCellPaintAdapter
    implements PaintListener {
        TableCellPaintAdapter() {
        }

        public void paintControl(PaintEvent paintEvent) {
            if (!DatapoolTable.this.isInputValid) {
                this.drawPolyline(paintEvent.gc, (Widget)paintEvent.getSource());
            } else {
                paintEvent.gc.drawPolyline(new int[0]);
            }
        }

        private void drawPolyline(GC gC, Widget widget) {
            if (gC == null) {
                return;
            }
            Rectangle rectangle = gC.getClipping();
            String string = "";
            if (widget instanceof Text) {
                string = ((Text)widget).getText();
            } else if (widget instanceof CCombo) {
                string = ((CCombo)widget).getText();
            } else if (widget instanceof Combo) {
                string = ((Combo)widget).getText();
            } else {
                return;
            }
            int n = 2;
            int n2 = 0;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                if (!Character.isWhitespace(c)) break;
                n += gC.getAdvanceWidth(c);
                ++n2;
            }
            int n3 = gC.textExtent((String)string.trim()).x;
            Point point = new Point(n, 0);
            Point point2 = new Point(n3 + n + 2, 0);
            gC.setForeground(Display.getCurrent().getSystemColor(3));
            int[] nArray = this.computePolyline(point, point2, rectangle.height);
            gC.drawPolyline(nArray);
        }

        private int[] computePolyline(Point point, Point point2, int n) {
            int n2 = point.x;
            int n3 = (point2.x - point.x) / 4;
            int n4 = (2 * n3 + 1) * 2;
            if (n4 < 0) {
                return new int[0];
            }
            int[] nArray = new int[n4];
            int n5 = point.y + n - 1;
            int n6 = n5 - 2;
            int n7 = 0;
            while (n7 < n3) {
                int n8 = 4 * n7;
                nArray[n8] = n2 + 4 * n7;
                nArray[n8 + 1] = n5;
                nArray[n8 + 2] = nArray[n8] + 2;
                nArray[n8 + 3] = n6;
                ++n7;
            }
            nArray[n4 - 2] = point.x + 4 * n3;
            nArray[n4 - 1] = n5;
            return nArray;
        }
    }

    class TableCellEditorAdapter
    implements ICellEditorListener {
        private CellEditor editor = null;
        private TableItem row = null;
        private int rowIndex = -1;
        private int column = -1;

        public TableCellEditorAdapter(CellEditor cellEditor, TableItem tableItem, int n) {
            this.editor = cellEditor;
            this.row = tableItem;
            this.column = n;
            if (tableItem != null) {
                this.rowIndex = DatapoolTable.this.table.indexOf(tableItem);
            }
        }

        public void applyEditorValue() {
            DatapoolTable.this.isF2Mode = false;
            if (!DatapoolTable.this.isInputValid) {
                return;
            }
            if (this.editor.getValue() != null) {
                this.row.setText(this.column, this.editor.getValue().toString());
                DatapoolTable.this.applyEditingValue(this.editor.getValue(), false);
            }
            DatapoolTable.this.clearCellEditor();
        }

        public void cancelEditor() {
            DatapoolTable.this.isF2Mode = false;
        }

        public void editorValueChanged(boolean bl, boolean bl2) {
            if (!bl2) {
                DatapoolTable.this.isInputValid = false;
            } else {
                DatapoolTable.this.isInputValid = true;
            }
            this.editor.getControl().redraw();
        }
    }
}

