/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.dialog;

import java.text.MessageFormat;
import java.text.NumberFormat;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.test.ui.datapool.DatapoolPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.DatapoolUtil;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class DatapoolRowGroupDialog
extends Dialog
implements KeyListener,
SelectionListener {
    private static final String TAG_EQUIVALENCE_CLASSES = "equivalenceClasses";
    private static final int HEIGHT = 70;
    private static final int WIDTH = 300;
    private Shell shell = null;
    private IDatapool datapool = null;
    private String title = null;
    private boolean insertionMode = false;
    private Table table = null;
    private IDatapoolEquivalenceClass selectedEquivalenceClass = null;
    private IDatapoolEquivalenceClass previousEquivalenceClass = null;
    private Text nameField = null;
    private Color nameFieldForeground = null;
    private Combo equivalenceClassCombo = null;
    private Label errorLabel = null;
    private String name = null;
    private int insertionIndex = -1;
    private int defaultNameCounter = 1;

    public DatapoolRowGroupDialog(Shell shell, IDatapool iDatapool, Table table, IDatapoolEquivalenceClass iDatapoolEquivalenceClass, IDatapoolEquivalenceClass iDatapoolEquivalenceClass2, String string) {
        super(shell);
        this.shell = shell;
        this.datapool = iDatapool;
        this.title = string;
        this.table = table;
        this.previousEquivalenceClass = iDatapoolEquivalenceClass2;
        this.selectedEquivalenceClass = iDatapoolEquivalenceClass;
        if (string.equals(DatapoolPlugin.getResourceString("DATA_ROW_GRP_DLG_TITLE_INS"))) {
            this.insertionMode = true;
        }
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.enableOK();
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        this.getShell().setText(this.title);
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 70;
        gridData.widthHint = 300;
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(DatapoolPlugin.getResourceString("DATA_ROW_GRP_DLG_NAME"));
        this.nameField = new Text(composite2, 2052);
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        this.nameField.setLayoutData((Object)gridData);
        this.nameField.addKeyListener((KeyListener)this);
        if (this.selectedEquivalenceClass != null) {
            this.name = this.selectedEquivalenceClass.getName();
            this.nameField.setText(this.name);
            this.nameField.setSelection(this.name.length() + 1);
        }
        Label label2 = new Label(composite2, 0);
        if (this.insertionMode) {
            label2.setText(DatapoolPlugin.getResourceString("DATA_DLG_INS"));
            this.name = this.createDefaultName();
            while (!DatapoolUtil.getInstance().isEquivalenceClassNameUnique(this.datapool, this.name, null)) {
                this.name = this.createDefaultName();
            }
            this.nameField.setText(this.name);
            this.nameField.setSelection(this.name.length() + 1);
        } else {
            label2.setText(DatapoolPlugin.getResourceString("DATA_DLG_MOVE"));
        }
        this.equivalenceClassCombo = new Combo(composite2, 12);
        IDatapoolEquivalenceClass[] iDatapoolEquivalenceClassArray = null;
        iDatapoolEquivalenceClassArray = DatapoolUtil.getInstance().getEquivalenceClasses(this.datapool, null);
        String[] stringArray = this.getEquivalenceClassLabels(iDatapoolEquivalenceClassArray);
        this.equivalenceClassCombo.setItems(stringArray);
        this.equivalenceClassCombo.setData(TAG_EQUIVALENCE_CLASSES, (Object)iDatapoolEquivalenceClassArray);
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 150;
        this.equivalenceClassCombo.setLayoutData((Object)gridData);
        this.equivalenceClassCombo.addSelectionListener((SelectionListener)this);
        if (this.previousEquivalenceClass != null) {
            int n = this.datapool.getEquivalenceClassIndex(this.previousEquivalenceClass.getName());
            if (n != -1) {
                this.equivalenceClassCombo.select(n + 1);
                this.insertionIndex = n;
            }
        } else {
            this.equivalenceClassCombo.select(0);
            this.insertionIndex = -1;
        }
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        this.errorLabel = new Label(composite2, 0);
        this.errorLabel.setLayoutData((Object)gridData);
        return composite2;
    }

    private boolean enableOK() {
        boolean bl = true;
        String string = new String();
        Display display = Display.getDefault();
        Color color = display.getSystemColor(3);
        String string2 = this.nameField.getText();
        if (string2 == null || string2.length() == 0) {
            this.getButton(0).setEnabled(false);
            return false;
        }
        if (string2 != null && string2.length() > 0) {
            boolean bl2 = DatapoolUtil.getInstance().isEquivalenceClassNameUnique(this.datapool, string2, this.selectedEquivalenceClass);
            boolean bl3 = DatapoolUtil.getInstance().isEquivalenceClassNameValid(string2);
            if (bl2 && bl3) {
                this.nameField.setForeground(this.nameFieldForeground);
            } else {
                this.nameField.setForeground(color);
                if (!bl2) {
                    string = DatapoolPlugin.getResourceString("DATA_ROW_GRP_DLG_ERROR_NAME_NOT_UNIQUE");
                } else if (!bl3) {
                    string = DatapoolPlugin.getResourceString("DATA_ROW_GRP_DLG_ERROR_NAME_NOT_VALID");
                }
                bl = false;
            }
        }
        if (bl) {
            this.getButton(0).setEnabled(true);
            this.errorLabel.setText(new String());
            return true;
        }
        String string3 = DatapoolPlugin.getResourceString("DATA_DLG_ERROR_INDICATOR") + string;
        this.errorLabel.setText(string3);
        this.errorLabel.setForeground(color);
        this.getButton(0).setEnabled(false);
        return false;
    }

    private String[] getEquivalenceClassLabels(IDatapoolEquivalenceClass[] iDatapoolEquivalenceClassArray) {
        int n = 0;
        if (iDatapoolEquivalenceClassArray != null) {
            n = iDatapoolEquivalenceClassArray.length;
        }
        if (iDatapoolEquivalenceClassArray.length == 1 && iDatapoolEquivalenceClassArray[0].getRecordCount() == 0) {
            n = 0;
        }
        String[] stringArray = new String[n + 1];
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray;
            IDatapoolEquivalenceClass iDatapoolEquivalenceClass = iDatapoolEquivalenceClassArray[n2];
            String string = iDatapoolEquivalenceClass.getName();
            if (n2 == 0) {
                objectArray = new Object[]{DatapoolPlugin.getResourceString("DATA_DLG_BEFORE"), string};
                stringArray[n2] = MessageFormat.format("{0} {1}", objectArray);
            }
            objectArray = new Object[]{DatapoolPlugin.getResourceString("DATA_DLG_AFTER"), string};
            stringArray[n2 + 1] = MessageFormat.format("{0} {1}", objectArray);
            ++n2;
        }
        if (n == 0) {
            stringArray[0] = DatapoolPlugin.getResourceString("DATA_DLG_FIRST_ELEMENT");
        }
        return stringArray;
    }

    private String[] getRecordIndexLabels(IDatapoolEquivalenceClass iDatapoolEquivalenceClass) {
        if (iDatapoolEquivalenceClass == null) {
            return null;
        }
        int n = iDatapoolEquivalenceClass.getRecordCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = String.valueOf(n2);
            ++n2;
        }
        return stringArray;
    }

    private int findEquivalenceClassIndexInCombo(IDatapoolEquivalenceClass[] iDatapoolEquivalenceClassArray, IDatapoolEquivalenceClass iDatapoolEquivalenceClass) {
        if (iDatapoolEquivalenceClassArray == null || iDatapoolEquivalenceClass == null) {
            return -1;
        }
        int n = 0;
        while (n < iDatapoolEquivalenceClassArray.length) {
            if (iDatapoolEquivalenceClassArray[n].equals(iDatapoolEquivalenceClass)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String getName() {
        return this.name;
    }

    public int getInsertionIndex() {
        return this.insertionIndex;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = null;
        Combo combo = (Combo)selectionEvent.widget;
        if (combo.getSelectionIndex() != 0) {
            int n = combo.getSelectionIndex();
            IDatapoolEquivalenceClass[] iDatapoolEquivalenceClassArray = (IDatapoolEquivalenceClass[])combo.getData(TAG_EQUIVALENCE_CLASSES);
            iDatapoolEquivalenceClass = iDatapoolEquivalenceClassArray[n - 1];
            this.insertionIndex = this.datapool.getEquivalenceClassIndex(iDatapoolEquivalenceClass.getName());
        } else {
            this.insertionIndex = -1;
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.nameField != null) {
            this.name = this.nameField.getText();
        }
        this.enableOK();
    }

    private String createDefaultName() {
        Object[] objectArray = new Object[]{DatapoolPlugin.getResourceString("DATA_EC_NAME"), NumberFormat.getInstance().format(this.defaultNameCounter)};
        ++this.defaultNameCounter;
        return MessageFormat.format("{0}{1}", objectArray);
    }
}

