/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.common;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.loaders.common.ExecutionContext;
import org.eclipse.hyades.loaders.common.ExecutionResultData;
import org.eclipse.hyades.loaders.common.IXMLEventConstants;
import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.common.common.CMNExtendedProperty;
import org.eclipse.hyades.models.common.common.CommonFactory;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;

public abstract class XMLexecutionEventLoader
extends IgnoredXMLFragmentLoader
implements IXMLEventConstants {
    public static final boolean DEBUG = false;
    public static final String ROOT_PARENT = "ROOT";
    protected static final String EVENT_ID = "id";
    protected static final String EVENT_OWNERID = "ownerId";
    protected static final String EVENT_TIMESTAMP = "timestamp";
    protected static final String EVENT_TEXT = "text";
    protected static final String EVENT_PARENTID = "parentId";
    protected static final String EVENT_NAME = "name";
    protected static final String EVENT_EVENT_TYPE = "eventType";
    protected static final String EVENT_SORT_BY = "sortBy";
    protected static final String EVENT_CONFLICT = "conflict";
    protected static final String EVENT_PROPERTY = "property";
    protected static final String EVENT_PROPERTY_NAME = "pname";
    protected static final String EVENT_PROPERTY_TYPE = "ptype";
    protected static final String EVENT_PROPERTY_VALUE = "pvalue";
    protected String id = null;
    protected String ownerId = null;
    protected long timestamp = -1L;
    protected String text;
    protected TPFExecutionEvent event = null;
    protected String parentId = null;
    protected String name = null;
    protected String eventType = null;
    protected String sortBy = null;
    protected int conflict = 0;
    protected CMNExtendedProperty property = null;
    protected ArrayList properties = new ArrayList();

    public void initialize(HierarchyContext hierarchyContext, String string) {
        super.initialize(hierarchyContext, string);
        this.event = null;
        this.id = null;
        this.ownerId = null;
        this.timestamp = 0L;
        this.text = null;
        this.parentId = null;
        this.name = null;
        this.eventType = null;
        this.sortBy = null;
        this.conflict = 0;
        this.property = null;
        this.properties.clear();
        this.printTag(string);
    }

    public void addAttribute(String string, String string2) {
        switch (LoadersUtils.getHashCode((String)string)) {
            case 3355: {
                this.id = string2;
                break;
            }
            case -1054729426: {
                this.ownerId = string2;
                break;
            }
            case 1175162725: {
                this.parentId = string2;
                break;
            }
            case 55126294: {
                this.timestamp = Long.parseLong(string2);
                break;
            }
            case 3556653: {
                this.text = string2;
                break;
            }
            case 3373707: {
                this.name = string2;
                break;
            }
            case 31430900: {
                this.eventType = string2;
                break;
            }
            case -896594283: {
                this.sortBy = string2;
                break;
            }
            case -580047918: {
                this.conflict = Integer.parseInt(string2);
                break;
            }
            case 106808059: {
                if (this.property == null) break;
                this.property.setName(string2);
                break;
            }
            case 107009962: {
                if (this.property == null) break;
                this.property.setType(string2);
                break;
            }
            case -976529663: {
                if (this.property == null) break;
                this.property.setValue(string2);
                break;
            }
        }
    }

    public void startChild(String string) {
        switch (LoadersUtils.getHashCode((String)string)) {
            case 0: {
                this.property = CommonFactory.eINSTANCE.createCMNExtendedProperty();
            }
        }
        super.startChild(string);
    }

    public void endChild(String string) {
        switch (LoadersUtils.getHashCode((String)string)) {
            case 0: {
                this.properties.add(this.property);
                this.property = null;
            }
        }
        super.endChild(string);
    }

    public void addYourselfInContext() {
        CMNExtendedProperty cMNExtendedProperty;
        Object object;
        if (this.event == null) {
            return;
        }
        this.printEndTag();
        this.event.setId(this.id);
        this.event.setOwnerId(this.ownerId);
        this.event.setTimestamp(this.timestamp);
        this.event.setText(this.text);
        this.event.setName(this.name);
        this.event.setEventType(this.eventType);
        if (this.properties != null) {
            object = this.properties.iterator();
            while (object.hasNext()) {
                cMNExtendedProperty = (CMNExtendedProperty)object.next();
                if (cMNExtendedProperty == null) continue;
                this.event.getProperties().add((Object)cMNExtendedProperty);
            }
        }
        if (this.parentId == null) {
            object = (ExecutionContext)this.context.getCustomData().get(ExecutionContext.root);
            ((ExecutionContext)object).logEvent(this.event);
        } else if (this.ownerId != null && this.ownerId.length() != 0 && (cMNExtendedProperty = ExecutionResultData.getObjectFromTest(((ExecutionContext)(object = (ExecutionContext)this.context.getCustomData().get(ExecutionContext.root))).getTestSuite(), this.ownerId)) != null && cMNExtendedProperty instanceof BVRInteractionFragment) {
            this.event.setInteractionFragment((BVRInteractionFragment)((Object)cMNExtendedProperty));
        }
    }

    public void addYourselfToContainer() {
        ExecutionContext executionContext = (ExecutionContext)this.context.getCustomData().get(ExecutionContext.root);
        if (this.parentId != null && this.parentId.equals(ROOT_PARENT)) {
            TPFExecutionResult tPFExecutionResult = executionContext.rootResult.getResult();
            if (tPFExecutionResult != null) {
                TPFExecutionHistory tPFExecutionHistory = tPFExecutionResult.getExecutionHistory();
                if (tPFExecutionHistory == null) {
                    tPFExecutionHistory = Common_TestprofileFactory.eINSTANCE.createTPFExecutionHistory();
                    tPFExecutionResult.setExecutionHistory(tPFExecutionHistory);
                }
                if (!this.insertEvent(tPFExecutionHistory.getExecutionEvents(), this.event)) {
                    this.event.setExecutionHistory(tPFExecutionHistory);
                }
            }
        } else if (this.parentId != null) {
            TPFExecutionEvent tPFExecutionEvent;
            TPFExecutionResult tPFExecutionResult = executionContext.rootResult.getResult();
            EObject eObject = tPFExecutionResult.eResource().getEObject(this.parentId);
            if (eObject != null && eObject instanceof TPFInvocationEvent) {
                TPFExecutionHistory tPFExecutionHistory = ((TPFInvocationEvent)eObject).getInvokedExecutionResult().getExecutionHistory();
                if (tPFExecutionHistory != null && !this.insertEvent(tPFExecutionHistory.getExecutionEvents(), this.event)) {
                    this.event.setExecutionHistory(tPFExecutionHistory);
                }
            } else if (eObject != null && !this.insertEvent((tPFExecutionEvent = (TPFExecutionEvent)eObject).getChildren(), this.event)) {
                this.event.setParent(tPFExecutionEvent);
            }
        }
    }

    private EAttribute getSortEAttribute() {
        if (this.sortBy == null) {
            return null;
        }
        EStructuralFeature eStructuralFeature = this.event.eClass().getEStructuralFeature(this.sortBy);
        if (eStructuralFeature == null || !(eStructuralFeature instanceof EAttribute)) {
            return null;
        }
        return (EAttribute)eStructuralFeature;
    }

    private boolean isSortNeeded() {
        if (this.sortBy == null || this.sortBy.length() == 0) {
            return false;
        }
        EAttribute eAttribute = this.getSortEAttribute();
        if (eAttribute == null) {
            return false;
        }
        Object object = this.event.eGet((EStructuralFeature)eAttribute);
        return object != null;
    }

    private boolean insertEvent(EList eList, TPFExecutionEvent tPFExecutionEvent) {
        if (this.resolveConflict(eList)) {
            return true;
        }
        if (!this.isSortNeeded()) {
            return false;
        }
        int n = this.getIndex(eList, tPFExecutionEvent);
        if (n >= eList.size()) {
            return false;
        }
        eList.add(n, (Object)tPFExecutionEvent);
        return true;
    }

    protected boolean resolveConflict(EList eList) {
        if (this.conflict == 0) {
            return false;
        }
        if (this.event.getId() == null) {
            return false;
        }
        TPFExecutionEvent tPFExecutionEvent = null;
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            TPFExecutionEvent tPFExecutionEvent2 = (TPFExecutionEvent)iterator.next();
            if (!this.isIdentical(tPFExecutionEvent2)) continue;
            tPFExecutionEvent = tPFExecutionEvent2;
            break;
        }
        if (tPFExecutionEvent == null) {
            return false;
        }
        if (this.needOverwrite(tPFExecutionEvent)) {
            this.overwrite(tPFExecutionEvent);
        }
        return true;
    }

    protected boolean isIdentical(TPFExecutionEvent tPFExecutionEvent) {
        return this.event.getId().equals(tPFExecutionEvent.getId()) && this.event.getClass().getName().equals(tPFExecutionEvent.getClass().getName());
    }

    protected boolean needOverwrite(TPFExecutionEvent tPFExecutionEvent) {
        boolean bl = false;
        switch (this.conflict) {
            case 1: {
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 3: {
                if (this.event.getTimestamp() >= tPFExecutionEvent.getTimestamp()) break;
                bl = true;
                break;
            }
            case 4: {
                if (this.event.getTimestamp() <= tPFExecutionEvent.getTimestamp()) break;
                bl = true;
                break;
            }
            default: {
                return false;
            }
        }
        return bl;
    }

    protected void overwrite(TPFExecutionEvent tPFExecutionEvent) {
        tPFExecutionEvent.setTimestamp(this.event.getTimestamp());
        tPFExecutionEvent.setText(this.event.getText());
        tPFExecutionEvent.setEventType(this.event.getEventType());
        tPFExecutionEvent.setName(this.event.getName());
        tPFExecutionEvent.setInteractionFragment(this.event.getInteractionFragment());
        tPFExecutionEvent.setOwnerId(this.event.getOwnerId());
    }

    private int getIndex(EList eList, TPFExecutionEvent tPFExecutionEvent) {
        EAttribute eAttribute = (EAttribute)tPFExecutionEvent.eClass().getEStructuralFeature(this.sortBy);
        String string = tPFExecutionEvent.eGet((EStructuralFeature)eAttribute).toString();
        int n = 0;
        Object object = null;
        n = 0;
        while (n < eList.size()) {
            String string2;
            TPFExecutionEvent tPFExecutionEvent2 = (TPFExecutionEvent)eList.get(n);
            object = tPFExecutionEvent2.eGet((EStructuralFeature)eAttribute);
            if (object != null && (string2 = object.toString()).compareTo(string) > 0) break;
            ++n;
        }
        return n;
    }

    protected void printTag(String string) {
    }

    protected void printAttribute(String string, String string2) {
    }

    protected void printEndTag() {
    }
}

