/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.datapool.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolListener;
import org.eclipse.hyades.edit.datapool.IDatapoolRecord;
import org.eclipse.hyades.execution.runtime.datapool.DatapoolException;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolFactory;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage;
import org.eclipse.hyades.models.common.datapool.DPLCell;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass;
import org.eclipse.hyades.models.common.datapool.DPLRecord;
import org.eclipse.hyades.models.common.datapool.DPLVariable;
import org.eclipse.hyades.models.common.datapool.impl.DPLDatapoolImpl;

public class DPLEquivalenceClassImpl
extends CMNNamedElementImpl
implements DPLEquivalenceClass {
    public static final String copyright = "";
    protected EList records = null;
    static /* synthetic */ Class class$org$eclipse$hyades$models$common$datapool$DPLRecord;

    protected DPLEquivalenceClassImpl() {
    }

    protected EClass eStaticClass() {
        return Common_DatapoolPackage.eINSTANCE.getDPLEquivalenceClass();
    }

    public EList getRecords() {
        if (this.records == null) {
            this.records = new EObjectContainmentEList(class$org$eclipse$hyades$models$common$datapool$DPLRecord == null ? (class$org$eclipse$hyades$models$common$datapool$DPLRecord = DPLEquivalenceClassImpl.class$("org.eclipse.hyades.models.common.datapool.DPLRecord")) : class$org$eclipse$hyades$models$common$datapool$DPLRecord, (InternalEObject)this, 3);
        }
        return this.records;
    }

    public NotificationChain eInverseRemove(InternalEObject internalEObject, int n, Class clazz, NotificationChain notificationChain) {
        if (n >= 0) {
            switch (this.eDerivedStructuralFeatureID(n, clazz)) {
                case 3: {
                    return ((InternalEList)this.getRecords()).basicRemove((Object)internalEObject, notificationChain);
                }
            }
            return this.eDynamicInverseRemove(internalEObject, n, clazz, notificationChain);
        }
        return this.eBasicSetContainer(null, n, notificationChain);
    }

    public Object eGet(EStructuralFeature eStructuralFeature, boolean bl) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                return this.getId();
            }
            case 1: {
                return this.getDescription();
            }
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.getRecords();
            }
        }
        return this.eDynamicGet(eStructuralFeature, bl);
    }

    public void eSet(EStructuralFeature eStructuralFeature, Object object) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                this.setId((String)object);
                return;
            }
            case 1: {
                this.setDescription((String)object);
                return;
            }
            case 2: {
                this.setName((String)object);
                return;
            }
            case 3: {
                this.getRecords().clear();
                this.getRecords().addAll((Collection)object);
                return;
            }
        }
        this.eDynamicSet(eStructuralFeature, object);
    }

    public void eUnset(EStructuralFeature eStructuralFeature) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                this.setId(CMNNamedElementImpl.ID_EDEFAULT);
                return;
            }
            case 1: {
                this.setDescription(CMNNamedElementImpl.DESCRIPTION_EDEFAULT);
                return;
            }
            case 2: {
                this.setName(CMNNamedElementImpl.NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.getRecords().clear();
                return;
            }
        }
        this.eDynamicUnset(eStructuralFeature);
    }

    public boolean eIsSet(EStructuralFeature eStructuralFeature) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                return CMNNamedElementImpl.ID_EDEFAULT == null ? this.id != null : !CMNNamedElementImpl.ID_EDEFAULT.equals(this.id);
            }
            case 1: {
                return CMNNamedElementImpl.DESCRIPTION_EDEFAULT == null ? this.description != null : !CMNNamedElementImpl.DESCRIPTION_EDEFAULT.equals(this.description);
            }
            case 2: {
                return CMNNamedElementImpl.NAME_EDEFAULT == null ? this.name != null : !CMNNamedElementImpl.NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return this.records != null && !this.records.isEmpty();
            }
        }
        return this.eDynamicIsSet(eStructuralFeature);
    }

    public IDatapoolRecord constructRecord() {
        return this.constructRecord(null);
    }

    public IDatapoolRecord constructRecord(Object[] objectArray) {
        DPLRecord dPLRecord = Common_DatapoolFactory.eINSTANCE.createDPLRecord();
        DPLDatapool dPLDatapool = (DPLDatapool)this.eContainer;
        if (dPLDatapool == null) {
            return null;
        }
        EList eList = dPLDatapool.getDatapoolSpec().getVariables();
        ListIterator listIterator = eList.listIterator();
        int n = 0;
        while (listIterator.hasNext()) {
            DPLCell dPLCell = Common_DatapoolFactory.eINSTANCE.createDPLCell();
            dPLCell.setVariable((DPLVariable)listIterator.next());
            dPLRecord.getCells().add((Object)dPLCell);
            if (objectArray != null && n < objectArray.length) {
                dPLCell.setCellValue((String)objectArray[n++]);
                continue;
            }
            dPLCell.setValue(null);
        }
        return dPLRecord;
    }

    public void insertRecord(IDatapoolRecord iDatapoolRecord, int n) {
        this.insertRecordDoNotNotify(iDatapoolRecord, n);
        DPLDatapool dPLDatapool = (DPLDatapool)this.eContainer();
        IDatapoolListener iDatapoolListener = ((DPLDatapoolImpl)dPLDatapool).getDatapoolListener();
        if (iDatapoolListener != null) {
            iDatapoolListener.recordAdded((IDatapool)dPLDatapool, dPLDatapool.getEquivalenceClasses().indexOf((Object)this), n);
        }
    }

    public void insertRecordDoNotNotify(IDatapoolRecord iDatapoolRecord, int n) {
        ListIterator listIterator = this.getRecords().listIterator();
        while (listIterator.hasNext()) {
            if (!((DPLRecord)listIterator.next()).equals(iDatapoolRecord)) continue;
            throw new DatapoolException("Attempt to enter duplicate records into an equivalence class");
        }
        this.getRecords().add(n, (Object)iDatapoolRecord);
    }

    public void appendRecord(IDatapoolRecord iDatapoolRecord) {
        this.insertRecord(iDatapoolRecord, this.getRecords().size());
    }

    public void replaceRecord(IDatapoolRecord iDatapoolRecord, int n) {
        this.removeRecordDoNotNotify(n);
        this.insertRecordDoNotNotify(iDatapoolRecord, n);
        DPLDatapool dPLDatapool = (DPLDatapool)this.eContainer();
        IDatapoolListener iDatapoolListener = ((DPLDatapoolImpl)dPLDatapool).getDatapoolListener();
        if (iDatapoolListener != null) {
            iDatapoolListener.recordChanged((IDatapool)dPLDatapool, dPLDatapool.getEquivalenceClasses().indexOf((Object)this), n);
        }
    }

    public IDatapoolRecord removeRecord(int n) {
        IDatapoolRecord iDatapoolRecord = this.removeRecordDoNotNotify(n);
        DPLDatapool dPLDatapool = (DPLDatapool)this.eContainer();
        IDatapoolListener iDatapoolListener = ((DPLDatapoolImpl)dPLDatapool).getDatapoolListener();
        if (iDatapoolListener != null) {
            iDatapoolListener.recordRemoved((IDatapool)dPLDatapool, dPLDatapool.getEquivalenceClasses().indexOf((Object)this), n);
        }
        return iDatapoolRecord;
    }

    protected IDatapoolRecord removeRecordDoNotNotify(int n) {
        IDatapoolRecord iDatapoolRecord = (IDatapoolRecord)this.getRecords().remove(n);
        return iDatapoolRecord;
    }

    public void moveRecord(int n, int n2) {
        IDatapoolRecord iDatapoolRecord = this.removeRecordDoNotNotify(n);
        this.insertRecordDoNotNotify(iDatapoolRecord, n2);
        DPLDatapool dPLDatapool = (DPLDatapool)this.eContainer();
        IDatapoolListener iDatapoolListener = ((DPLDatapoolImpl)dPLDatapool).getDatapoolListener();
        if (iDatapoolListener != null) {
            iDatapoolListener.recordMoved((IDatapool)dPLDatapool, dPLDatapool.getEquivalenceClasses().indexOf((Object)this), n, n2);
        }
    }

    public void reorder(int[] nArray) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        if (nArray.length != this.getRecordCount()) {
            throw new DatapoolException("Record reordering attempt with wrong number of records specified");
        }
        int n = 0;
        while (n < nArray.length) {
            linkedList.add(this.getRecords().get(nArray[n]));
            ++n;
        }
        this.getRecords().clear();
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            this.insertRecordDoNotNotify((IDatapoolRecord)listIterator.next(), this.getRecords().size());
        }
        DPLDatapool dPLDatapool = (DPLDatapool)this.eContainer();
        IDatapoolListener iDatapoolListener = ((DPLDatapoolImpl)dPLDatapool).getDatapoolListener();
        int n2 = dPLDatapool.getEquivalenceClasses().indexOf((Object)this);
        if (iDatapoolListener != null) {
            iDatapoolListener.equivalenceClassReordered((IDatapool)dPLDatapool, n2);
        }
    }

    public int getRecordCount() {
        return this.getRecords().size();
    }

    public org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord getRecord(int n) {
        return (org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord)this.getRecords().get(n);
    }

    public org.eclipse.hyades.execution.runtime.datapool.IDatapool getDatapool() {
        return (org.eclipse.hyades.execution.runtime.datapool.IDatapool)this.eContainer();
    }

    public void setName(String string) {
        super.setName(string);
        DPLDatapool dPLDatapool = (DPLDatapool)this.eContainer();
        if (dPLDatapool == null) {
            return;
        }
        IDatapoolListener iDatapoolListener = ((DPLDatapoolImpl)dPLDatapool).getDatapoolListener();
        if (iDatapoolListener != null) {
            iDatapoolListener.equivalenceClassChanged((IDatapool)dPLDatapool, dPLDatapool.getEquivalenceClasses().indexOf((Object)this));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

