/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class ResourceUtil {
    public static final Map RESOURCE_OPTIONS = new HashMap();

    public ResourceUtil() {
        RESOURCE_OPTIONS.put("DECLARE_XML", Boolean.TRUE);
        RESOURCE_OPTIONS.put("SKIP_ESCAPE", Boolean.FALSE);
    }

    public static void createContainer(IContainer iContainer, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iContainer == null || iContainer.exists()) {
            return;
        }
        ResourceUtil.createContainer(iContainer.getParent(), iProgressMonitor);
        if (iContainer instanceof IProject) {
            ((IProject)iContainer).create(iProgressMonitor);
        } else if (iContainer instanceof IFolder) {
            ((IFolder)iContainer).create(true, true, iProgressMonitor);
        }
    }

    public static Map getFiles(IWorkspaceRoot iWorkspaceRoot, String[] stringArray, IGetFilesVisitor iGetFilesVisitor) {
        HashMap hashMap = new HashMap(stringArray.length, 1.1f);
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            hashMap.put(stringArray[n], new ArrayList());
            ++n;
        }
        if (iGetFilesVisitor == null) {
            iGetFilesVisitor = new IGetFilesVisitor(){

                public Object visit(IFile iFile) {
                    return iFile;
                }
            };
        }
        IProject[] iProjectArray = iWorkspaceRoot.getProjects();
        int n3 = 0;
        while (n3 < iProjectArray.length) {
            ResourceUtil.getFiles((IResource)iProjectArray[n3], hashMap, iGetFilesVisitor);
            ++n3;
        }
        return hashMap;
    }

    public static Map getFiles(IResource iResource, String[] stringArray, IGetFilesVisitor iGetFilesVisitor) {
        if (iResource == null || !iResource.exists()) {
            return Collections.EMPTY_MAP;
        }
        if (iGetFilesVisitor == null) {
            iGetFilesVisitor = new IGetFilesVisitor(){

                public Object visit(IFile iFile) {
                    return iFile;
                }
            };
        }
        HashMap hashMap = new HashMap(stringArray.length, 1.1f);
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            hashMap.put(stringArray[n], new ArrayList());
            ++n;
        }
        ResourceUtil.getFiles(iResource, hashMap, iGetFilesVisitor);
        return hashMap;
    }

    private static void getFiles(IResource iResource, Map map, IGetFilesVisitor iGetFilesVisitor) {
        if (iResource == null || !iResource.exists()) {
            return;
        }
        switch (iResource.getType()) {
            case 1: {
                Object object;
                List list = (List)map.get(iResource.getFileExtension());
                if (list == null || (object = iGetFilesVisitor.visit((IFile)iResource)) == null) break;
                list.add(object);
                break;
            }
            case 4: {
                IProject iProject = (IProject)iResource;
                if (!iProject.isOpen()) {
                    return;
                }
            }
            case 2: {
                try {
                    IResource[] iResourceArray = ((IContainer)iResource).members();
                    int n = 0;
                    while (n < iResourceArray.length) {
                        ResourceUtil.getFiles(iResourceArray[n], map, iGetFilesVisitor);
                        ++n;
                    }
                }
                catch (CoreException coreException) {
                    ResourceUtil.logError(coreException);
                }
                break;
            }
        }
    }

    public static EObject[] load(ResourceSet resourceSet, IFile iFile) {
        if (iFile == null) {
            return new EObject[0];
        }
        return ResourceUtil.load(resourceSet, iFile.getFullPath().toString());
    }

    public static EObject[] load(ResourceSet resourceSet, String string) {
        if (string == null) {
            return new EObject[0];
        }
        URI uRI = URI.createPlatformResourceURI((String)string);
        Resource resource = null;
        try {
            if (resourceSet != null) {
                resource = resourceSet.getResource(uRI, true);
            } else {
                Path path = new Path(string);
                Resource.Factory factory = ResourceUtil.getResourceFactory(path.getFileExtension());
                if (factory != null) {
                    resource = factory.createResource(uRI);
                    resource.load(RESOURCE_OPTIONS);
                }
            }
        }
        catch (Exception exception) {
            ResourceUtil.logError(exception);
        }
        if (resource == null) {
            return new EObject[0];
        }
        return (EObject[])resource.getContents().toArray((Object[])new EObject[resource.getContents().size()]);
    }

    public static Resource.Factory getResourceFactory(String string) {
        Resource.Factory factory;
        if (string != null && (factory = (Resource.Factory)Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().get(string)) != null) {
            return factory;
        }
        return (Resource.Factory)Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().get(string);
    }

    public static final void logError(Throwable throwable) {
        Status status = new Status(4, ResourcesPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, throwable.getMessage(), throwable);
        ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
        throwable.printStackTrace();
    }

    public static interface IGetFilesVisitor {
        public Object visit(IFile var1);
    }
}

