/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui;

import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.models.common.util.SaveManager;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.internal.report.ReportManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TestUI
implements ICommonConstants {
    public static final String REPORT_FILE_EXTENSION = "report";
    public static final String REPORT_OPEN_EDITOR = "OpenReportEditor";
    public static final String OPEN_EDITOR = "openEditor";
    public static final String SAVE_INTERVAL = "saveInterval";
    public static final String EXECUTION_FILTER = "execFilter";
    public static final String LOCALHOST_PORT = "localhost_port";
    public static final String DEFAULT_HOST_NAME = "default_host_name";
    private static ReportManager reportManager;

    static void dispose() {
        if (reportManager != null) {
            reportManager.saveIntoPreferenceStore();
            reportManager.dispose();
            reportManager = null;
        }
    }

    public static void monitorPreferences() {
        IPropertyChangeListener iPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (TestUI.SAVE_INTERVAL.equals(propertyChangeEvent.getProperty()) && SaveManager.getInstance().isRunning()) {
                    SaveManager.getInstance().stop();
                    SaveManager.getInstance().start(TestUIPlugin.getInstance().getPreferenceStore().getLong(TestUI.SAVE_INTERVAL));
                }
            }
        };
        TestUIPlugin.getInstance().getPreferenceStore().addPropertyChangeListener(iPropertyChangeListener);
    }

    public static boolean isSupportedFileExtension(String string) {
        if ("testsuite".equals(string)) {
            return true;
        }
        if ("deploy".equals(string)) {
            return true;
        }
        if ("location".equals(string)) {
            return true;
        }
        if ("artifact".equals(string)) {
            return true;
        }
        if ("execution".equals(string)) {
            return true;
        }
        return "datapool".equals(string);
    }

    public static String[] getSupportedFileExtensions() {
        return new String[]{"deploy", "location", "artifact", "testsuite", "execution", "datapool"};
    }

    public static ReportManager getReportManager() {
        if (reportManager == null) {
            reportManager = new ReportManager((AbstractUIPlugin)TestUIPlugin.getInstance(), "reportExtensions");
            reportManager.loadFromPluginRegistry();
            reportManager.loadFromPreferenceStore();
        }
        return reportManager;
    }
}

