/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.editor.extension;

import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.DefaultTestContextOverviewContribution;
import org.eclipse.hyades.test.ui.editor.form.TestCasesForm;
import org.eclipse.hyades.test.ui.editor.form.TestContextOverview;
import org.eclipse.hyades.test.ui.editor.form.base.IHasEStructuralFeature;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.ui.editor.IHyadesEditorPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class TestSuiteEditorExtension
extends BaseEditorExtension {
    public static final String EXTENSION_ID = "org.eclipse.hyades.test.ui.editor.extension.TestSuite";
    private WidgetFactory widgetFactory = new WidgetFactory();
    private EditorForm[] forms = new EditorForm[]{new TestContextOverview(this, this.widgetFactory, new DefaultTestContextOverviewContribution()), new TestCasesForm(this, this.widgetFactory)};

    public void dispose() {
        int n = 0;
        while (this.forms != null && n < this.forms.length) {
            if (this.forms[n] != null) {
                this.forms[n].dispose();
                this.forms[n] = null;
            }
            ++n;
        }
        super.dispose();
    }

    public TPFTestSuite getTestSuite() {
        return (TPFTestSuite)this.getHyadesEditorPart().getEditorObject();
    }

    public final void createPages() {
        IHyadesEditorPart iHyadesEditorPart = this.getHyadesEditorPart();
        int n = 0;
        while (this.forms != null && n < this.forms.length) {
            iHyadesEditorPart.addPage(this.forms[n].createControl());
            iHyadesEditorPart.setPageText(n, this.forms[n].getHeadingText());
            ++n;
        }
    }

    public void refreshContent(Object object) {
        int n = 0;
        while (this.forms != null && n < this.forms.length) {
            if (this.forms[n] != null) {
                this.forms[n].load();
            }
            ++n;
        }
    }

    public IStructuredSelection getSelection() {
        StructuredSelection structuredSelection = null;
        int n = this.getHyadesEditorPart().getActivePage();
        if (n > -1 && this.forms != null && n < this.forms.length) {
            structuredSelection = (IStructuredSelection)this.forms[n].getCurrentSelection();
        }
        if (structuredSelection == null) {
            structuredSelection = StructuredSelection.EMPTY;
        }
        return structuredSelection;
    }

    public boolean pageActivated(int n) {
        if (n > -1 && this.forms != null && n < this.forms.length) {
            return this.forms[n].activated();
        }
        return false;
    }

    public void setSelection(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() == 1) {
            Object object = iStructuredSelection.getFirstElement();
            if (object == this.getTestSuite()) {
                // empty if block
            }
            boolean bl = true;
            int n = 0;
            while (bl && this.forms != null && n < this.forms.length) {
                Class clazz;
                if (this.forms[n] instanceof IHasEStructuralFeature && (clazz = ((IHasEStructuralFeature)((Object)this.forms[n])).getStructuralFeature().getEType().getInstanceClass()).isAssignableFrom(object.getClass())) {
                    bl = false;
                    this.forms[n].selectReveal((ISelection)iStructuredSelection);
                    this.getHyadesEditorPart().setActivePage(n);
                }
                ++n;
            }
        }
    }

    public EditorForm[] getForms() {
        return this.forms;
    }

    public WidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    public void setForms(EditorForm[] editorFormArray) {
        this.forms = editorFormArray;
    }
}

