/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.editor.form;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.extension.TestSuiteEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.TestContextOverviewContribution;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementSection;
import org.eclipse.hyades.test.ui.editor.form.util.TestObjectiveSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class TestContextOverview
extends EditorForm {
    protected TestContextOverviewContribution tsoContributor;
    private TestSuiteEditorExtension editor;
    private NamedElementSection genericInfoSection;
    private TestObjectiveSection testObjectiveSection;
    private Object[] leftSections;
    private Object[] rightSections;
    private boolean hideGenericInformation = false;
    private boolean hideTestObjective = false;

    public TestContextOverview(BaseEditorExtension baseEditorExtension, WidgetFactory widgetFactory) {
        super(baseEditorExtension, widgetFactory);
        this.editor = (TestSuiteEditorExtension)baseEditorExtension;
        this.setHeadingText(TestUIPlugin.getString("W_OVERVIEW"));
    }

    public TestContextOverview(BaseEditorExtension baseEditorExtension, WidgetFactory widgetFactory, TestContextOverviewContribution testContextOverviewContribution) {
        super(baseEditorExtension, widgetFactory);
        this.editor = (TestSuiteEditorExtension)baseEditorExtension;
        this.tsoContributor = testContextOverviewContribution;
        this.tsoContributor.setOverviewForm(this);
        this.setHeadingText(TestUIPlugin.getString("W_OVERVIEW"));
    }

    public void dispose() {
        int n = 0;
        while (this.leftSections != null && n < this.leftSections.length) {
            if (this.leftSections[n] != null && this.leftSections[n] instanceof IDisposable) {
                ((IDisposable)this.leftSections[n]).dispose();
                this.leftSections[n] = null;
            }
            ++n;
        }
        int n2 = 0;
        while (this.rightSections != null && n2 < this.rightSections.length) {
            if (this.rightSections[n2] != null && this.rightSections[n2] instanceof IDisposable) {
                ((IDisposable)this.rightSections[n2]).dispose();
                this.rightSections[n2] = null;
            }
            ++n2;
        }
        if (this.genericInfoSection != null && this.genericInfoSection instanceof IDisposable) {
            this.genericInfoSection.dispose();
            this.genericInfoSection = null;
        }
        if (this.testObjectiveSection != null && this.testObjectiveSection instanceof IDisposable) {
            this.testObjectiveSection.dispose();
            this.testObjectiveSection = null;
        }
        super.dispose();
    }

    protected TPFTestSuite getTestContext() {
        return this.editor.getTestSuite();
    }

    public Control createControl() {
        Control control = super.createControl();
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)(TestUIPlugin.getID() + ".tstf0001"));
        return control;
    }

    protected void createEditorFormContents(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 15;
        composite.setLayout((Layout)gridLayout);
        Composite composite2 = this.createColumn(composite);
        Composite composite3 = this.createColumn(composite);
        if (this.tsoContributor == null || this.tsoContributor != null && this.tsoContributor.hideGenericInformation()) {
            this.hideGenericInformation = true;
        } else {
            Control control = this.createGenericInformation(composite2);
            control.setLayoutData((Object)new GridData(770));
            WorkbenchHelp.setHelp((Control)control, (String)(TestUIPlugin.getID() + ".tstf0004"));
        }
        if (this.tsoContributor == null || this.tsoContributor != null && this.tsoContributor.hideTestObjectiveSection()) {
            this.hideTestObjective = true;
        } else {
            this.createTestObjectiveSection(composite2);
        }
        if (this.tsoContributor != null) {
            this.leftSections = this.tsoContributor.createLeftSections((IEditorExtension)this.editor);
            this.rightSections = this.tsoContributor.createRightSections((IEditorExtension)this.editor);
            int n = 0;
            while (n < this.leftSections.length) {
                if (this.leftSections[n] instanceof FormSection) {
                    this.registerSection((FormSection)this.leftSections[n]);
                    Control control = ((FormSection)this.leftSections[n]).createControl(composite2, this.factory);
                    control.setLayoutData((Object)new GridData(770));
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < this.rightSections.length) {
                if (this.rightSections[n2] instanceof FormSection) {
                    this.registerSection((FormSection)this.rightSections[n2]);
                    Control control = ((FormSection)this.rightSections[n2]).createControl(composite3, this.factory);
                    control.setLayoutData((Object)new GridData(770));
                }
                ++n2;
            }
        }
    }

    protected Control createTestObjectiveSection(Composite composite) {
        Control control = null;
        this.testObjectiveSection = new TestObjectiveSection(this.getBaseEditorExtension(), this.getWidgetFactory());
        this.testObjectiveSection.setCollapsable(true);
        this.testObjectiveSection.setHeaderText(TestUIPlugin.getString("L_TEST_OBJECTIVE"));
        this.testObjectiveSection.setDescription(TestUIPlugin.getString("L_TEST_OBJECTIVE_DSC"));
        control = this.testObjectiveSection.createControl(composite, this.getWidgetFactory());
        return control;
    }

    protected Control createGenericInformation(Composite composite) {
        this.genericInfoSection = new NamedElementSection(this){
            private StyledText typeText;
            private StyledText fileText;

            protected void addCenterControls(Composite composite, FormWidgetFactory formWidgetFactory) {
                if (TestContextOverview.this.tsoContributor != null) {
                    TestContextOverview.this.tsoContributor.addCenterGenericInformation(composite, TestContextOverview.this.getWidgetFactory());
                }
            }

            protected void addSouthControls(Composite composite, FormWidgetFactory formWidgetFactory) {
                Composite composite2 = TestContextOverview.this.getWidgetFactory().createComposite(composite);
                GridLayout gridLayout = new GridLayout(2, false);
                gridLayout.marginHeight = 0;
                gridLayout.marginWidth = 0;
                composite2.setLayout((Layout)gridLayout);
                composite2.setLayoutData((Object)GridDataUtil.createHorizontalFill());
                WidgetFactory widgetFactory = TestContextOverview.this.getWidgetFactory();
                widgetFactory.createLabel(composite2, TestUIPlugin.getString("L_TYPE"));
                this.typeText = widgetFactory.createStyledText(composite2, 65540);
                this.typeText.setEnabled(false);
                this.typeText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
                widgetFactory.createLabel(composite2, TestUIPlugin.getString("L_FILE"));
                this.fileText = widgetFactory.createStyledText(composite2, 65540);
                this.fileText.setEnabled(false);
                this.fileText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
                WorkbenchHelp.setHelp((Control)this.typeText, (String)(TestUIPlugin.getID() + ".tstf0003"));
                WorkbenchHelp.setHelp((Control)this.fileText, (String)(TestUIPlugin.getID() + ".tstf0002"));
                if (TestContextOverview.this.tsoContributor != null) {
                    TestContextOverview.this.tsoContributor.addSouthGenericInformation(composite2, TestContextOverview.this.getWidgetFactory());
                }
            }

            public void setInput(Object object) {
                IFile iFile;
                String string;
                super.setInput(object);
                if (this.getNameTextField() != null && (string = this.getNameTextField().getText()) != null && !string.equals("")) {
                    TestContextOverview.this.getBaseEditorExtension().getHyadesEditorPart().setTitle(string);
                }
                if ((string = TestContextOverview.this.getTestContext().getType()) != null) {
                    iFile = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeDescriptions").getDefaultAssociationDescriptor(string);
                    if (iFile != null && iFile.getName() != null) {
                        string = iFile.getName();
                    }
                    this.typeText.setText(string);
                }
                if ((iFile = EMFUtil.getWorkspaceFile((EObject)TestContextOverview.this.getTestContext())) != null) {
                    this.fileText.setText(iFile.getFullPath().toString());
                }
            }
        };
        this.registerSection(this.genericInfoSection);
        this.genericInfoSection.setHeaderText(TestUIPlugin.getString("EDT_GENERAL_INFO"));
        this.genericInfoSection.setDescription(TestUIPlugin.getString("EDT_GENERAL_DSC"));
        Control control = this.genericInfoSection.createControl(composite, this.getWidgetFactory());
        return control;
    }

    public void load() {
        if (!this.hideGenericInformation) {
            this.genericInfoSection.setInput(this.getTestContext());
        }
        if (!this.hideTestObjective) {
            this.testObjectiveSection.setInput(this.getTestContext());
        }
        if (this.tsoContributor != null) {
            this.tsoContributor.setTestContext(this.getTestContext());
            if (!this.hideGenericInformation) {
                this.tsoContributor.initializeSouthGenericInformation();
                this.tsoContributor.initializeCenterGenericInformation();
            }
            this.tsoContributor.initializeLeftSections(this.leftSections);
            this.tsoContributor.initializeRightSections(this.rightSections);
        }
    }

    public boolean activated() {
        return true;
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object)this.getTestContext());
    }
}

