/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.action.AddTestSuiteChildAction;
import org.eclipse.hyades.test.ui.wizard.ITestCaseWizard;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.ITypeValidator;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.hyades.ui.internal.wizard.selection.IWizardElement;
import org.eclipse.hyades.ui.internal.wizard.selection.SelectionWizard;
import org.eclipse.hyades.ui.internal.wizard.selection.WizardElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.help.WorkbenchHelp;

public class AddTestCaseAction
extends AddTestSuiteChildAction {
    private static Map testCaseTypesByTestSuiteType;

    public AddTestCaseAction() {
        super(TestUIPlugin.getString("BTN_ADD"));
        this.setToolTipText(TestUIPlugin.getString("ACT_TST_CASE_ADD_TIP"));
        this.setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("testcase_obj.gif"));
        WorkbenchHelp.setHelp((IAction)this, (String)(TestUIPlugin.getID() + ".atca0001"));
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        this.setActionPerformed(false);
        TPFTestSuite tPFTestSuite = this.getTestSuite(iStructuredSelection);
        if (tPFTestSuite == null) {
            return false;
        }
        String string = tPFTestSuite.getType();
        if (string == null) {
            return false;
        }
        HashSet<String> hashSet = null;
        if (testCaseTypesByTestSuiteType == null) {
            testCaseTypesByTestSuiteType = new HashMap();
        } else {
            hashSet = (HashSet<String>)testCaseTypesByTestSuiteType.get(string);
        }
        if (hashSet == null) {
            hashSet = new HashSet<String>();
            testCaseTypesByTestSuiteType.put(string, hashSet);
            IAssociationMapping iAssociationMapping = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeValidators");
            IAssociationDescriptor[] iAssociationDescriptorArray = iAssociationMapping.getAssociationDescriptors(string);
            if (iAssociationDescriptorArray.length == 0) {
                return false;
            }
            IAssociationMapping iAssociationMapping2 = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping("newTestCaseWizards");
            String[] stringArray = iAssociationMapping2.getTypes();
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                int n3 = 0;
                int n4 = iAssociationDescriptorArray.length;
                while (n3 < n4) {
                    ITypeValidator iTypeValidator = (ITypeValidator)iAssociationDescriptorArray[n3].createImplementationClassInstance();
                    if (iTypeValidator.isValidType(stringArray[n])) {
                        hashSet.add(stringArray[n]);
                        break;
                    }
                    ++n3;
                }
                ++n;
            }
        }
        return !hashSet.isEmpty();
    }

    public void run() {
        String string;
        this.setActionPerformed(false);
        TPFTestSuite tPFTestSuite = this.getTestSuite(this.getStructuredSelection());
        Set set = (Set)testCaseTypesByTestSuiteType.get(tPFTestSuite.getType());
        ArrayList<WizardElement> arrayList = new ArrayList<WizardElement>(set.size());
        IAssociationMapping iAssociationMapping = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping("newTestCaseWizards");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            IAssociationDescriptor[] iAssociationDescriptorArray = iAssociationMapping.getAssociationDescriptors(string);
            int n = 0;
            int n2 = iAssociationDescriptorArray.length;
            while (n < n2) {
                Object object = iAssociationDescriptorArray[n].createImplementationClassInstance();
                if (object instanceof ITestCaseWizard) {
                    WizardElement wizardElement = new WizardElement((IWizard)((ITestCaseWizard)object));
                    wizardElement.setId(iAssociationDescriptorArray[n].getId());
                    wizardElement.setLabel(iAssociationDescriptorArray[n].getName());
                    wizardElement.setDescription(iAssociationDescriptorArray[n].getDescription());
                    wizardElement.setImageDescriptor(iAssociationDescriptorArray[n].getImageDescriptor());
                    arrayList.add(wizardElement);
                }
                ++n;
            }
        }
        string = new SelectionWizard(arrayList.toArray(new IWizardElement[arrayList.size()]), TestUIPlugin.getString("WIZ_SEL_TST_CASE"));
        string.setWindowTitle(TestUIPlugin.getString("WIZ_TST_CASE_TTL"));
        this.openWizard(tPFTestSuite, (HyadesWizard)string, "TestCaseSelectionWizard");
    }
}

