/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.part.FileEditorInput;

public class EditDatapoolAction
extends SelectionListenerAction {
    public EditDatapoolAction() {
        super(TestUIPlugin.getString("label.Update"));
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection == null) {
            return false;
        }
        if (iStructuredSelection.size() != 1) {
            return false;
        }
        return iStructuredSelection.getFirstElement() instanceof DPLDatapool;
    }

    public void run() {
        IStructuredSelection iStructuredSelection = this.getStructuredSelection();
        if (iStructuredSelection == null) {
            return;
        }
        DPLDatapool dPLDatapool = (DPLDatapool)iStructuredSelection.getFirstElement();
        if (dPLDatapool == null) {
            return;
        }
        Resource resource = dPLDatapool.eResource();
        if (resource == null) {
            return;
        }
        try {
            IWorkbenchPage iWorkbenchPage = Workbench.getInstance().getActiveWorkbenchWindow().getActivePage();
            Path path = new Path(resource.getURI().toFileString());
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            if (!iFile.exists()) {
                return;
            }
            IEditorDescriptor iEditorDescriptor = Workbench.getInstance().getEditorRegistry().getDefaultEditor(resource.getURI().toFileString());
            if (iEditorDescriptor == null) {
                return;
            }
            iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), iEditorDescriptor.getId());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

