/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.test.ui.IEventLabelProvider;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.form.DefaultLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class EventLabelProvider
implements ILabelProvider {
    private HashMap providers = new HashMap();

    public EventLabelProvider() {
        IExtensionPoint iExtensionPoint = Platform.getPluginRegistry().getExtensionPoint(TestUIPlugin.getID() + ".executionHistoryExtension");
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                if (iConfigurationElementArray[n].getName() != null) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
                    String string = iConfigurationElement.getAttribute("targetType");
                    this.providers.put(string, iConfigurationElement);
                }
                ++n;
            }
        }
    }

    public IEventLabelProvider getProvider(String string) {
        IEventLabelProvider iEventLabelProvider;
        block2: {
            Object v;
            iEventLabelProvider = null;
            if (!this.providers.containsKey(string) || !((v = this.providers.get(string)) instanceof IConfigurationElement)) break block2;
            IConfigurationElement iConfigurationElement = (IConfigurationElement)v;
            try {
                iEventLabelProvider = (IEventLabelProvider)iConfigurationElement.createExecutableExtension("provider");
                this.providers.put(string, iEventLabelProvider);
            }
            catch (CoreException coreException) {
                TestUIPlugin.logInfo("Unable to retrieve provider");
            }
        }
        return iEventLabelProvider;
    }

    public Image getImage(Object object) {
        Image image = null;
        DefaultLabelProvider defaultLabelProvider = new DefaultLabelProvider();
        if (object instanceof TPFExecutionResult) {
            TPFExecutionResult tPFExecutionResult = (TPFExecutionResult)object;
            IEventLabelProvider iEventLabelProvider = this.getProvider(tPFExecutionResult.getType());
            image = iEventLabelProvider != null ? iEventLabelProvider.getImage(object) : defaultLabelProvider.getImage(object);
        } else if (object instanceof TPFExecutionEvent) {
            TPFExecutionEvent tPFExecutionEvent = (TPFExecutionEvent)object;
            IEventLabelProvider iEventLabelProvider = this.getProvider(tPFExecutionEvent.getEventType());
            image = iEventLabelProvider != null ? iEventLabelProvider.getImage(object) : defaultLabelProvider.getImage(object);
        }
        return image;
    }

    public String getText(Object object) {
        String string = "";
        DefaultLabelProvider defaultLabelProvider = new DefaultLabelProvider();
        if (object instanceof TPFExecutionResult) {
            TPFExecutionResult tPFExecutionResult = (TPFExecutionResult)object;
            IEventLabelProvider iEventLabelProvider = this.getProvider(tPFExecutionResult.getType());
            string = iEventLabelProvider != null ? iEventLabelProvider.getText(object) : defaultLabelProvider.getText(object);
        } else if (object instanceof TPFExecutionEvent) {
            TPFExecutionEvent tPFExecutionEvent = (TPFExecutionEvent)object;
            IEventLabelProvider iEventLabelProvider = this.getProvider(tPFExecutionEvent.getEventType());
            string = iEventLabelProvider != null ? iEventLabelProvider.getText(object) : defaultLabelProvider.getText(object);
        }
        return string;
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object object, String string) {
        return false;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
    }
}

