/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import java.util.Hashtable;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IBulletParagraph;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.Locator;
import org.eclipse.hyades.test.ui.internal.editor.form.base.Paragraph;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class BulletParagraph
extends Paragraph
implements IBulletParagraph {
    private int style = 0;
    private String text;
    private int CIRCLE_DIAM = 5;
    private int SPACING = 10;
    private int indent = -1;

    public BulletParagraph(boolean bl) {
        super(bl);
    }

    public int getIndent() {
        if (this.indent != -1) {
            return this.indent;
        }
        switch (this.style) {
            case 0: {
                return this.CIRCLE_DIAM + this.SPACING;
            }
        }
        return 20;
    }

    public int getBulletStyle() {
        return this.style;
    }

    public void setBulletStyle(int n) {
        this.style = n;
    }

    public void setBulletText(String string) {
        this.text = string;
    }

    public void setIndent(int n) {
        this.indent = n;
    }

    public String getBulletText() {
        return this.text;
    }

    public void paint(GC gC, int n, Locator locator, int n2, Hashtable hashtable, IHyperlinkSegment iHyperlinkSegment) {
        this.paintBullet(gC, locator, n2, hashtable);
        super.paint(gC, n, locator, n2, hashtable, iHyperlinkSegment);
    }

    public void paintBullet(GC gC, Locator locator, int n, Hashtable hashtable) {
        Image image;
        int n2 = locator.x - this.getIndent();
        if (this.style == 0) {
            int n3 = locator.y + n / 2 - this.CIRCLE_DIAM / 2;
            Color color = gC.getBackground();
            Color color2 = gC.getForeground();
            gC.setBackground(color2);
            gC.fillRectangle(n2, n3 + 1, 5, 3);
            gC.fillRectangle(n2 + 1, n3, 3, 5);
            gC.setBackground(color);
        } else if (this.style == 1 && this.text != null) {
            gC.drawText(this.text, n2, locator.y);
        } else if (this.style == 2 && this.text != null && (image = (Image)hashtable.get(this.text)) != null) {
            int n4 = locator.y + n / 2 - image.getBounds().height / 2;
            gC.drawImage(image, n2, n4);
        }
    }
}

