/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.hyades.test.ui.editor.form.base.IHyperlinkListener;
import org.eclipse.hyades.test.ui.internal.editor.form.base.AbstractSectionForm;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormEngine;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.HyperlinkHandler;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SelectableFormLabel;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.actions.ActionFactory;

public class FormWidgetFactory {
    public static final String KEY_DRAW_BORDER = "FormWidgetFactory.drawBorder";
    public static final String TREE_BORDER = "treeBorder";
    public static final String DEFAULT_HEADER_COLOR = "__default__header__";
    public static final String COLOR_BORDER = "__border";
    public static final String COLOR_COMPOSITE_SEPARATOR = "__compSep";
    private Hashtable colorRegistry = new Hashtable();
    private Color backgroundColor;
    private KeyListener deleteListener;
    protected Color foregroundColor;
    private Display display;
    public static final int BORDER_STYLE = 0;
    private BorderPainter borderPainter;
    protected Color borderColor;
    private HyperlinkHandler hyperlinkHandler;
    VisibilityHandler visibilityHandler;
    KeyboardHandler keyboardHandler;

    public FormWidgetFactory() {
        this(Display.getCurrent());
    }

    public FormWidgetFactory(Display display) {
        this.display = display;
        this.initialize();
    }

    public static ScrolledComposite getScrolledComposite(Control control) {
        Composite composite = control.getParent();
        while (composite != null) {
            if (composite instanceof ScrolledComposite) {
                return (ScrolledComposite)composite;
            }
            composite = composite.getParent();
        }
        return null;
    }

    public static void ensureVisible(Control control) {
        ScrolledComposite scrolledComposite = FormWidgetFactory.getScrolledComposite(control);
        if (scrolledComposite != null) {
            AbstractSectionForm.ensureVisible(scrolledComposite, control);
        }
    }

    public static void processKey(int n, Control control) {
        ScrolledComposite scrolledComposite = FormWidgetFactory.getScrolledComposite(control);
        if (scrolledComposite != null) {
            switch (n) {
                case 0x1000002: {
                    AbstractSectionForm.scrollVertical(scrolledComposite, false);
                    break;
                }
                case 0x1000001: {
                    AbstractSectionForm.scrollVertical(scrolledComposite, true);
                    break;
                }
                case 0x1000003: {
                    AbstractSectionForm.scrollHorizontal(scrolledComposite, true);
                    break;
                }
                case 0x1000004: {
                    AbstractSectionForm.scrollHorizontal(scrolledComposite, false);
                    break;
                }
                case 0x1000005: {
                    AbstractSectionForm.scrollPage(scrolledComposite, true);
                    break;
                }
                case 0x1000006: {
                    AbstractSectionForm.scrollPage(scrolledComposite, false);
                }
            }
        }
    }

    public Button createButton(Composite composite, String string, int n) {
        int n2 = 0x800000;
        Button button = new Button(composite, n | n2);
        button.setBackground(this.backgroundColor);
        button.setForeground(this.foregroundColor);
        if (string != null) {
            button.setText(string);
        }
        button.addFocusListener((FocusListener)this.visibilityHandler);
        return button;
    }

    public Composite createComposite(Composite composite) {
        return this.createComposite(composite, 0);
    }

    public Composite createComposite(Composite composite, int n) {
        Composite composite2 = new Composite(composite, n);
        composite2.setBackground(this.backgroundColor);
        composite2.addMouseListener((MouseListener)new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ((Control)mouseEvent.widget).setFocus();
            }
        });
        composite2.setMenu(composite.getMenu());
        return composite2;
    }

    public Composite createCompositeSeparator(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setBackground(this.getColor(COLOR_COMPOSITE_SEPARATOR));
        return composite2;
    }

    public Label createHeadingLabel(Composite composite, String string) {
        return this.createHeadingLabel(composite, string, null, 0);
    }

    public Label createHeadingLabel(Composite composite, String string, int n) {
        return this.createHeadingLabel(composite, string, null, n);
    }

    public Label createHeadingLabel(Composite composite, String string, Color color) {
        return this.createHeadingLabel(composite, string, color, 0);
    }

    public Label createHeadingLabel(Composite composite, String string, Color color, int n) {
        Label label = new Label(composite, n);
        if (string != null) {
            label.setText(string);
        }
        label.setBackground(this.backgroundColor);
        label.setForeground(this.foregroundColor);
        label.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.bannerfont"));
        return label;
    }

    public Label createHyperlinkLabel(Composite composite, String string, IHyperlinkListener iHyperlinkListener) {
        return this.createHyperlinkLabel(composite, string, iHyperlinkListener, 0);
    }

    public Label createHyperlinkLabel(Composite composite, String string, IHyperlinkListener iHyperlinkListener, int n) {
        Label label = this.createLabel(composite, string, n);
        this.turnIntoHyperlink((Control)label, iHyperlinkListener);
        return label;
    }

    public Label createLabel(Composite composite, String string) {
        return this.createLabel(composite, string, 0);
    }

    public Label createLabel(Composite composite, String string, int n) {
        Label label = new Label(composite, n);
        if (string != null) {
            label.setText(string);
        }
        label.setBackground(this.backgroundColor);
        label.setForeground(this.foregroundColor);
        return label;
    }

    public SelectableFormLabel createSelectableLabel(Composite composite, String string) {
        return this.createSelectableLabel(composite, string, 0);
    }

    public SelectableFormLabel createSelectableLabel(Composite composite, String string, int n) {
        SelectableFormLabel selectableFormLabel = new SelectableFormLabel(composite, n);
        if (string != null) {
            selectableFormLabel.setText(string);
        }
        selectableFormLabel.setBackground(this.backgroundColor);
        selectableFormLabel.setForeground(this.foregroundColor);
        selectableFormLabel.addFocusListener((FocusListener)this.visibilityHandler);
        selectableFormLabel.addKeyListener((KeyListener)this.keyboardHandler);
        return selectableFormLabel;
    }

    public FormEngine createFormEngine(Composite composite) {
        return this.createFormEngine(composite, false);
    }

    public FormEngine createFormEngine(Composite composite, boolean bl) {
        FormEngine formEngine = new FormEngine(composite, 64);
        formEngine.setBackground(this.backgroundColor);
        formEngine.setForeground(this.foregroundColor);
        formEngine.marginWidth = 1;
        formEngine.marginHeight = 0;
        formEngine.setHyperlinkSettings(this.getHyperlinkHandler());
        if (bl) {
            formEngine.addFocusListener((FocusListener)this.visibilityHandler);
        }
        formEngine.addKeyListener((KeyListener)this.keyboardHandler);
        formEngine.setMenu(composite.getMenu());
        return formEngine;
    }

    public Label createSeparator(Composite composite, int n) {
        Label label = new Label(composite, 2 | n);
        label.setBackground(this.backgroundColor);
        label.setForeground(this.borderColor);
        return label;
    }

    public Table createTable(Composite composite, int n) {
        Table table = new Table(composite, 0 | n);
        table.setBackground(this.backgroundColor);
        table.setForeground(this.foregroundColor);
        this.hookDeleteListener((Control)table);
        return table;
    }

    public Text createText(Composite composite, String string) {
        return this.createText(composite, string, 4);
    }

    public Text createText(Composite composite, String string, int n) {
        Text text = new Text(composite, n);
        if (string != null) {
            text.setText(string);
        }
        text.setBackground(this.backgroundColor);
        text.setForeground(this.foregroundColor);
        text.addFocusListener((FocusListener)this.visibilityHandler);
        return text;
    }

    public Tree createTree(Composite composite, int n) {
        Tree tree = new Tree(composite, 0 | n);
        tree.setBackground(this.backgroundColor);
        tree.setForeground(this.foregroundColor);
        this.hookDeleteListener((Control)tree);
        return tree;
    }

    protected void deleteKeyPressed(Widget widget) {
        if (!(widget instanceof Control)) {
            return;
        }
        Control control = (Control)widget;
        Composite composite = control.getParent();
        while (composite != null) {
            if (composite.getData() instanceof FormSection) {
                FormSection formSection = (FormSection)composite.getData();
                formSection.doGlobalAction(ActionFactory.DELETE.getId());
                break;
            }
            composite = composite.getParent();
        }
    }

    public void dispose() {
        Enumeration enumeration = this.colorRegistry.elements();
        while (enumeration.hasMoreElements()) {
            Color color = (Color)enumeration.nextElement();
            color.dispose();
        }
        this.hyperlinkHandler.dispose();
        this.colorRegistry = null;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Cursor getBusyCursor() {
        return this.hyperlinkHandler.getBusyCursor();
    }

    public Color getColor(String string) {
        return (Color)this.colorRegistry.get(string);
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public HyperlinkHandler getHyperlinkHandler() {
        return this.hyperlinkHandler;
    }

    public Cursor getHyperlinkCursor() {
        return this.hyperlinkHandler.getHyperlinkCursor();
    }

    public Color getHyperlinkColor() {
        return this.hyperlinkHandler.getForeground();
    }

    public Color getHyperlinkHoverColor() {
        return this.hyperlinkHandler.getActiveForeground();
    }

    public int getHyperlinkUnderlineMode() {
        return this.hyperlinkHandler.getHyperlinkUnderlineMode();
    }

    public void hookDeleteListener(Control control) {
        if (this.deleteListener == null) {
            this.deleteListener = new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.character == '\u007f' && keyEvent.stateMask == 0) {
                        FormWidgetFactory.this.deleteKeyPressed(keyEvent.widget);
                    }
                }
            };
        }
        control.addKeyListener(this.deleteListener);
    }

    private void initialize() {
        this.backgroundColor = this.display.getSystemColor(25);
        this.registerColor(COLOR_BORDER, 195, 191, 179);
        this.registerColor(COLOR_COMPOSITE_SEPARATOR, 152, 170, 203);
        this.registerColor(DEFAULT_HEADER_COLOR, 72, 112, 152);
        this.borderColor = this.isWhiteBackground() ? this.getColor(COLOR_BORDER) : this.display.getSystemColor(22);
        this.foregroundColor = this.display.getSystemColor(24);
        this.hyperlinkHandler = new HyperlinkHandler();
        this.hyperlinkHandler.setBackground(this.backgroundColor);
        this.updateHyperlinkColors();
        this.visibilityHandler = new VisibilityHandler();
        this.keyboardHandler = new KeyboardHandler();
    }

    public boolean isWhiteBackground() {
        return this.backgroundColor.getRed() == 255 && this.backgroundColor.getGreen() == 255 && this.backgroundColor.getBlue() == 255;
    }

    public void updateHyperlinkColors() {
        Color color = JFaceColors.getHyperlinkText((Display)this.display);
        Color color2 = JFaceColors.getActiveHyperlinkText((Display)this.display);
        this.hyperlinkHandler.setForeground(color);
        this.hyperlinkHandler.setActiveForeground(color2);
    }

    public void paintBordersFor(Composite composite) {
        if (this.borderPainter == null) {
            this.borderPainter = new BorderPainter();
        }
        composite.addPaintListener((PaintListener)this.borderPainter);
    }

    public Color registerColor(String string, int n, int n2, int n3) {
        Color color = new Color((Device)this.display, n, n2, n3);
        this.colorRegistry.put(string, color);
        return color;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public void setHyperlinkColor(Color color) {
        this.hyperlinkHandler.setForeground(color);
    }

    public void setHyperlinkHoverColor(Color color) {
        this.hyperlinkHandler.setActiveForeground(color);
    }

    public void setHyperlinkUnderlineMode(int n) {
        this.hyperlinkHandler.setHyperlinkUnderlineMode(n);
    }

    public void turnIntoHyperlink(Control control, IHyperlinkListener iHyperlinkListener) {
        this.hyperlinkHandler.registerHyperlink(control, iHyperlinkListener);
    }

    class KeyboardHandler
    extends KeyAdapter {
        KeyboardHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            Widget widget = keyEvent.widget;
            if (widget instanceof Control) {
                FormWidgetFactory.processKey(keyEvent.keyCode, (Control)widget);
            }
        }
    }

    class VisibilityHandler
    extends FocusAdapter {
        VisibilityHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            Widget widget = focusEvent.widget;
            if (widget instanceof Control) {
                FormWidgetFactory.ensureVisible((Control)widget);
            }
        }
    }

    class BorderPainter
    implements PaintListener {
        BorderPainter() {
        }

        public void paintControl(PaintEvent paintEvent) {
            Composite composite = (Composite)paintEvent.widget;
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                block10: {
                    GC gC;
                    Rectangle rectangle;
                    boolean bl;
                    Control control;
                    block11: {
                        control = controlArray[n];
                        bl = false;
                        if (!control.getEnabled() && !(control instanceof CCombo) || control instanceof SelectableFormLabel) break block10;
                        Object object = control.getData(FormWidgetFactory.KEY_DRAW_BORDER);
                        if (object == null) break block11;
                        if (object.equals(Boolean.FALSE)) break block10;
                        if (object.equals(FormWidgetFactory.TREE_BORDER)) {
                            bl = true;
                        }
                    }
                    if (!bl && (control instanceof Text || control instanceof Canvas || control instanceof CCombo)) {
                        rectangle = control.getBounds();
                        gC = paintEvent.gc;
                        gC.setForeground(control.getBackground());
                        gC.drawRectangle(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
                        gC.setForeground(FormWidgetFactory.this.foregroundColor);
                        if (control instanceof CCombo) {
                            gC.drawRectangle(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
                        } else {
                            gC.drawRectangle(rectangle.x - 1, rectangle.y - 2, rectangle.width + 1, rectangle.height + 3);
                        }
                    } else if (bl || control instanceof Table || control instanceof Tree || control instanceof TableTree) {
                        rectangle = control.getBounds();
                        gC = paintEvent.gc;
                        gC.setForeground(FormWidgetFactory.this.borderColor);
                        gC.drawRectangle(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
                    }
                }
                ++n;
            }
        }
    }
}

