/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import java.util.Hashtable;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IImageSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.Locator;
import org.eclipse.hyades.test.ui.internal.editor.form.base.ParagraphSegment;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ImageSegment
extends ParagraphSegment
implements IImageSegment {
    private int alignment = 3;
    private String imageId;

    public int getVerticalAlignment() {
        return this.alignment;
    }

    void setVerticalAlignment(int n) {
        this.alignment = n;
    }

    public Image getImage(Hashtable hashtable) {
        if (this.imageId == null) {
            return null;
        }
        Object v = hashtable.get(this.imageId);
        if (v == null) {
            return null;
        }
        if (v instanceof Image) {
            return (Image)v;
        }
        return null;
    }

    public String getObjectId() {
        return this.imageId;
    }

    void setObjectId(String string) {
        this.imageId = string;
    }

    public void advanceLocator(GC gC, int n, Locator locator, Hashtable hashtable) {
        Image image = this.getImage(hashtable);
        int n2 = 0;
        int n3 = 0;
        if (image != null) {
            Rectangle rectangle = image.getBounds();
            n2 = rectangle.width;
            n3 = rectangle.height;
        }
        if (n != -1 && locator.x + n2 > n) {
            locator.width = locator.x = locator.indent + n2;
            locator.y += locator.rowHeight;
            locator.rowHeight = n3;
        } else {
            locator.x += n2;
            locator.rowHeight = Math.max(locator.rowHeight, n3);
        }
    }

    public void paint(GC gC, int n, Locator locator, Hashtable hashtable, boolean bl) {
        Image image = this.getImage(hashtable);
        int n2 = 0;
        int n3 = 0;
        if (image == null) {
            return;
        }
        Rectangle rectangle = image.getBounds();
        n2 = rectangle.width;
        n3 = rectangle.height;
        locator.width = n2;
        locator.height = n3;
        int n4 = locator.x;
        int n5 = locator.y;
        if (n4 + n2 > n) {
            n4 = locator.indent + locator.marginWidth;
            n5 += locator.rowHeight;
            locator.rowHeight = 0;
        }
        gC.drawImage(image, n4, n5);
        locator.x = n4 + n2;
        locator.y = n5;
        locator.rowHeight = Math.max(locator.rowHeight, n3);
    }
}

