/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.hyades.test.ui.editor.form.base.IHyperlinkListener;
import org.eclipse.hyades.test.ui.internal.editor.form.base.BulletParagraph;
import org.eclipse.hyades.test.ui.internal.editor.form.base.HyperlinkSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.HyperlinkSettings;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IParagraph;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IParagraphSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.ITextModel;
import org.eclipse.hyades.test.ui.internal.editor.form.base.ITextSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.ImageSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.Paragraph;
import org.eclipse.xsd.util.XSDParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TextModel
implements ITextModel {
    Vector paragraphs;
    IHyperlinkListener urlListener;
    IHyperlinkSegment[] hyperlinks;
    int selectedLinkIndex = -1;
    HyperlinkSettings hyperlinkSettings;

    public TextModel() {
        this.reset();
    }

    public IParagraph[] getParagraphs() {
        if (this.paragraphs == null) {
            return new IParagraph[0];
        }
        return this.paragraphs.toArray(new IParagraph[this.paragraphs.size()]);
    }

    public String getAccessibleText() {
        if (this.paragraphs == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.paragraphs.size()) {
            IParagraph iParagraph = (IParagraph)this.paragraphs.get(n);
            String string = iParagraph.getAccessibleText();
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public void parseTaggedText(String string, boolean bl) throws CoreException {
        if (string == null) {
            this.reset();
            return;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF8"));
            this.parseInputStream(byteArrayInputStream, bl);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    public void parseInputStream(InputStream inputStream, boolean bl) throws CoreException {
        XSDParser xSDParser = new XSDParser();
        this.reset();
        InputSource inputSource = new InputSource(inputStream);
        xSDParser.parse(inputSource);
        this.processDocument(xSDParser.getDocument(), bl);
    }

    private void processDocument(Document document, boolean bl) {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            IParagraph iParagraph;
            String string;
            Node node = nodeList.item(n);
            if (node.getNodeType() == 3) {
                string = node.getNodeValue();
                if (string != null && !this.isIgnorableWhiteSpace(string, true)) {
                    iParagraph = new Paragraph(true);
                    iParagraph.parseRegularText(string, bl, this.getHyperlinkSettings(), null);
                    this.paragraphs.add(iParagraph);
                }
            } else if (node.getNodeType() == 1) {
                string = node.getNodeName().toLowerCase();
                if (string.equals("p")) {
                    iParagraph = this.processParagraph(node, bl);
                    if (iParagraph != null) {
                        this.paragraphs.add(iParagraph);
                    }
                } else if (string.equals("li") && (iParagraph = this.processListItem(node, bl)) != null) {
                    this.paragraphs.add(iParagraph);
                }
            }
            ++n;
        }
    }

    private IParagraph processParagraph(Node node, boolean bl) {
        Object object;
        NodeList nodeList = node.getChildNodes();
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("addVerticalSpace");
        boolean bl2 = true;
        if (node2 != null) {
            object = node2.getNodeValue();
            bl2 = ((String)object).equalsIgnoreCase("true");
        }
        object = new Paragraph(bl2);
        this.processSegments((Paragraph)object, nodeList, bl);
        return object;
    }

    private IParagraph processListItem(Node node, boolean bl) {
        Object object;
        NodeList nodeList = node.getChildNodes();
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("addVerticalSpace");
        Node node3 = namedNodeMap.getNamedItem("style");
        Node node4 = namedNodeMap.getNamedItem("value");
        Node node5 = namedNodeMap.getNamedItem("indent");
        int n = 0;
        int n2 = -1;
        String string = null;
        boolean bl2 = true;
        if (node2 != null) {
            object = node2.getNodeValue();
            bl2 = ((String)object).equalsIgnoreCase("true");
        }
        if (node3 != null) {
            object = node3.getNodeValue();
            if (((String)object).equalsIgnoreCase("text")) {
                n = 1;
            } else if (((String)object).equalsIgnoreCase("image")) {
                n = 2;
            }
        }
        if (node4 != null) {
            string = node4.getNodeValue();
        }
        if (node5 != null) {
            object = node5.getNodeValue();
            try {
                n2 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        object = new BulletParagraph(bl2);
        ((BulletParagraph)object).setIndent(n2);
        ((BulletParagraph)object).setBulletStyle(n);
        ((BulletParagraph)object).setBulletText(string);
        this.processSegments((Paragraph)object, nodeList, bl);
        return object;
    }

    private void processSegments(Paragraph paragraph, NodeList nodeList, boolean bl) {
        int n = 0;
        while (n < nodeList.getLength()) {
            String string;
            Node node = nodeList.item(n);
            IParagraphSegment iParagraphSegment = null;
            if (node.getNodeType() == 3) {
                string = node.getNodeValue();
                if (string != null && !this.isIgnorableWhiteSpace(string, false)) {
                    paragraph.parseRegularText(string, bl, this.getHyperlinkSettings(), null);
                }
            } else if (node.getNodeType() == 1) {
                string = node.getNodeName();
                if (string.equalsIgnoreCase("img")) {
                    iParagraphSegment = this.processImageSegment(node);
                } else if (string.equalsIgnoreCase("a")) {
                    iParagraphSegment = this.processHyperlinkSegment(node, this.getHyperlinkSettings());
                } else if (string.equalsIgnoreCase("text")) {
                    this.processTextSegment(paragraph, bl, node);
                } else if (string.equalsIgnoreCase("b")) {
                    String string2 = this.getNodeText(node).trim();
                    String string3 = "org.eclipse.jface.bannerfont";
                    paragraph.parseRegularText(string2, bl, this.getHyperlinkSettings(), string3);
                }
            }
            if (iParagraphSegment != null) {
                paragraph.addSegment(iParagraphSegment);
            }
            ++n;
        }
    }

    private boolean isIgnorableWhiteSpace(String string, boolean bl) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!(bl && c == ' ' || c == '\n' || c == '\r' || c == '\f')) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private IParagraphSegment processImageSegment(Node node) {
        String string;
        ImageSegment imageSegment = new ImageSegment();
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("href");
        Node node3 = namedNodeMap.getNamedItem("align");
        if (node2 != null) {
            string = node2.getNodeValue();
            imageSegment.setObjectId(string);
        }
        if (node3 != null) {
            string = node3.getNodeValue().toLowerCase();
            if (string.equals("top")) {
                imageSegment.setVerticalAlignment(1);
            } else if (string.equals("middle")) {
                imageSegment.setVerticalAlignment(2);
            } else if (string.equals("bottom")) {
                imageSegment.setVerticalAlignment(3);
            }
        }
        return imageSegment;
    }

    private String getNodeText(Node node) {
        NodeList nodeList = node.getChildNodes();
        String string = "";
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeType() == 3) {
                string = string + node2.getNodeValue();
            }
            ++n;
        }
        return string;
    }

    private IParagraphSegment processHyperlinkSegment(Node node, HyperlinkSettings hyperlinkSettings) {
        Object object;
        String string = this.getNodeText(node);
        HyperlinkSegment hyperlinkSegment = new HyperlinkSegment(string, hyperlinkSettings, null);
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("href");
        if (node2 != null) {
            object = node2.getNodeValue();
            hyperlinkSegment.setActionId((String)object);
        }
        if ((object = namedNodeMap.getNamedItem("arg")) != null) {
            String string2 = object.getNodeValue();
            hyperlinkSegment.setArg(string2);
        }
        return hyperlinkSegment;
    }

    private void processTextSegment(Paragraph paragraph, boolean bl, Node node) {
        String string = this.getNodeText(node).trim();
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("font");
        String string2 = null;
        if (node2 != null) {
            string2 = node2.getNodeValue();
        }
        paragraph.parseRegularText(string, bl, this.getHyperlinkSettings(), string2);
    }

    public void parseRegularText(String string, boolean bl) throws CoreException {
        this.reset();
        if (string == null) {
            return;
        }
        Paragraph paragraph = new Paragraph(true);
        this.paragraphs.add(paragraph);
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (paragraph == null) {
                paragraph = new Paragraph(true);
                this.paragraphs.add(paragraph);
            }
            if (c == '\n') {
                String string2 = string.substring(n, n2);
                n = n2 + 1;
                paragraph.parseRegularText(string2, bl, this.getHyperlinkSettings(), null);
                paragraph = null;
            }
            ++n2;
        }
        if (paragraph != null) {
            String string3 = string.substring(n);
            paragraph.parseRegularText(string3, bl, this.getHyperlinkSettings(), null);
        }
    }

    public HyperlinkSettings getHyperlinkSettings() {
        if (this.hyperlinkSettings == null) {
            this.hyperlinkSettings = new LocalHyperlinkSettings();
        }
        return this.hyperlinkSettings;
    }

    public void setHyperlinkSettings(HyperlinkSettings hyperlinkSettings) {
        this.hyperlinkSettings = hyperlinkSettings;
    }

    public void setURLListener(IHyperlinkListener iHyperlinkListener) {
        this.urlListener = iHyperlinkListener;
    }

    private void reset() {
        if (this.paragraphs == null) {
            this.paragraphs = new Vector();
        }
        this.paragraphs.clear();
        this.selectedLinkIndex = -1;
        this.hyperlinks = null;
    }

    IHyperlinkSegment[] getHyperlinks() {
        if (this.hyperlinks != null || this.paragraphs == null) {
            return this.hyperlinks;
        }
        Vector<IParagraphSegment> vector = new Vector<IParagraphSegment>();
        int n = 0;
        while (n < this.paragraphs.size()) {
            IParagraph iParagraph = (IParagraph)this.paragraphs.get(n);
            IParagraphSegment[] iParagraphSegmentArray = iParagraph.getSegments();
            int n2 = 0;
            while (n2 < iParagraphSegmentArray.length) {
                if (iParagraphSegmentArray[n2] instanceof IHyperlinkSegment) {
                    vector.add(iParagraphSegmentArray[n2]);
                }
                ++n2;
            }
            ++n;
        }
        this.hyperlinks = vector.toArray(new IHyperlinkSegment[vector.size()]);
        return this.hyperlinks;
    }

    public IHyperlinkSegment findHyperlinkAt(int n, int n2) {
        IHyperlinkSegment[] iHyperlinkSegmentArray = this.getHyperlinks();
        int n3 = 0;
        while (n3 < iHyperlinkSegmentArray.length) {
            if (iHyperlinkSegmentArray[n3].contains(n, n2)) {
                return iHyperlinkSegmentArray[n3];
            }
            ++n3;
        }
        return null;
    }

    public ITextSegment findSegmentAt(int n, int n2) {
        int n3 = 0;
        while (n3 < this.paragraphs.size()) {
            IParagraph iParagraph = (IParagraph)this.paragraphs.get(n3);
            ITextSegment iTextSegment = iParagraph.findSegmentAt(n, n2);
            if (iTextSegment != null) {
                return iTextSegment;
            }
            ++n3;
        }
        return null;
    }

    public IHyperlinkSegment getSelectedLink() {
        if (this.selectedLinkIndex == -1) {
            return null;
        }
        return this.hyperlinks[this.selectedLinkIndex];
    }

    public boolean traverseLinks(boolean bl) {
        IHyperlinkSegment[] iHyperlinkSegmentArray = this.getHyperlinks();
        if (iHyperlinkSegmentArray == null) {
            return false;
        }
        int n = iHyperlinkSegmentArray.length;
        this.selectedLinkIndex = bl ? ++this.selectedLinkIndex : --this.selectedLinkIndex;
        if (this.selectedLinkIndex < 0 || this.selectedLinkIndex > n - 1) {
            this.selectedLinkIndex = -1;
        }
        return this.selectedLinkIndex != -1;
    }

    public void selectLink(IHyperlinkSegment iHyperlinkSegment) {
        if (iHyperlinkSegment == null) {
            this.selectedLinkIndex = -1;
        } else {
            IHyperlinkSegment[] iHyperlinkSegmentArray = this.getHyperlinks();
            this.selectedLinkIndex = -1;
            if (iHyperlinkSegmentArray == null) {
                return;
            }
            int n = 0;
            while (n < iHyperlinkSegmentArray.length) {
                if (iHyperlinkSegmentArray[n].equals(iHyperlinkSegment)) {
                    this.selectedLinkIndex = n;
                    break;
                }
                ++n;
            }
        }
    }

    public boolean hasFocusSegments() {
        IHyperlinkSegment[] iHyperlinkSegmentArray = this.getHyperlinks();
        return iHyperlinkSegmentArray.length > 0;
    }

    public void dispose() {
        if (this.hyperlinkSettings instanceof LocalHyperlinkSettings) {
            this.hyperlinkSettings.dispose();
        }
    }

    class LocalHyperlinkSettings
    extends HyperlinkSettings {
        LocalHyperlinkSettings() {
        }
    }
}

