/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.test.ui.editor.form.util.EObjectContainerContentProvider;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class EObjectTableContentProvider
extends EObjectContainerContentProvider {
    public EObjectTableContentProvider(EditorForm editorForm, EStructuralFeature eStructuralFeature) {
        super(editorForm, eStructuralFeature);
    }

    public TableViewer getTableViewer() {
        Viewer viewer = super.getViewer();
        if (viewer instanceof TableViewer) {
            return (TableViewer)viewer;
        }
        return null;
    }

    protected void updateViewer(Notification notification) {
        if (this.getViewer() == null) {
            return;
        }
        if (!(this.getViewer() instanceof StructuredViewer)) {
            this.getViewer().refresh();
            return;
        }
        if (notification.getNotifier() != this.getContainer()) {
            switch (notification.getEventType()) {
                case 1: 
                case 2: {
                    this.attributeChanged(notification);
                    return;
                }
            }
        }
        if (!(this.getViewer() instanceof TableViewer)) {
            this.getViewer().refresh();
            return;
        }
        if (this.shouldUpdateViewer(notification)) {
            this.updateViewerWithNotification(notification);
        }
    }

    protected void updateViewerWithNotification(Notification notification) {
        switch (notification.getEventType()) {
            case 3: {
                ((TableViewer)this.getViewer()).add(notification.getNewValue());
                this.getViewer().setSelection((ISelection)new StructuredSelection(notification.getNewValue()), true);
                break;
            }
            case 5: {
                Object[] objectArray = ((Collection)notification.getNewValue()).toArray();
                ((TableViewer)this.getViewer()).add(objectArray);
                this.getViewer().setSelection((ISelection)new StructuredSelection(objectArray), true);
                break;
            }
            case 4: {
                ((TableViewer)this.getViewer()).remove(notification.getOldValue());
                Object object = ((EObject)notification.getNotifier()).eGet((EStructuralFeature)notification.getFeature());
                if (object instanceof List) {
                    List list = (List)object;
                    if (list.isEmpty()) {
                        this.getViewer().getControl().setFocus();
                        break;
                    }
                    int n = notification.getPosition();
                    n = n < list.size() ? n : list.size() - 1;
                    this.getViewer().setSelection((ISelection)new StructuredSelection(list.get(n)), true);
                    break;
                }
                this.getViewer().getControl().setFocus();
                break;
            }
            case 6: {
                ((TableViewer)this.getViewer()).remove(((Collection)notification.getOldValue()).toArray());
                this.getViewer().getControl().setFocus();
                break;
            }
            case 7: {
                this.getViewer().refresh();
            }
        }
    }
}

