/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.StructuredViewerPart;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EObjectTableContentProvider;
import org.eclipse.hyades.test.ui.internal.editor.form.util.StructuredViewerSection;
import org.eclipse.hyades.test.ui.internal.model.ui.ChildrenSelectionAction;
import org.eclipse.hyades.ui.internal.provider.WorkbenchAdapterLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.actions.SelectionListenerAction;

public class ExtensibleEObjectTableSection
extends StructuredViewerSection
implements ISelectionChangedListener,
IDoubleClickListener {
    private int tableStyle = 65538;
    private int numColumns;
    private IAction[] buttonActions;
    private EditorForm editorForm;
    private EStructuralFeature eStructuralFeature;
    private IContentProvider tableContentProvider;
    private ITableLabelProvider tableLabelProvider;
    static /* synthetic */ Class class$org$eclipse$hyades$test$ui$adapter$TestWorkbenchAdapter;

    public ExtensibleEObjectTableSection(EditorForm editorForm, EStructuralFeature eStructuralFeature, int n, IAction[] iActionArray) {
        super(editorForm);
        this.editorForm = editorForm;
        this.eStructuralFeature = eStructuralFeature;
        this.numColumns = n;
        this.buttonActions = iActionArray;
        String[] stringArray = new String[this.buttonActions.length];
        int n2 = 0;
        while (n2 < this.buttonActions.length) {
            stringArray[n2] = this.buttonActions[n2].getText();
            ++n2;
        }
        super.setButtonLabels(stringArray);
    }

    public void dispose() {
        this.eStructuralFeature = null;
        int n = 0;
        while (n < this.buttonActions.length) {
            if (this.buttonActions[n] != null) {
                this.buttonActions[n] = null;
            }
            ++n;
        }
        super.dispose();
    }

    protected StructuredViewerPart createViewerPart(String[] stringArray) {
        StructuredViewerPart structuredViewerPart = new StructuredViewerPart(stringArray){

            protected StructuredViewer createStructuredViewer(Composite composite, int n, FormWidgetFactory formWidgetFactory) {
                TableColumn tableColumn;
                Table table = new Table(composite, n);
                table.setLinesVisible(true);
                table.setHeaderVisible(false);
                int n2 = 0;
                while (n2 < ExtensibleEObjectTableSection.this.numColumns) {
                    tableColumn = new TableColumn(table, 0);
                    tableColumn.setResizable(true);
                    ++n2;
                }
                table.addControlListener(new ControlListener(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void controlMoved(ControlEvent controlEvent) {
                    }

                    public void controlResized(ControlEvent controlEvent) {
                        if (controlEvent.getSource() instanceof Table) {
                            Table table = (Table)controlEvent.getSource();
                            int n = table.getSize().x;
                            int n2 = table.getGridLineWidth();
                            TableColumn[] tableColumnArray = table.getColumns();
                            if (tableColumnArray.length == 3) {
                                tableColumnArray[0].setWidth(n * 2 / 5);
                                tableColumnArray[1].setWidth(n / 5);
                                tableColumnArray[2].setWidth(n * 2 / 5 + n2);
                            } else {
                                int n3 = 0;
                                while (n3 < tableColumnArray.length) {
                                    tableColumnArray[n3].setWidth(n / tableColumnArray.length);
                                    ++n3;
                                }
                            }
                        }
                    }
                });
                composite.pack();
                tableColumn = new TableViewer(table);
                tableColumn.addSelectionChangedListener((ISelectionChangedListener)ExtensibleEObjectTableSection.this);
                tableColumn.addDoubleClickListener((IDoubleClickListener)ExtensibleEObjectTableSection.this);
                return tableColumn;
            }

            public void buttonSelected(Button button, int n) {
                ExtensibleEObjectTableSection.this.buttonSelected(n);
                if (ExtensibleEObjectTableSection.this.isHandlingDefaultButton()) {
                    button.getShell().setDefaultButton(null);
                }
            }
        };
        return structuredViewerPart;
    }

    protected void buttonSelected(int n) {
        if (!this.isReadOnly() && n >= 0 && n < this.buttonActions.length) {
            this.buttonActions[n].run();
        }
        this.updateActionsAndButtons(this.getStructuredSelection());
    }

    public Composite createClient(Composite composite, FormWidgetFactory formWidgetFactory) {
        this.setFormWidgetFactory(formWidgetFactory);
        Composite composite2 = this.createClientContainer(composite, 2, this.getFormWidgetFactory());
        this.createViewerPartControl(composite2, this.getTableStyle(), 2, this.getFormWidgetFactory());
        this.getTableViewer().getControl().setFocus();
        this.adjustClient(composite);
        this.getFormWidgetFactory().paintBordersFor(composite2);
        return composite2;
    }

    protected void adjustClient(Composite composite) {
        this.getTableViewer().setContentProvider(this.getContentProvider());
        this.getTableViewer().setLabelProvider(this.getLabelProvider());
        int n = 0;
        while (n < this.buttonActions.length) {
            if (this.buttonActions[n] != null) {
                this.getTablePart().setButtonEnabled(n, this.buttonActions[n].isEnabled());
                if (this.buttonActions[n] instanceof ChildrenSelectionAction) {
                    ((ChildrenSelectionAction)this.buttonActions[n]).setStructuredViewer((StructuredViewer)this.getTableViewer());
                }
            }
            ++n;
        }
    }

    protected void updateActionsAndButtons(IStructuredSelection iStructuredSelection) {
        if (this.buttonActions == null || this.buttonActions.length < 1) {
            return;
        }
        int n = 0;
        while (n < this.buttonActions.length) {
            if (this.buttonActions[n] != null) {
                if (this.buttonActions[n] instanceof SelectionListenerAction) {
                    ((SelectionListenerAction)this.buttonActions[n]).selectionChanged(iStructuredSelection);
                }
                this.getTablePart().setButtonEnabled(n, this.buttonActions[n].isEnabled());
            }
            ++n;
        }
    }

    public void setContentProvider(IContentProvider iContentProvider) {
        this.tableContentProvider = iContentProvider;
    }

    protected IContentProvider getContentProvider() {
        if (this.tableContentProvider == null) {
            this.tableContentProvider = new EObjectTableContentProvider(this.editorForm, this.eStructuralFeature);
        }
        return this.tableContentProvider;
    }

    protected EStructuralFeature getEStructuralFeature() {
        return this.eStructuralFeature;
    }

    public IBaseLabelProvider getLabelProvider() {
        if (this.tableLabelProvider == null) {
            return new WorkbenchAdapterLabelProvider(class$org$eclipse$hyades$test$ui$adapter$TestWorkbenchAdapter == null ? (class$org$eclipse$hyades$test$ui$adapter$TestWorkbenchAdapter = ExtensibleEObjectTableSection.class$("org.eclipse.hyades.test.ui.adapter.TestWorkbenchAdapter")) : class$org$eclipse$hyades$test$ui$adapter$TestWorkbenchAdapter);
        }
        return this.tableLabelProvider;
    }

    public void setLabelProvider(ITableLabelProvider iTableLabelProvider) {
        this.tableLabelProvider = iTableLabelProvider;
    }

    public void setTableStryle(int n) {
        this.tableStyle = n;
    }

    public int getTableStyle() {
        return this.tableStyle;
    }

    public StructuredViewerPart getTablePart() {
        return this.getViewerPart();
    }

    public TableViewer getTableViewer() {
        return (TableViewer)this.getTablePart().getViewer();
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.selectionChanged((IStructuredSelection)selectionChangedEvent.getSelection());
    }

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        this.handleDoubleClick((IStructuredSelection)doubleClickEvent.getSelection());
    }

    public String getColumnText(Object object, int n) {
        return object.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

