/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.extensions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.launch.extensions.IDeploymentsProvider;

public class DefaultDeploymentsProvider
implements IDeploymentsProvider {
    private Object theTestElement;
    private List deploymentsList;

    private void findDeployments(Object object) {
        IFile iFile;
        if (object instanceof IContainer) {
            IContainer iContainer = (IContainer)object;
            try {
                IResource[] iResourceArray = iContainer.members();
                int n = 0;
                while (n < iResourceArray.length) {
                    this.findDeployments(iResourceArray[n]);
                    ++n;
                }
            }
            catch (CoreException coreException) {
                TestUIPlugin.logError(coreException);
            }
        } else if (object instanceof IFile && "deploy".equals((iFile = (IFile)object).getFileExtension())) {
            EObject[] eObjectArray = EMFUtil.load(null, iFile);
            int n = 0;
            while (n < eObjectArray.length) {
                if (eObjectArray[n] instanceof TPFDeployment) {
                    this.deploymentsList.add(eObjectArray[n]);
                }
                ++n;
            }
        }
    }

    public TPFDeployment[] getDeployments(Object object) {
        this.deploymentsList = new ArrayList();
        if (object instanceof TPFTestSuite || object instanceof TPFTestComponent) {
            this.theTestElement = object;
        } else if (object instanceof TPFTestCase) {
            this.theTestElement = ((TPFTestCase)object).getTestSuite();
        }
        this.findDeployments(ResourcesPlugin.getWorkspace().getRoot());
        TPFDeployment[] tPFDeploymentArray = new TPFDeployment[this.deploymentsList.size()];
        return this.deploymentsList.toArray(tPFDeploymentArray);
    }

    public TPFDeployment getDefaultDeployment(Object object) {
        TPFDeployment[] tPFDeploymentArray = this.getDeployments(object);
        if (tPFDeploymentArray.length > 0) {
            return tPFDeploymentArray[0];
        }
        return null;
    }
}

