/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.launch.extensions.DefaultDeploymentsProvider;
import org.eclipse.hyades.test.ui.internal.launch.extensions.DefaultExecutionHistoryDefaultsProvider;
import org.eclipse.hyades.test.ui.launch.extensions.IDeploymentsProvider;
import org.eclipse.hyades.test.ui.launch.extensions.IExecutionHistoryDefaultsProvider;
import org.eclipse.hyades.test.ui.launch.extensions.IRunHandler;

public class LaunchConfigurationExtensionsManager {
    private static LaunchConfigurationExtensionsManager instance;
    private static final String KIND_TEST = "test";
    private static final String KIND_COMPONENT = "testComponent";
    private Map testExtensionMap = new HashMap();
    private Map componentExtensionMap = new HashMap();
    private IDeploymentsProvider defaultDeploymentsProvider = new DefaultDeploymentsProvider();
    private IExecutionHistoryDefaultsProvider defaultExecutionHistoryDefaultsProvider = new DefaultExecutionHistoryDefaultsProvider();

    public static LaunchConfigurationExtensionsManager getInstance() {
        if (instance == null) {
            instance = new LaunchConfigurationExtensionsManager();
        }
        return instance;
    }

    private LaunchConfigurationExtensionsManager() {
        this.registerRunHandlers();
        this.registerDeploymentsProviders();
        this.registerExecutionHistoryDefaultsProviders();
        this.registerSupportedTestTypes();
    }

    private ExtensionDescriptor getExtensionDescriptor(String string, String string2) {
        Assert.isNotNull((Object)string2);
        Assert.isNotNull((Object)string);
        Map map = null;
        if (string2.equals(KIND_TEST)) {
            map = this.testExtensionMap;
        } else if (string2.equals(KIND_COMPONENT)) {
            map = this.componentExtensionMap;
        } else {
            throw new IllegalArgumentException("Invalid kind");
        }
        Assert.isNotNull((Object)map);
        Object object = map.get(string);
        if (object == null) {
            object = new ExtensionDescriptor();
            map.put(string, object);
        }
        return (ExtensionDescriptor)object;
    }

    private ExtensionDescriptor getExtensionDescriptor(Object object) {
        if (object != null) {
            TPFTestComponent tPFTestComponent;
            if (object instanceof TPFTest) {
                TPFTest tPFTest = (TPFTest)object;
                if (tPFTest.getType() != null) {
                    return this.getExtensionDescriptor(tPFTest.getType(), KIND_TEST);
                }
            } else if (object instanceof TPFTestComponent && (tPFTestComponent = (TPFTestComponent)object).getType() != null) {
                return this.getExtensionDescriptor(tPFTestComponent.getType(), KIND_COMPONENT);
            }
        }
        return null;
    }

    private void registerRunHandlers() {
        IExtensionPoint iExtensionPoint = Platform.getPluginRegistry().getExtensionPoint(TestUIPlugin.getID() + ".runHandler");
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray[n].getChildren();
                int n2 = 0;
                while (n2 < iConfigurationElementArray2.length) {
                    String string = iConfigurationElementArray2[n2].getAttribute("type");
                    String string2 = iConfigurationElementArray2[n2].getAttribute("kind");
                    try {
                        ExtensionDescriptor extensionDescriptor = this.getExtensionDescriptor(string, string2);
                        extensionDescriptor.runHandlerConfigElem = iConfigurationElementArray[n];
                    }
                    catch (Exception exception) {
                        TestUIPlugin.logError("Extension " + iConfigurationElementArray[n].getName() + " was ignored. See next messages for details.");
                        TestUIPlugin.logError(exception);
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    private void registerExecutionHistoryDefaultsProviders() {
        IExtensionPoint iExtensionPoint = Platform.getPluginRegistry().getExtensionPoint(TestUIPlugin.getID() + ".executionHistoryDefaults");
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray[n].getChildren();
                int n2 = 0;
                while (n2 < iConfigurationElementArray2.length) {
                    String string = iConfigurationElementArray2[n2].getAttribute("type");
                    String string2 = iConfigurationElementArray2[n2].getAttribute("kind");
                    try {
                        ExtensionDescriptor extensionDescriptor = this.getExtensionDescriptor(string, string2);
                        extensionDescriptor.execHistoryDefaultsProviderConfigElem = iConfigurationElementArray[n];
                    }
                    catch (Exception exception) {
                        TestUIPlugin.logError("Extension " + iConfigurationElementArray[n].getName() + " was ignored. See next messages for details.");
                        TestUIPlugin.logError(exception);
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    private void registerDeploymentsProviders() {
        IExtensionPoint iExtensionPoint = Platform.getPluginRegistry().getExtensionPoint(TestUIPlugin.getID() + ".deploymentProvider");
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray[n].getChildren();
                int n2 = 0;
                while (n2 < iConfigurationElementArray2.length) {
                    String string = iConfigurationElementArray2[n2].getAttribute("type");
                    String string2 = iConfigurationElementArray2[n2].getAttribute("kind");
                    try {
                        ExtensionDescriptor extensionDescriptor = this.getExtensionDescriptor(string, string2);
                        extensionDescriptor.deploymentsProviderConfigElem = iConfigurationElementArray[n];
                    }
                    catch (Exception exception) {
                        TestUIPlugin.logError("Extension " + iConfigurationElementArray[n].getName() + " was ignored. See next messages for details.");
                        TestUIPlugin.logError(exception);
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    private void registerSupportedTestTypes() {
        IExtensionPoint iExtensionPoint = Platform.getPluginRegistry().getExtensionPoint(TestUIPlugin.getID() + ".launchableType");
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                String string = iConfigurationElementArray[n].getAttribute("type");
                String string2 = iConfigurationElementArray[n].getAttribute("kind");
                String string3 = iConfigurationElementArray[n].getAttribute("launchConfigurationType");
                try {
                    ExtensionDescriptor extensionDescriptor = this.getExtensionDescriptor(string, string2);
                    extensionDescriptor.launchConfigurationType = string3;
                    IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray[n].getChildren();
                    int n2 = 0;
                    while (n2 < iConfigurationElementArray2.length) {
                        String string4 = iConfigurationElementArray2[n2].getAttribute("mode");
                        boolean bl = "true".equals(iConfigurationElementArray2[n2].getAttribute("shortcutAvailable"));
                        extensionDescriptor.supportedLaunchModes.add(string4);
                        if (bl) {
                            extensionDescriptor.availableShortcutModes.add(string4);
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    TestUIPlugin.logError("Extension " + iConfigurationElementArray[n].getName() + " was ignored. See next messages for details.");
                    TestUIPlugin.logError(exception);
                }
                ++n;
            }
        }
    }

    public IRunHandler getRunHandler(Object object) {
        ExtensionDescriptor extensionDescriptor = this.getExtensionDescriptor(object);
        if (extensionDescriptor != null) {
            return extensionDescriptor.getRunHandler();
        }
        return null;
    }

    public IExecutionHistoryDefaultsProvider getExecutionHistoryDefaultsProvider(Object object) {
        IExecutionHistoryDefaultsProvider iExecutionHistoryDefaultsProvider = null;
        ExtensionDescriptor extensionDescriptor = this.getExtensionDescriptor(object);
        if (extensionDescriptor != null) {
            iExecutionHistoryDefaultsProvider = extensionDescriptor.getExecutionHistoryDefaultsProvider();
        }
        if (iExecutionHistoryDefaultsProvider == null) {
            iExecutionHistoryDefaultsProvider = this.defaultExecutionHistoryDefaultsProvider;
        }
        return iExecutionHistoryDefaultsProvider;
    }

    public IDeploymentsProvider getDeploymentsProvider(Object object) {
        IDeploymentsProvider iDeploymentsProvider = null;
        ExtensionDescriptor extensionDescriptor = this.getExtensionDescriptor(object);
        if (extensionDescriptor != null) {
            iDeploymentsProvider = extensionDescriptor.getDeploymentsProvider();
        }
        if (iDeploymentsProvider == null) {
            iDeploymentsProvider = this.defaultDeploymentsProvider;
        }
        return iDeploymentsProvider;
    }

    public boolean isLaunchableElement(Object object, String string, String string2) {
        ExtensionDescriptor extensionDescriptor = this.getExtensionDescriptor(object);
        if (extensionDescriptor != null) {
            return extensionDescriptor.isLaunchConfigurationTypeSupported(string2) && extensionDescriptor.supportedLaunchModes.contains(string);
        }
        return false;
    }

    public boolean isShortcutAvailable(Object object, String string) {
        ExtensionDescriptor extensionDescriptor = this.getExtensionDescriptor(object);
        if (extensionDescriptor != null) {
            return extensionDescriptor.launchConfigurationType == null && extensionDescriptor.availableShortcutModes.contains(string);
        }
        return false;
    }

    public IExecutionHistoryDefaultsProvider getDefaultExecutionHistoryDefaultsProvider() {
        return this.defaultExecutionHistoryDefaultsProvider;
    }

    public IDeploymentsProvider getDefaultDeploymentsProvider() {
        return this.defaultDeploymentsProvider;
    }

    private class ExtensionDescriptor {
        public IConfigurationElement runHandlerConfigElem = null;
        private IRunHandler runHandler = null;
        public List supportedLaunchModes = new ArrayList(3);
        public List availableShortcutModes = new ArrayList(3);
        public String launchConfigurationType = null;
        public IConfigurationElement execHistoryDefaultsProviderConfigElem = null;
        private IExecutionHistoryDefaultsProvider execHistoryDefaultsProvider = null;
        public IConfigurationElement deploymentsProviderConfigElem = null;
        private IDeploymentsProvider deploymentsProvider = null;

        private ExtensionDescriptor() {
        }

        public IRunHandler getRunHandler() {
            block2: {
                if (this.runHandler != null || this.runHandlerConfigElem == null) break block2;
                try {
                    this.runHandler = (IRunHandler)this.runHandlerConfigElem.createExecutableExtension("class");
                }
                catch (CoreException coreException) {
                    TestUIPlugin.logError(coreException);
                    this.runHandlerConfigElem = null;
                }
            }
            return this.runHandler;
        }

        public IExecutionHistoryDefaultsProvider getExecutionHistoryDefaultsProvider() {
            block2: {
                if (this.execHistoryDefaultsProvider != null || this.execHistoryDefaultsProviderConfigElem == null) break block2;
                try {
                    this.execHistoryDefaultsProvider = (IExecutionHistoryDefaultsProvider)this.execHistoryDefaultsProviderConfigElem.createExecutableExtension("class");
                }
                catch (CoreException coreException) {
                    TestUIPlugin.logError(coreException);
                    this.execHistoryDefaultsProviderConfigElem = null;
                }
            }
            return this.execHistoryDefaultsProvider;
        }

        public IDeploymentsProvider getDeploymentsProvider() {
            block2: {
                if (this.deploymentsProvider != null || this.deploymentsProviderConfigElem == null) break block2;
                try {
                    this.deploymentsProvider = (IDeploymentsProvider)this.deploymentsProviderConfigElem.createExecutableExtension("class");
                }
                catch (CoreException coreException) {
                    TestUIPlugin.logError(coreException);
                    this.deploymentsProviderConfigElem = null;
                }
            }
            return this.deploymentsProvider;
        }

        public boolean isLaunchConfigurationTypeSupported(String string) {
            return this.launchConfigurationType == string || string != null && string.equals(this.launchConfigurationType);
        }
    }
}

