/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.providers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.ui.launch.extensions.IDeploymentsProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class DeploymentProvider
extends LabelProvider
implements IStructuredContentProvider,
IElementComparer {
    private DeploymentsCache cache = null;

    public TPFDeployment[] getDeployments(Object object) {
        if (this.cache == null || !this.cache.getTestElement().equals(object)) {
            this.cache = new DeploymentsCache(object);
        }
        return this.cache.getDeployments();
    }

    public Object[] getElements(Object object) {
        if (object instanceof TPFTestSuite || object instanceof TPFTestComponent) {
            return this.getDeployments(object);
        }
        return new Object[0];
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }

    public Image getImage(Object object) {
        return TestUIImages.INSTANCE.getImage("deployment_obj.gif");
    }

    public String getText(Object object) {
        if (object instanceof TPFDeployment) {
            return ((TPFDeployment)object).getName();
        }
        return "<invalid deployment>";
    }

    public boolean equals(Object object, Object object2) {
        if (object.equals(object2)) {
            return true;
        }
        if (object instanceof EObject && object2 instanceof EObject) {
            EObject eObject = (EObject)object;
            EObject eObject2 = (EObject)object2;
            Resource resource = eObject.eResource();
            Resource resource2 = eObject2.eResource();
            return resource != null && resource2 != null && resource.getURI().equals((Object)resource2.getURI()) && resource.getURIFragment(eObject).equals(resource2.getURIFragment(eObject2));
        }
        return false;
    }

    public int hashCode(Object object) {
        return object.hashCode();
    }

    private class DeploymentsCache {
        private TPFDeployment[] deployments;
        private Object testElement;

        public DeploymentsCache(Object object) {
            if (object instanceof TPFTestSuite || object instanceof TPFTestComponent) {
                IDeploymentsProvider iDeploymentsProvider = LaunchConfigurationExtensionsManager.getInstance().getDeploymentsProvider(object);
                this.deployments = iDeploymentsProvider.getDeployments(object);
            }
            this.testElement = object;
        }

        public TPFDeployment[] getDeployments() {
            return this.deployments;
        }

        public Object getTestElement() {
            return this.testElement;
        }
    }
}

