/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.providers;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class TestComponentProvider
extends LabelProvider
implements ITreeContentProvider {
    private String mode;
    private String launchConfigurationType;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public TestComponentProvider(String string, String string2) {
        this.mode = string;
        this.launchConfigurationType = string2;
    }

    public Object[] getChildren(Object object) {
        if (object instanceof IContainer) {
            try {
                IContainer iContainer = (IContainer)object;
                IResource[] iResourceArray = iContainer.members();
                ArrayList<Object> arrayList = new ArrayList<Object>(iResourceArray.length);
                int n = 0;
                while (n < iResourceArray.length) {
                    IFile iFile;
                    if (iResourceArray[n] instanceof IContainer) {
                        arrayList.add(iResourceArray[n]);
                    } else if (iResourceArray[n] instanceof IFile && "testcomponent".equals((iFile = (IFile)iResourceArray[n]).getFileExtension())) {
                        EObject[] eObjectArray = EMFUtil.getEObjects(null, iFile);
                        TPFTestComponent tPFTestComponent = null;
                        int n2 = 0;
                        while (n2 < eObjectArray.length) {
                            if (eObjectArray[n2] != null && eObjectArray[n2] instanceof TPFTestComponent) {
                                tPFTestComponent = (TPFTestComponent)eObjectArray[n2];
                                break;
                            }
                            ++n2;
                        }
                        if (tPFTestComponent != null && this.isLaunchable(tPFTestComponent)) {
                            arrayList.add(tPFTestComponent);
                        }
                    }
                    ++n;
                }
                return arrayList.toArray();
            }
            catch (CoreException coreException) {
                TestUIPlugin.logError(coreException);
                return new Object[0];
            }
        }
        if (object instanceof TPFTestComponent) {
            return new Object[0];
        }
        return new Object[0];
    }

    public Object getParent(Object object) {
        if (object instanceof IResource) {
            return ((IResource)object).getParent();
        }
        if (object instanceof TPFTestComponent) {
            IFile iFile = EMFUtil.getWorkspaceFile((EObject)((TPFTestComponent)object));
            return iFile;
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        return this.getChildren(object).length > 0;
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }

    public Image getImage(Object object) {
        if (object instanceof IContainer) {
            ImageDescriptor imageDescriptor;
            IWorkbenchAdapter iWorkbenchAdapter = this.getWorkbenchAdapter(object);
            if (iWorkbenchAdapter != null && (imageDescriptor = iWorkbenchAdapter.getImageDescriptor(object)) != null) {
                return imageDescriptor.createImage();
            }
        } else if (object instanceof TPFTestComponent) {
            return TestUIImages.INSTANCE.getImage("testcomponent_obj.gif");
        }
        return null;
    }

    public String getText(Object object) {
        if (object instanceof IContainer) {
            IWorkbenchAdapter iWorkbenchAdapter = this.getWorkbenchAdapter(object);
            if (iWorkbenchAdapter != null) {
                return iWorkbenchAdapter.getLabel(object);
            }
        } else if (object instanceof TPFTestComponent) {
            return ((TPFTestComponent)object).getName();
        }
        return null;
    }

    private boolean isLaunchable(TPFTestComponent tPFTestComponent) {
        return LaunchConfigurationExtensionsManager.getInstance().isLaunchableElement(tPFTestComponent, this.mode, this.launchConfigurationType);
    }

    private IWorkbenchAdapter getWorkbenchAdapter(Object object) {
        IWorkbenchAdapter iWorkbenchAdapter = (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter(object, class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = TestComponentProvider.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter);
        if (iWorkbenchAdapter == this) {
            return null;
        }
        return iWorkbenchAdapter;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

