/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.shortcuts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.launch.configurations.DeploymentLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.configurations.ExecutionHistoryLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.configurations.TestComponentLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.configurations.TestLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.extensions.IDeploymentsProvider;
import org.eclipse.hyades.test.ui.launch.extensions.IExecutionHistoryDefaultsProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.internal.Workbench;

public class LaunchShortcut
implements ILaunchShortcut {
    static Object getRunnableItemFromElement(Object object, String string) {
        Object object2 = null;
        if (object instanceof TPFTestSuite || object instanceof TPFTestCase || object instanceof TPFTestComponent) {
            object2 = object;
        } else if (object instanceof IFile) {
            IFile iFile = (IFile)object;
            if ("testsuite".equals(iFile.getFileExtension())) {
                EObject[] eObjectArray = EMFUtil.load(null, iFile);
                int n = 0;
                while (n < eObjectArray.length) {
                    if (eObjectArray[n] instanceof TPFTestSuite) {
                        object2 = eObjectArray[n];
                        break;
                    }
                    ++n;
                }
            } else if ("testcomponent".equals(iFile.getFileExtension())) {
                EObject[] eObjectArray = EMFUtil.load(null, iFile);
                int n = 0;
                while (n < eObjectArray.length) {
                    if (eObjectArray[n] instanceof TPFTestComponent) {
                        object2 = eObjectArray[n];
                        break;
                    }
                    ++n;
                }
            }
        }
        if (object2 != null) {
            if (LaunchConfigurationExtensionsManager.getInstance().isShortcutAvailable(object2, string)) {
                return object2;
            }
            return null;
        }
        return null;
    }

    public void launch(IEditorPart iEditorPart, String string) {
        IFileEditorInput iFileEditorInput;
        Object object;
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput && (object = LaunchShortcut.getRunnableItemFromElement((iFileEditorInput = (IFileEditorInput)iEditorInput).getFile(), string)) != null) {
            this.launchElement(object, string);
        }
    }

    public void launch(ISelection iSelection, String string) {
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Object object = LaunchShortcut.getRunnableItemFromElement(e, string);
                if (object == null) continue;
                this.launchElement(object, string);
            }
        }
    }

    private void launchElement(Object object, String string) {
        ILaunchConfiguration iLaunchConfiguration = this.findLaunchConfiguration(object, string);
        try {
            if (iLaunchConfiguration == null) {
                iLaunchConfiguration = this.createLaunchConfiguration(object);
            }
            if (iLaunchConfiguration != null) {
                DebugUITools.saveAndBuildBeforeLaunch();
                iLaunchConfiguration.launch(string, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Throwable throwable) {
            this.reportFailure(throwable);
        }
    }

    private ILaunchConfiguration findLaunchConfiguration(Object object, String string) {
        ArrayList<ILaunchConfiguration> arrayList = Collections.EMPTY_LIST;
        ILaunchConfigurationType iLaunchConfigurationType = this.getConfigType(object);
        Assert.isNotNull((Object)iLaunchConfigurationType);
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = this.getLaunchManager().getLaunchConfigurations(iLaunchConfigurationType);
            arrayList = new ArrayList<ILaunchConfiguration>(iLaunchConfigurationArray.length);
            int n = 0;
            while (n < iLaunchConfigurationArray.length) {
                TPFTest tPFTest = null;
                if (object instanceof TPFTest) {
                    tPFTest = TestLaunchConfigurationFacade.getTest(iLaunchConfigurationArray[n]);
                } else if (object instanceof TPFTestComponent) {
                    tPFTest = TestComponentLaunchConfigurationFacade.getTestComponent(iLaunchConfigurationArray[n]);
                }
                if (object.equals(tPFTest)) {
                    arrayList.add(iLaunchConfigurationArray[n]);
                }
                ++n;
            }
            if (arrayList.size() == 0) {
                return null;
            }
            if (arrayList.size() == 1) {
                return (ILaunchConfiguration)arrayList.get(0);
            }
            return this.chooseFromCandidateConfigs(arrayList, string);
        }
        catch (CoreException coreException) {
            TestUIPlugin.logError(coreException);
            return null;
        }
    }

    private ILaunchConfiguration chooseFromCandidateConfigs(List list, String string) {
        IDebugModelPresentation iDebugModelPresentation = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getActiveShell(), (ILabelProvider)iDebugModelPresentation);
        elementListSelectionDialog.setElements(list.toArray());
        elementListSelectionDialog.setTitle(TestUIPlugin.getString("LaunchShortcut.ambiguousLaunchConfigurationTitle"));
        if (string.equals("debug")) {
            elementListSelectionDialog.setMessage(TestUIPlugin.getString("LaunchShortcut.selectDebugLaunchConfigPrompt"));
        } else if (string.equals("profile")) {
            elementListSelectionDialog.setMessage(TestUIPlugin.getString("LaunchShortcut.selectProfileLaunchConfigPrompt"));
        } else {
            elementListSelectionDialog.setMessage(TestUIPlugin.getString("LaunchShortcut.selectRunLaunchConfigPrompt"));
        }
        elementListSelectionDialog.setMultipleSelection(false);
        int n = elementListSelectionDialog.open();
        iDebugModelPresentation.dispose();
        if (n == 0) {
            return (ILaunchConfiguration)elementListSelectionDialog.getFirstResult();
        }
        return null;
    }

    private ILaunchConfiguration createLaunchConfiguration(Object object) throws CoreException {
        ILaunchConfiguration iLaunchConfiguration = null;
        ILaunchConfigurationType iLaunchConfigurationType = this.getConfigType(object);
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(TestUIPlugin.getString("LaunchShortcut.uniqueNamePrefix")));
        if (object instanceof TPFTest) {
            TestLaunchConfigurationFacade.setTest(iLaunchConfigurationWorkingCopy, (TPFTest)object);
        } else if (object instanceof TPFTestComponent) {
            TestComponentLaunchConfigurationFacade.setTestComponent(iLaunchConfigurationWorkingCopy, (TPFTestComponent)object);
        }
        IDeploymentsProvider iDeploymentsProvider = LaunchConfigurationExtensionsManager.getInstance().getDeploymentsProvider(object);
        TPFDeployment tPFDeployment = null;
        tPFDeployment = iDeploymentsProvider.getDefaultDeployment(object);
        if (tPFDeployment == null) {
            this.throwException(TestUIPlugin.getString("LaunchShortcut.noDefaultDeployment"), null);
        }
        DeploymentLaunchConfigurationFacade.setDeployment(iLaunchConfigurationWorkingCopy, tPFDeployment);
        String string = null;
        IContainer iContainer = null;
        IExecutionHistoryDefaultsProvider iExecutionHistoryDefaultsProvider = LaunchConfigurationExtensionsManager.getInstance().getExecutionHistoryDefaultsProvider(object);
        string = iExecutionHistoryDefaultsProvider.getDefaultName(object);
        if (string == null) {
            string = LaunchConfigurationExtensionsManager.getInstance().getDefaultExecutionHistoryDefaultsProvider().getDefaultName(object);
        }
        if ((iContainer = iExecutionHistoryDefaultsProvider.getDefaultLocation(object)) == null) {
            iContainer = LaunchConfigurationExtensionsManager.getInstance().getDefaultExecutionHistoryDefaultsProvider().getDefaultLocation(object);
        }
        if (string == null || iContainer == null) {
            this.throwException(TestUIPlugin.getString("LaunchShortcut.noDefaultExecHistoryInfo"), null);
        }
        ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryName(iLaunchConfigurationWorkingCopy, string);
        ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryLocation(iLaunchConfigurationWorkingCopy, iContainer);
        iLaunchConfiguration = iLaunchConfigurationWorkingCopy.doSave();
        return iLaunchConfiguration;
    }

    private void reportFailure(Throwable throwable) {
        CoreException coreException;
        TestUIPlugin.logError(throwable);
        MessageBox messageBox = new MessageBox(Workbench.getInstance().getActiveWorkbenchWindow().getShell(), 33);
        messageBox.setText(TestUIPlugin.getString("LaunchShortcut.errorDialogTitle"));
        String string = null;
        if (throwable instanceof CoreException && (coreException = (CoreException)throwable).getStatus() != null && coreException.getStatus().getMessage() != null) {
            string = coreException.getStatus().getMessage();
        }
        if (string == null) {
            string = "An exception occured. See error log for more details";
        }
        messageBox.setMessage(string);
        messageBox.open();
    }

    private void throwException(String string, Throwable throwable) throws CoreException {
        Status status = new Status(4, TestUIPlugin.getID(), 0, string, throwable);
        throw new CoreException((IStatus)status);
    }

    private ILaunchConfigurationType getConfigType(Object object) {
        ILaunchConfigurationType iLaunchConfigurationType = null;
        if (object instanceof TPFTest) {
            iLaunchConfigurationType = TestLaunchConfigurationFacade.getLaunchConfigurationType();
        } else if (object instanceof TPFTestComponent) {
            iLaunchConfigurationType = TestComponentLaunchConfigurationFacade.getLaunchConfigurationType();
        }
        return iLaunchConfigurationType;
    }

    private Shell getActiveShell() {
        IWorkbenchWindow iWorkbenchWindow = TestUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        return iWorkbenchWindow.getShell();
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }
}

