/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.tabs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.ui.internal.launch.providers.ExecutionHistoryLocationProvider;
import org.eclipse.hyades.test.ui.launch.configurations.ExecutionHistoryLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.configurations.TestLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.extensions.IExecutionHistoryDefaultsProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;

public class ExecutionHistoryTab
extends AbstractLaunchConfigurationTab {
    private TreeViewer tree;
    private Text nameText;
    private Button override;
    protected boolean userHasChosenName;
    protected boolean userHasChosenOverrideState;
    protected boolean userHasChosenLocation;
    private static final String PROPERTY_USER_HAS_CHOSEN_NAME = TestUIPlugin.getID() + "internal.launch.history.name_chosen";
    private static final String PROPERTY_USER_HAS_CHOSEN_OVERRIDE_STATE = TestUIPlugin.getID() + "internal.launch.history.override_chosen";
    private static final String PROPERTY_USER_HAS_CHOSEN_LOCATION = TestUIPlugin.getID() + "internal.launch.history.location_chosen";

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setFont(composite.getFont());
        Label label = new Label(composite2, 0);
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(TestUIPlugin.getString("ExecutionHistoryTab.name"));
        this.nameText = new Text(composite2, 2048);
        GridData gridData2 = new GridData(768);
        gridData2.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)gridData2);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ExecutionHistoryTab.this.updateLaunchConfigurationDialog();
                ExecutionHistoryTab.this.userHasChosenName = true;
            }
        });
        this.override = new Button(composite2, 32);
        this.override.setText(TestUIPlugin.getString("ExecutionHistoryTab.override"));
        this.override.setToolTipText(TestUIPlugin.getString("ExecutionHistoryTab.overrideTooltip"));
        this.override.setSelection(false);
        this.override.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ExecutionHistoryTab.this.userHasChosenOverrideState = true;
            }
        });
        GridData gridData3 = new GridData(32);
        gridData3.horizontalSpan = 2;
        this.override.setLayoutData((Object)gridData3);
        Label label2 = new Label(composite2, 0);
        GridData gridData4 = new GridData(32);
        gridData4.horizontalSpan = 2;
        label2.setLayoutData((Object)gridData4);
        label2.setText(TestUIPlugin.getString("ExecutionHistoryTab.location"));
        this.createLocationSelector(composite2);
        this.setControl((Control)composite2);
    }

    private void createLocationSelector(Composite composite) {
        GridData gridData = new GridData(1808);
        gridData.widthHint = composite.getClientArea().width / 2;
        gridData.heightHint = composite.getClientArea().height / 2;
        this.tree = new TreeViewer(composite);
        this.tree.getControl().setLayoutData((Object)gridData);
        ExecutionHistoryLocationProvider executionHistoryLocationProvider = new ExecutionHistoryLocationProvider();
        this.tree.setContentProvider((IContentProvider)executionHistoryLocationProvider);
        this.tree.setLabelProvider((IBaseLabelProvider)executionHistoryLocationProvider);
        this.tree.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ExecutionHistoryTab.this.updateLaunchConfigurationDialog();
                ExecutionHistoryTab.this.userHasChosenLocation = true;
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryName(iLaunchConfigurationWorkingCopy, this.computeDefaultName((ILaunchConfiguration)iLaunchConfigurationWorkingCopy));
        ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryOverriden(iLaunchConfigurationWorkingCopy, this.computeDefaultOverrideState((ILaunchConfiguration)iLaunchConfigurationWorkingCopy));
        ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryLocation(iLaunchConfigurationWorkingCopy, this.computeDefaultLocation((ILaunchConfiguration)iLaunchConfigurationWorkingCopy));
    }

    private String computeDefaultName(ILaunchConfiguration iLaunchConfiguration) {
        TPFTest tPFTest = null;
        try {
            tPFTest = TestLaunchConfigurationFacade.getTest(iLaunchConfiguration);
        }
        catch (CoreException coreException) {
            TestUIPlugin.logError(coreException);
        }
        IExecutionHistoryDefaultsProvider iExecutionHistoryDefaultsProvider = LaunchConfigurationExtensionsManager.getInstance().getExecutionHistoryDefaultsProvider(tPFTest);
        String string = iExecutionHistoryDefaultsProvider.getDefaultName(tPFTest);
        if (string == null) {
            string = LaunchConfigurationExtensionsManager.getInstance().getDefaultExecutionHistoryDefaultsProvider().getDefaultName(tPFTest);
        }
        return string;
    }

    private boolean computeDefaultOverrideState(ILaunchConfiguration iLaunchConfiguration) {
        TPFTest tPFTest = null;
        try {
            tPFTest = TestLaunchConfigurationFacade.getTest(iLaunchConfiguration);
        }
        catch (CoreException coreException) {
            TestUIPlugin.logError(coreException);
        }
        IExecutionHistoryDefaultsProvider iExecutionHistoryDefaultsProvider = LaunchConfigurationExtensionsManager.getInstance().getExecutionHistoryDefaultsProvider(tPFTest);
        return iExecutionHistoryDefaultsProvider.getDefaultOverrideState(tPFTest);
    }

    private IContainer computeDefaultLocation(ILaunchConfiguration iLaunchConfiguration) {
        TPFTest tPFTest = null;
        try {
            tPFTest = TestLaunchConfigurationFacade.getTest(iLaunchConfiguration);
        }
        catch (CoreException coreException) {
            TestUIPlugin.logError(coreException);
        }
        IExecutionHistoryDefaultsProvider iExecutionHistoryDefaultsProvider = LaunchConfigurationExtensionsManager.getInstance().getExecutionHistoryDefaultsProvider(tPFTest);
        IContainer iContainer = iExecutionHistoryDefaultsProvider.getDefaultLocation(tPFTest);
        if (iContainer == null) {
            iContainer = LaunchConfigurationExtensionsManager.getInstance().getDefaultExecutionHistoryDefaultsProvider().getDefaultLocation(tPFTest);
        }
        if (iContainer == null) {
            iContainer = ExecutionHistoryTab.getContext();
        }
        return iContainer;
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        try {
            this.userHasChosenName = this.getUserHasChosenName(iLaunchConfiguration);
            this.userHasChosenOverrideState = this.getUserHasChosenOverrideState(iLaunchConfiguration);
            this.userHasChosenLocation = this.getUserHasChosenLocation(iLaunchConfiguration);
            String string = ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryName(iLaunchConfiguration);
            if (string == null || !this.userHasChosenName) {
                this.nameText.setText(this.computeDefaultName(iLaunchConfiguration));
                this.userHasChosenName = false;
            } else {
                this.nameText.setText(string);
            }
            boolean bl = !this.userHasChosenOverrideState ? this.computeDefaultOverrideState(iLaunchConfiguration) : ExecutionHistoryLaunchConfigurationFacade.isExecutionHistoryOverriden(iLaunchConfiguration);
            this.override.setSelection(bl);
            IContainer iContainer = ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryLocation(iLaunchConfiguration);
            if (iContainer == null || !this.userHasChosenLocation) {
                iContainer = this.computeDefaultLocation(iLaunchConfiguration);
            }
            if (iContainer != null) {
                StructuredSelection structuredSelection = new StructuredSelection((Object)iContainer);
                this.tree.setSelection((ISelection)structuredSelection, true);
            }
        }
        catch (CoreException coreException) {
            TestUIPlugin.logError(coreException);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        String string = this.getExecutionHistoryName();
        ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryName(iLaunchConfigurationWorkingCopy, string);
        boolean bl = this.getOverrideState();
        ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryOverriden(iLaunchConfigurationWorkingCopy, bl);
        IContainer iContainer = this.getSelectedLocation();
        ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryLocation(iLaunchConfigurationWorkingCopy, iContainer);
        this.setUserHasChosenName(iLaunchConfigurationWorkingCopy, this.userHasChosenName);
        this.setUserHasChosenOverrideState(iLaunchConfigurationWorkingCopy, this.userHasChosenOverrideState);
        this.setUserHasChosenLocation(iLaunchConfigurationWorkingCopy, this.userHasChosenLocation);
    }

    public String getName() {
        return TestUIPlugin.getString("ExecutionHistoryTab.tabName");
    }

    public Image getImage() {
        return TestUIImages.INSTANCE.getImage("launch_execresultstab.gif");
    }

    private String getExecutionHistoryName() {
        return this.nameText.getText();
    }

    public boolean getOverrideState() {
        return this.override.getSelection();
    }

    private IContainer getSelectedLocation() {
        Object object;
        ISelection iSelection = this.tree.getSelection();
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof IContainer) {
            return (IContainer)object;
        }
        return null;
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        this.setErrorMessage(null);
        String string = this.getExecutionHistoryName();
        if (string == null || string.equals("")) {
            this.setErrorMessage(TestUIPlugin.getString("ExecutionHistoryTab.invalidName"));
            return false;
        }
        IContainer iContainer = this.getSelectedLocation();
        if (iContainer == null) {
            this.setErrorMessage(TestUIPlugin.getString("ExecutionHistoryTab.invalidLocation"));
            return false;
        }
        return true;
    }

    public static IContainer getContext() {
        try {
            IProject iProject;
            IStructuredSelection iStructuredSelection;
            Object object;
            ISelection iSelection;
            IWorkbenchPage iWorkbenchPage = TestUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (iWorkbenchPage != null && (iSelection = iWorkbenchPage.getSelection()) instanceof IStructuredSelection && (object = (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement()) instanceof IResource && (iProject = ((IResource)object).getProject()) != null) {
                return iProject;
            }
        }
        catch (Throwable throwable) {
            TestUIPlugin.logError(throwable);
        }
        return null;
    }

    private boolean getUserHasChosenName(ILaunchConfiguration iLaunchConfiguration) {
        try {
            return iLaunchConfiguration.getAttribute(PROPERTY_USER_HAS_CHOSEN_NAME, false);
        }
        catch (CoreException coreException) {
            TestUIPlugin.logError(coreException);
            return true;
        }
    }

    private boolean getUserHasChosenOverrideState(ILaunchConfiguration iLaunchConfiguration) {
        try {
            return iLaunchConfiguration.getAttribute(PROPERTY_USER_HAS_CHOSEN_OVERRIDE_STATE, false);
        }
        catch (CoreException coreException) {
            TestUIPlugin.logError(coreException);
            return true;
        }
    }

    private boolean getUserHasChosenLocation(ILaunchConfiguration iLaunchConfiguration) {
        try {
            return iLaunchConfiguration.getAttribute(PROPERTY_USER_HAS_CHOSEN_LOCATION, false);
        }
        catch (CoreException coreException) {
            TestUIPlugin.logError(coreException);
            return true;
        }
    }

    private void setUserHasChosenName(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy, boolean bl) {
        iLaunchConfigurationWorkingCopy.setAttribute(PROPERTY_USER_HAS_CHOSEN_NAME, bl);
    }

    private void setUserHasChosenOverrideState(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy, boolean bl) {
        iLaunchConfigurationWorkingCopy.setAttribute(PROPERTY_USER_HAS_CHOSEN_OVERRIDE_STATE, bl);
    }

    private void setUserHasChosenLocation(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy, boolean bl) {
        iLaunchConfigurationWorkingCopy.setAttribute(PROPERTY_USER_HAS_CHOSEN_LOCATION, bl);
    }
}

