/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.navigator.ExecutionNavigator;
import org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;

public class ExecutionResourceChangeUpdater
implements IResourceChangeUpdater {
    private ExecutionNavigator executionNavigator;
    private List addedObjects;
    private List removedObjects;
    private List changedObjects;
    private List resourcesToSave;
    private Object[] expandedElements;
    private Object[] selectedElements;
    private boolean active;

    public ExecutionResourceChangeUpdater(ExecutionNavigator executionNavigator) {
        this.executionNavigator = executionNavigator;
        this.active = true;
    }

    public void dispose() {
        this.executionNavigator = null;
    }

    public void started() {
        this.addedObjects = new UniqueEList();
        this.removedObjects = new UniqueEList();
        this.changedObjects = new UniqueEList();
        this.resourcesToSave = new UniqueEList();
    }

    public void ended() {
        Object object;
        Object object2;
        Object object3;
        if (!this.addedObjects.isEmpty()) {
            object3 = this.addedObjects.iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                object = ((ITreeContentProvider)this.executionNavigator.getViewer().getContentProvider()).getParent(object2);
                if (object == null) {
                    this.executionNavigator.getTreeViewer().refresh(true);
                    return;
                }
                this.executionNavigator.getTreeViewer().add(object, object2);
            }
        }
        if (!this.removedObjects.isEmpty()) {
            this.executionNavigator.getTreeViewer().remove(this.removedObjects.toArray());
        }
        if (!this.changedObjects.isEmpty()) {
            object3 = this.changedObjects.iterator();
            while (object3.hasNext()) {
                this.executionNavigator.getTreeViewer().refresh(object3.next(), true);
            }
        }
        if (!this.resourcesToSave.isEmpty()) {
            object3 = this.resourcesToSave.iterator();
            while (object3.hasNext()) {
                try {
                    EMFUtil.save((Resource)object3.next());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        object3 = new ArrayList();
        object2 = this.addedObjects.iterator();
        while (object2.hasNext()) {
            IFile iFile;
            object = object2.next();
            if (!(object instanceof TPFExecutionResult)) continue;
            object3.add(object);
            if (!TestUIPlugin.getInstance().getPreferenceStore().getBoolean("openEditor") || (iFile = EMFUtil.getWorkspaceFile((EObject)((TPFExecutionResult)object))) == null || !iFile.exists()) continue;
            UIUtil.openEditor((IFile)iFile, (String)"org.eclipse.hyades.test.ui.editor.ExecutionEditorPart", (boolean)false);
        }
        if (this.expandedElements != null) {
            this.convertURIToEObject(this.expandedElements);
            this.executionNavigator.getTreeViewer().setExpandedElements(this.expandedElements);
            if (object3.isEmpty()) {
                this.convertURIToEObject(this.selectedElements);
                this.executionNavigator.getTreeViewer().setSelection((ISelection)new StructuredSelection(this.selectedElements), true);
            }
            this.expandedElements = null;
            this.selectedElements = null;
        }
        if (!object3.isEmpty()) {
            this.executionNavigator.getTreeViewer().setSelection((ISelection)new StructuredSelection((List)object3), true);
            object3.clear();
        }
        this.addedObjects.clear();
        this.addedObjects = null;
        this.removedObjects.clear();
        this.removedObjects = null;
        this.changedObjects.clear();
        this.changedObjects = null;
        this.resourcesToSave.clear();
        this.resourcesToSave = null;
    }

    public boolean add(IResource iResource, IResource[] iResourceArray) {
        ResourceSet resourceSet = this.executionNavigator.getResourceSet();
        int n = 0;
        int n2 = iResourceArray.length;
        while (n < n2) {
            if (iResourceArray[n].getType() != 1) {
                this.addedObjects.add(iResourceArray[n]);
            } else {
                EObject[] eObjectArray;
                URI uRI = this.getFileURI(iResourceArray[n]);
                if (uRI != null && (eObjectArray = EMFUtil.load(null, (IFile)iResourceArray[n])).length == 1 && this.isValid(eObjectArray[0])) {
                    Resource resource = eObjectArray[0].eResource();
                    resourceSet.getResources().add((Object)resource);
                    this.addedObjects.addAll(resource.getContents());
                }
            }
            ++n;
        }
        return false;
    }

    public boolean remove(IResource iResource, IResource[] iResourceArray) {
        ResourceSet resourceSet = this.executionNavigator.getResourceSet();
        int n = 0;
        int n2 = iResourceArray.length;
        while (n < n2) {
            if (iResourceArray[n].getType() != 1) {
                this.removedObjects.add(iResourceArray[n]);
            } else {
                Resource resource;
                URI uRI = this.getFileURI(iResourceArray[n]);
                if (uRI != null && (resource = resourceSet.getResource(uRI, false)) != null) {
                    this.removedObjects.addAll(resource.getContents());
                    this.resourcesToSave.addAll(Arrays.asList(EMFUtil.remove(resource)));
                }
            }
            ++n;
        }
        return false;
    }

    public boolean replaced(IResource iResource) {
        return false;
    }

    public boolean updateProperties(IResource iResource) {
        if (iResource.getType() == 1) {
            Object[] objectArray = EMFUtil.getEObjects(this.executionNavigator.getResourceSet(), (IFile)iResource);
            if (objectArray.length > 0) {
                this.executionNavigator.getTreeViewer().update(objectArray, null);
            }
        } else {
            this.executionNavigator.getTreeViewer().update((Object)iResource, null);
        }
        return false;
    }

    public boolean updateChildrenType(IResource iResource) {
        return false;
    }

    public boolean updateContent(IResource iResource, IResource iResource2) {
        Resource resource;
        URI uRI = this.getFileURI(iResource2);
        if (uRI != null && (resource = this.executionNavigator.getResourceSet().getResource(uRI, false)) != null) {
            this.removedObjects.addAll(resource.getContents());
            resource.unload();
            try {
                resource.load(EMFUtil.RESOURCE_OPTIONS);
            }
            catch (IOException iOException) {
                TestUIPlugin.logError(iOException);
            }
            this.changedObjects.add(resource);
            this.addedObjects.addAll(resource.getContents());
            if (this.expandedElements == null) {
                this.expandedElements = this.executionNavigator.getTreeViewer().getExpandedElements();
                this.convertEObjectToURI(this.expandedElements);
                this.selectedElements = ((IStructuredSelection)this.executionNavigator.getTreeViewer().getSelection()).toArray();
                this.convertEObjectToURI(this.selectedElements);
            }
        }
        return false;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean isActive() {
        return this.active;
    }

    protected URI getFileURI(IResource iResource) {
        String string;
        if (iResource.getType() == 1 && ("testsuite".equals(string = iResource.getFileExtension()) || "execution".equals(string))) {
            return URI.createPlatformResourceURI((String)iResource.getFullPath().toString());
        }
        return null;
    }

    protected boolean isValid(EObject eObject) {
        return eObject instanceof CMNNamedElement;
    }

    private void convertEObjectToURI(Object[] objectArray) {
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            if (objectArray[n] instanceof EObject) {
                objectArray[n] = EcoreUtil.getURI((EObject)((EObject)objectArray[n]));
            }
            ++n;
        }
    }

    private void convertURIToEObject(Object[] objectArray) {
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            if (objectArray[n] instanceof URI) {
                objectArray[n] = this.executionNavigator.getResourceSet().getEObject((URI)objectArray[n], false);
            }
            ++n;
        }
    }
}

