/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.execution.harness.TestExecutionHarness;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.help.WorkbenchHelp;

public abstract class ControlEventAction
extends Action
implements IDisposable {
    private IStructuredSelection structuredSelection;
    private String m_controlEvent = null;
    private String m_text = null;

    public ControlEventAction(String string, String string2, String string3) {
        super(TestUIPlugin.getString(string2));
        WorkbenchHelp.setHelp((IAction)this, (String)(TestUIPlugin.getID() + string3));
        this.m_controlEvent = string;
        this.m_text = string2;
    }

    public void dispose() {
        this.structuredSelection = null;
    }

    protected IStructuredSelection getStructuredSelection() {
        return this.structuredSelection;
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.structuredSelection = iStructuredSelection;
    }

    public void run() {
        Object object;
        IStructuredSelection iStructuredSelection = this.getStructuredSelection();
        if (iStructuredSelection != null && !iStructuredSelection.isEmpty() && (object = iStructuredSelection.getFirstElement()) instanceof TPFExecutionResult) {
            String string;
            String string2;
            TPFExecutionResult tPFExecutionResult = (TPFExecutionResult)object;
            TPFTest tPFTest = tPFExecutionResult.getTest();
            ITestSuite iTestSuite = null;
            if (tPFTest instanceof ITestSuite) {
                iTestSuite = (ITestSuite)tPFTest;
            } else if (tPFTest instanceof ITestCase) {
                iTestSuite = ((ITestCase)tPFTest).getOwner();
            }
            String string3 = TestUIPlugin.getInstance().getPreferenceStore().getString("localhost_port");
            TPFDeployment tPFDeployment = tPFExecutionResult.getDeployment();
            EList eList = tPFDeployment.getLocations();
            boolean bl = true;
            String string4 = new String();
            int n = 0;
            while (n < eList.size()) {
                string2 = (CFGLocation)eList.get(n);
                string = ((CFGMachineConstraint)string2).getHostname();
                String string5 = new TestExecutionHarness().performControlEvent(iTestSuite, (ITest)tPFTest, (CFGLocation)string2, string3, tPFExecutionResult, this.m_controlEvent, null);
                if (string5 == null) {
                    bl = false;
                } else {
                    string4 = string4 + string5 + "\r";
                }
                ++n;
            }
            if (bl) {
                string2 = TestUIPlugin.getString("CONTROL_EVT_FAIL_TEXT");
                string2 = StringUtil.replace((String)string2, (String)"%1", (String)TestUIPlugin.getString(this.m_text));
                string2 = StringUtil.replace((String)string2, (String)"%2", (String)tPFDeployment.getName());
                string = new Status(2, "org.eclipse.core.resources", 566, string4, null);
                ErrorDialog.openError(null, (String)TestUIPlugin.getString("TEST_ERR_MSG"), (String)string2, (IStatus)string);
            }
        }
        this.structuredSelection = null;
    }

    public boolean isApplicableForSelection() {
        if (this.structuredSelection == null || this.structuredSelection.size() != 1) {
            return false;
        }
        Object object = this.structuredSelection.getFirstElement();
        return object instanceof TPFExecutionResult;
    }

    public boolean isApplicableForEnablement() {
        if (this.structuredSelection == null || this.structuredSelection.size() != 1) {
            return false;
        }
        Object object = this.structuredSelection.getFirstElement();
        boolean bl = false;
        if (object instanceof TPFExecutionResult) {
            ITestSuite iTestSuite;
            Object object2;
            Object object3;
            TPFExecutionResult tPFExecutionResult = (TPFExecutionResult)object;
            TPFExecutionHistory tPFExecutionHistory = tPFExecutionResult.getExecutionHistory();
            EList eList = tPFExecutionHistory.getExecutionEvents();
            if (eList.size() > 0 && (object3 = eList.get(eList.size() - 1)) instanceof TPFTypedEvent && (object2 = (iTestSuite = (TPFTypedEvent)object3).getType()).getValue() == 1) {
                return false;
            }
            object3 = tPFExecutionResult.getTest();
            iTestSuite = null;
            if (object3 instanceof ITestSuite) {
                iTestSuite = (ITestSuite)object3;
            } else if (object3 instanceof ITestCase) {
                iTestSuite = ((ITestCase)object3).getOwner();
            }
            object2 = TestUIPlugin.getInstance().getPreferenceStore().getString("localhost_port");
            TPFDeployment tPFDeployment = tPFExecutionResult.getDeployment();
            EList eList2 = tPFDeployment.getLocations();
            int n = 0;
            while (n < eList2.size()) {
                CFGLocation cFGLocation = (CFGLocation)eList2.get(0);
                String string = ((CFGMachineConstraint)cFGLocation).getHostname();
                bl = new TestExecutionHarness().canSupportControlEvent(iTestSuite, (ITest)object3, cFGLocation, (String)object2, tPFExecutionResult, this.m_controlEvent);
                if (!bl) break;
                ++n;
            }
        }
        return bl;
    }
}

