/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.hyades.test.ui.dialog.EObjectResourceContentProvider;
import org.eclipse.hyades.test.ui.dialog.EObjectResourceLabelProvider;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class ArtifactSelectionPage
extends WizardPage
implements SelectionListener,
ICheckStateListener {
    private Button filterButton;
    private CheckboxTreeViewer assetViewer;
    private EObjectResourceContentProvider contentProvider;
    private String[] fileExtensions = this.getSupportedFileExtensions();
    private Image fileImage;
    private EObject[] selectedEObjects;
    private EObject[] checkedEObjects;
    private Vector checkedObjects;

    protected ArtifactSelectionPage(String string) {
        super(string);
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridDataUtil.createFill();
        composite2.setLayoutData((Object)gridData);
        this.filterButton = new Button(composite2, 32);
        this.filterButton.setText(TestUIPlugin.getString("SHOW_FOLDERS"));
        this.filterButton.addSelectionListener((SelectionListener)this);
        this.createViewer(composite2);
        this.assetViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        ((Tree)this.assetViewer.getControl()).addSelectionListener((SelectionListener)this);
        this.assetViewer.expandToLevel(2);
        this.setControl((Control)composite2);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.filterButton) {
            this.contentProvider.setFilter(this.filterButton.getSelection() ? 4 : 2);
            ISelection iSelection = this.assetViewer.getSelection();
            this.assetViewer.refresh();
            if (!iSelection.isEmpty()) {
                this.assetViewer.setSelection(iSelection, true);
            }
        }
        if (selectionEvent.widget == this.assetViewer.getControl()) {
            this.setSelection();
        }
    }

    private void setSelection() {
        ISelection iSelection = this.assetViewer.getSelection();
        if (iSelection != null && !iSelection.isEmpty()) {
            Iterator iterator = ((IStructuredSelection)iSelection).iterator();
            Vector<EObject> vector = new Vector<EObject>();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof EObject)) continue;
                vector.add((EObject)e);
            }
            this.selectedEObjects = new EObject[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                this.selectedEObjects[n] = (EObject)vector.get(n);
                ++n;
            }
        }
    }

    public EObject[] getSelectedObjects() {
        if (this.selectedEObjects == null) {
            this.selectedEObjects = new EObject[0];
        }
        return this.selectedEObjects;
    }

    public IFile[] getSelectedFiles() {
        if (this.selectedEObjects == null) {
            return new IFile[0];
        }
        IFile[] iFileArray = new IFile[this.selectedEObjects.length];
        int n = 0;
        while (n < this.selectedEObjects.length) {
            iFileArray[n] = EMFUtil.getWorkspaceFile(this.selectedEObjects[n]);
            ++n;
        }
        return iFileArray;
    }

    public EObject[] getCheckedObjects() {
        if (this.checkedEObjects == null) {
            this.checkedEObjects = new EObject[0];
        }
        return this.checkedEObjects;
    }

    public IFile[] getCheckedFiles() {
        if (this.checkedEObjects == null) {
            return new IFile[0];
        }
        IFile[] iFileArray = new IFile[this.checkedEObjects.length];
        int n = 0;
        while (n < this.checkedEObjects.length) {
            iFileArray[n] = EMFUtil.getWorkspaceFile(this.checkedEObjects[n]);
            ++n;
        }
        return iFileArray;
    }

    protected StructuredViewer createViewer(Composite composite) {
        Tree tree = new Tree(composite, 67618);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 150;
        tree.setLayoutData((Object)gridData);
        this.contentProvider = new EObjectResourceContentProvider(this.fileExtensions);
        this.assetViewer = new CheckboxTreeViewer(tree);
        this.assetViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.assetViewer.setLabelProvider((IBaseLabelProvider)new EObjectResourceLabelProvider(true, this.fileImage));
        this.assetViewer.addCheckStateListener((ICheckStateListener)this);
        this.contentProvider.setFilter(2);
        ViewerSorter viewerSorter = new ViewerSorter(){

            public void sort(Viewer viewer, Object[] objectArray) {
                if (objectArray.length > 0) {
                    super.sort(viewer, objectArray);
                }
            }

            public int category(Object object) {
                if (object instanceof IResource) {
                    return 0;
                }
                return 10;
            }
        };
        this.assetViewer.setSorter(viewerSorter);
        return this.assetViewer;
    }

    private String[] getSupportedFileExtensions() {
        return new String[]{"testsuite", "testcomponent", "sut", "datapool"};
    }

    public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
        if (this.checkedObjects == null) {
            this.checkedObjects = new Vector();
        }
        Object object = checkStateChangedEvent.getElement();
        if (checkStateChangedEvent.getChecked()) {
            if (this.checkedObjects.contains(object)) {
                return;
            }
            this.checkedObjects.add(object);
        } else if (this.checkedObjects.contains(object)) {
            this.checkedObjects.remove(object);
        } else {
            return;
        }
        EObject[] eObjectArray = new EObject[this.checkedObjects.size()];
        int n = 0;
        while (n < this.checkedObjects.size()) {
            eObjectArray[n] = (EObject)this.checkedObjects.get(n);
            ++n;
        }
        this.checkedEObjects = eObjectArray;
    }
}

