/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.hyades.test.ui.dialog.EObjectResourceContentProvider;
import org.eclipse.hyades.test.ui.dialog.EObjectResourceLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class DatapoolExportSelectionPage
extends WizardPage
implements SelectionListener {
    IDatapool datapool = null;
    private TreeViewer assetViewer;
    Button filterButton = null;
    private EObjectResourceContentProvider contentProvider;
    private String[] fileExtensions = this.getSupportedFileExtensions();
    private Image fileImage;

    protected DatapoolExportSelectionPage(String string) {
        super(string);
        this.setPageComplete(false);
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridDataUtil.createFill();
        composite2.setLayoutData((Object)gridData);
        this.filterButton = new Button(composite2, 32);
        this.filterButton.setText(TestUIPlugin.getString("SHOW_FOLDERS"));
        this.filterButton.addSelectionListener((SelectionListener)this);
        this.createViewer(composite2);
        this.assetViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        ((Tree)this.assetViewer.getControl()).addSelectionListener((SelectionListener)this);
        this.assetViewer.expandToLevel(2);
        this.setControl((Control)composite2);
    }

    public IDatapool getDatapool() {
        return this.datapool;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.filterButton) {
            this.contentProvider.setFilter(this.filterButton.getSelection() ? 4 : 2);
            ISelection iSelection = this.assetViewer.getSelection();
            this.assetViewer.refresh();
            if (!iSelection.isEmpty()) {
                this.assetViewer.setSelection(iSelection, true);
            }
        }
        if (selectionEvent.widget == this.assetViewer.getControl()) {
            this.setSelection();
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    protected StructuredViewer createViewer(Composite composite) {
        Tree tree = new Tree(composite, 67588);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 150;
        tree.setLayoutData((Object)gridData);
        this.contentProvider = new EObjectResourceContentProvider(this.fileExtensions);
        this.assetViewer = new TreeViewer(tree);
        this.assetViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.assetViewer.setLabelProvider((IBaseLabelProvider)new EObjectResourceLabelProvider(true, this.fileImage));
        this.contentProvider.setFilter(2);
        ViewerSorter viewerSorter = new ViewerSorter(){

            public void sort(Viewer viewer, Object[] objectArray) {
                if (objectArray.length > 0) {
                    super.sort(viewer, objectArray);
                }
            }

            public int category(Object object) {
                if (object instanceof IResource) {
                    return 0;
                }
                return 10;
            }
        };
        this.assetViewer.setSorter(viewerSorter);
        return this.assetViewer;
    }

    private void setSelection() {
        Object object;
        ISelection iSelection = this.assetViewer.getSelection();
        if (iSelection != null && !iSelection.isEmpty() && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof IDatapool) {
            this.datapool = (IDatapool)object;
            if (this.datapool != null) {
                this.setPageComplete(true);
                this.getContainer().updateButtons();
            }
        }
    }

    private String[] getSupportedFileExtensions() {
        return new String[]{"datapool"};
    }
}

