/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolFactory;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.DPLDatapoolSpec;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.CSVImportExportUtil;
import org.eclipse.hyades.test.ui.datapool.internal.util.CorruptCSVFileException;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.wizard.DatapoolCSVImportPage;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.PartInitException;
import sun.io.MalformedInputException;

public class DatapoolNewWizard
extends HyadesNewWizard {
    DatapoolCSVImportPage csvImportPage = null;

    public DatapoolNewWizard() {
        this.setWindowTitle(TestUIPlugin.getString("WIZ_DATAPOOL_TTL"));
        this.setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("newtestsuite_wiz.gif"));
        IDialogSettings iDialogSettings = TestUIPlugin.getInstance().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection("DataPoolNewWizard");
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection("DataPoolNewWizard");
        }
        this.setDialogSettings(iDialogSettings2);
    }

    protected String getType() {
        return "org.eclipse.hyades.datapool.generic";
    }

    protected String getFileExtension() {
        return "datapool";
    }

    public void addPages() {
        this.getLocationPage().setTitle(TestUIPlugin.getString("WIZ_DATAPOOL_GEN_PG_TTL"));
        this.getLocationPage().setDescription(TestUIPlugin.getString("WIZ_DATAPOOL_GEN_PG_LOC_DSC"));
        this.addPage((IWizardPage)this.getLocationPage());
        this.getAttributeWizardPage().setTitle(TestUIPlugin.getString("WIZ_DATAPOOL_GEN_PG_TTL"));
        this.getAttributeWizardPage().setDescription(TestUIPlugin.getString("WIZ_DATAPOOL_GEN_PG_ATT_DSC"));
        this.addPage((IWizardPage)this.getAttributeWizardPage());
        this.csvImportPage = new DatapoolCSVImportPage("CSVImport");
        this.csvImportPage.setTitle(TestUIPlugin.getString("WIZ_DATAPOOL_CSV_PG_TTL"));
        this.csvImportPage.setDescription(TestUIPlugin.getString("WIZ_DATAPOOL_CSV_PG_DSC"));
        this.addPage((IWizardPage)this.csvImportPage);
    }

    protected boolean createObject(IFile iFile) throws Exception {
        Resource resource = this.createResource(iFile);
        EObject eObject = this.createEObject();
        if (eObject == null) {
            return false;
        }
        resource.getContents().add((Object)eObject);
        EMFUtil.save(resource);
        return true;
    }

    protected EObject createEObject() {
        DPLDatapool dPLDatapool;
        block3: {
            dPLDatapool = this.createDatapool();
            String string = this.csvImportPage.getCSVFileName();
            boolean bl = this.csvImportPage.firstRowContainsVariableNameType();
            boolean bl2 = this.csvImportPage.firstColumnContainsEquivalenceClassName();
            if (string.length() == 0) break block3;
            try {
                CSVImportExportUtil.getInstance().importCSV((IDatapool)dPLDatapool, string, bl, bl2);
            }
            catch (IOException iOException) {
                Status status = null;
                status = iOException instanceof MalformedInputException ? new Status(4, "org.eclipse.core.resources", 0, TestUIPlugin.getString("WIZ_DATAPOOL_CSV_ERRDLG_CORRUPT"), null) : new Status(4, "org.eclipse.core.resources", 0, iOException.getMessage(), null);
                new ErrorDialog(this.getShell(), TestUIPlugin.getString("WIZ_DATAPOOL_CSV_ERRDLG_TITLE"), TestUIPlugin.getString("WIZ_DATAPOOL_CSV_ERRDLG_IMPFILE"), (IStatus)status, 4).open();
                dPLDatapool = null;
            }
            catch (CorruptCSVFileException corruptCSVFileException) {
                Status status = new Status(4, "org.eclipse.core.resources", 0, corruptCSVFileException.getMessage(), null);
                new ErrorDialog(this.getShell(), TestUIPlugin.getString("WIZ_DATAPOOL_CSV_ERRDLG_TITLE"), TestUIPlugin.getString("WIZ_DATAPOOL_CSV_ERRDLG_CORRUPT"), (IStatus)status, 4).open();
                dPLDatapool = null;
            }
        }
        return dPLDatapool;
    }

    protected Resource createResource(IFile iFile) {
        URI uRI = URI.createPlatformResourceURI((String)iFile.getFullPath().toString());
        Resource.Factory factory = EMFUtil.getResourceFactory("datapool");
        return factory.createResource(uRI);
    }

    protected void openEditor(IFile iFile) throws PartInitException {
        if (TestUIPlugin.getInstance().getPreferenceStore().getBoolean("openEditor")) {
            UIUtil.openEditor((IFile)iFile, (String)"org.eclipse.hyades.test.ui.editor.DatapoolEditorPart", (boolean)false);
        }
    }

    private DPLDatapool createDatapool() {
        DPLDatapool dPLDatapool = Common_DatapoolFactory.eINSTANCE.createDPLDatapool();
        dPLDatapool.setName(this.getAttributeWizardPage().getItemName());
        String string = this.getAttributeWizardPage().getItemDescription();
        if (string != null && string.trim().length() > 0) {
            dPLDatapool.setDescription(string);
        }
        DPLDatapoolSpec dPLDatapoolSpec = Common_DatapoolFactory.eINSTANCE.createDPLDatapoolSpec();
        dPLDatapool.setDatapoolSpec(dPLDatapoolSpec);
        return dPLDatapool;
    }
}

