/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.action.AddArtifactAction;
import org.eclipse.hyades.test.ui.internal.action.AddDeploymentChildAction;
import org.eclipse.hyades.test.ui.internal.action.AddLocationAction;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class DeploymentObjectPage
extends WizardPage
implements SelectionListener,
ISelectionChangedListener {
    protected TreeViewer objectViewer;
    private TPFDeployment deployment;
    private Object input;
    private Object type;
    private Button addButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    protected DeploymentObjectPage(String string, TPFDeployment tPFDeployment, Object object) {
        super(string);
        this.deployment = tPFDeployment;
        this.type = object;
        if (object instanceof CFGLocation) {
            this.input = tPFDeployment.getRefLocations();
        }
        if (object instanceof CFGArtifact) {
            this.input = tPFDeployment.getArtifacts();
        }
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 10;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridDataUtil.createFill());
        this.createViewer(composite2);
        Composite composite3 = new Composite(composite2, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData = new GridData(1040);
        composite3.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 1;
        composite3.setLayout((Layout)gridLayout);
        this.createButtons(composite3);
        this.addButton.addSelectionListener((SelectionListener)this);
        this.removeButton.addSelectionListener((SelectionListener)this);
        this.upButton.addSelectionListener((SelectionListener)this);
        this.downButton.addSelectionListener((SelectionListener)this);
        this.setControl((Control)composite2);
    }

    protected StructuredViewer createViewer(Composite composite) {
        Tree tree = new Tree(composite, 67588);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 150;
        tree.setLayoutData((Object)gridData);
        ObjectContentProvider objectContentProvider = new ObjectContentProvider();
        this.objectViewer = new TreeViewer(tree);
        this.objectViewer.setContentProvider((IContentProvider)objectContentProvider);
        this.objectViewer.setLabelProvider((IBaseLabelProvider)new ObjectLabelProvider(true));
        this.objectViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.deployment != null) {
            this.objectViewer.setInput(this.input);
        }
        return this.objectViewer;
    }

    private void createButtons(Composite composite) {
        this.addButton = new Button(composite, 8);
        this.addButton.setText(TestUIPlugin.getString("label.Add"));
        GridData gridData = GridDataUtil.createHorizontalFill();
        this.addButton.setLayoutData((Object)gridData);
        this.addButton.setEnabled(true);
        this.removeButton = new Button(composite, 8);
        this.removeButton.setText(TestUIPlugin.getString("label.Remove"));
        gridData = GridDataUtil.createHorizontalFill();
        this.removeButton.setLayoutData((Object)gridData);
        this.removeButton.setEnabled(false);
        this.upButton = new Button(composite, 8);
        this.upButton.setText(TestUIPlugin.getString("LBL_UP"));
        gridData = GridDataUtil.createHorizontalFill();
        gridData.verticalAlignment = 8;
        this.upButton.setLayoutData((Object)gridData);
        this.upButton.setEnabled(false);
        this.downButton = new Button(composite, 8);
        this.downButton.setText(TestUIPlugin.getString("LBL_DOWN"));
        gridData = GridDataUtil.createHorizontalFill();
        gridData.verticalAlignment = 8;
        this.downButton.setLayoutData((Object)gridData);
        this.downButton.setEnabled(false);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.widgetSelected(selectionEvent);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        ISelection iSelection = this.objectViewer.getSelection();
        Object object = null;
        if (iSelection != null && !iSelection.isEmpty()) {
            object = ((IStructuredSelection)iSelection).getFirstElement();
        }
        if (selectionEvent.widget == this.addButton) {
            AddDeploymentChildAction addDeploymentChildAction;
            if (this.type instanceof CFGArtifact) {
                addDeploymentChildAction = new AddArtifactAction();
                addDeploymentChildAction.setDeployment(this.deployment);
                ((AddArtifactAction)addDeploymentChildAction).run();
            }
            if (this.type instanceof CFGLocation) {
                addDeploymentChildAction = new AddLocationAction();
                addDeploymentChildAction.setDeployment(this.deployment);
                ((AddLocationAction)addDeploymentChildAction).run();
            }
            this.objectViewer.refresh();
        } else if (selectionEvent.widget == this.removeButton) {
            if (object != null && object instanceof CFGArtifact) {
                this.deployment.getArtifacts().remove((Object)((CFGArtifact)object));
            }
            if (object != null && object instanceof CFGLocation) {
                this.deployment.getRefLocations().remove((Object)((CFGLocation)object));
            }
            this.objectViewer.refresh();
        } else if (selectionEvent.widget == this.upButton) {
            int n = -1;
            if (object != null && object instanceof CFGArtifact) {
                n = this.deployment.getArtifacts().indexOf((Object)((CFGArtifact)object));
                this.deployment.getArtifacts().move(n, n - 1);
            }
            if (object != null && object instanceof CFGLocation) {
                n = this.deployment.getRefLocations().indexOf((Object)((CFGLocation)object));
                this.deployment.getRefLocations().move(n, n - 1);
            }
            this.objectViewer.refresh();
            if (n - 1 == 0) {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(true);
            }
        } else if (selectionEvent.widget == this.downButton) {
            int n = -1;
            int n2 = -1;
            if (object != null && object instanceof CFGArtifact) {
                n = this.deployment.getArtifacts().indexOf((Object)((CFGArtifact)object));
                n2 = this.deployment.getArtifacts().size() - 1;
                this.deployment.getArtifacts().move(n, n + 1);
            }
            if (object != null && object instanceof CFGLocation) {
                n = this.deployment.getRefLocations().indexOf((Object)((CFGLocation)object));
                n2 = this.deployment.getRefLocations().size() - 1;
                this.deployment.getRefLocations().move(n, n + 1);
            }
            this.objectViewer.refresh();
            if (n + 1 == n2) {
                this.upButton.setEnabled(true);
                this.downButton.setEnabled(false);
            }
        }
    }

    public void setDeployment(TPFDeployment tPFDeployment) {
        this.deployment = tPFDeployment;
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        boolean bl = !this.objectViewer.getSelection().isEmpty();
        boolean bl2 = false;
        boolean bl3 = false;
        ISelection iSelection = this.objectViewer.getSelection();
        Object object = null;
        if (iSelection != null && !iSelection.isEmpty()) {
            object = ((IStructuredSelection)iSelection).getFirstElement();
            int n = -1;
            int n2 = -1;
            if (object != null && object instanceof CFGArtifact) {
                n2 = this.deployment.getArtifacts().size() - 1;
                n = this.deployment.getArtifacts().indexOf((Object)((CFGArtifact)object));
            }
            if (object != null && object instanceof CFGLocation) {
                n2 = this.deployment.getArtifacts().size() - 1;
                n = this.deployment.getRefLocations().indexOf((Object)((CFGLocation)object));
            }
            if (n != 0) {
                bl2 = true;
            }
            if (n != n2) {
                bl3 = true;
            }
        }
        this.removeButton.setEnabled(bl);
        this.upButton.setEnabled(bl && bl2);
        this.downButton.setEnabled(bl && bl3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ObjectLabelProvider
    extends LabelProvider {
        private boolean useImages;

        public ObjectLabelProvider(boolean bl) {
            this.useImages = bl;
        }

        public Image getImage(Object object) {
            IWorkbenchAdapter iWorkbenchAdapter;
            if (!this.useImages || object == null) {
                return null;
            }
            if (object instanceof CFGArtifact) {
                return TestUIImages.INSTANCE.getImage("artifact_obj.gif");
            }
            if (object instanceof CFGLocation) {
                return TestUIImages.INSTANCE.getImage("location_obj.gif");
            }
            if (object instanceof IAdaptable && (iWorkbenchAdapter = (IWorkbenchAdapter)((IAdaptable)object).getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = DeploymentObjectPage.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) != null) {
                return iWorkbenchAdapter.getImageDescriptor(object).createImage();
            }
            return null;
        }

        public String getText(Object object) {
            IWorkbenchAdapter iWorkbenchAdapter;
            if (object == null) {
                return "";
            }
            String string = null;
            if (object instanceof CFGArtifact) {
                string = ((CFGArtifact)object).getName();
            } else if (object instanceof CFGLocation) {
                string = ((CFGLocation)object).getName();
            } else if (object instanceof IAdaptable && (iWorkbenchAdapter = (IWorkbenchAdapter)((IAdaptable)object).getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = DeploymentObjectPage.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) != null) {
                string = iWorkbenchAdapter.getLabel(object);
            }
            if (string == null) {
                string = object.toString();
            }
            return string;
        }

        public void dispose() {
            super.dispose();
        }
    }

    private class ObjectContentProvider
    implements ITreeContentProvider {
        private ArrayList list = new ArrayList();

        public void dispose() {
            this.list.clear();
        }

        public Object[] getChildren(Object object) {
            return null;
        }

        public Object getParent(Object object) {
            return null;
        }

        public boolean hasChildren(Object object) {
            return false;
        }

        public Object[] getElements(Object object) {
            Object[] objectArray = new Object[]{};
            if (object == null) {
                return objectArray;
            }
            if (object instanceof EList) {
                int n = ((EList)object).size();
                objectArray = new Object[n];
                int n2 = 0;
                while (n2 < n) {
                    objectArray[n2] = ((EList)object).get(n2);
                    ++n2;
                }
            }
            return objectArray;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }
}

