/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.launch.delegates;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.ui.internal.launch.processes.TestExecutionProcess;
import org.eclipse.hyades.test.ui.launch.extensions.IRunHandler;

public abstract class AbstractLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    private List problems;

    protected abstract Object getLaunchedElement(ILaunchConfiguration var1) throws CoreException;

    protected void validate(ILaunchConfiguration iLaunchConfiguration, String string) throws CoreException {
        Object object = this.getLaunchedElement(iLaunchConfiguration);
        if (object == null) {
            this.reportProblem("The configuration does not provide a Launchable Test Element");
        }
    }

    protected abstract IExecutor invokeTestExecutionHarness(ILaunchConfiguration var1, String var2, StringBuffer var3) throws CoreException;

    protected void reportProblem(String string) {
        this.problems.add(string);
    }

    protected void resetFields() {
        this.problems = new ArrayList();
    }

    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        this.resetFields();
        this.validate(iLaunchConfiguration, string);
        if (this.problems.size() > 0) {
            MultiStatus multiStatus = new MultiStatus(TestUIPlugin.getID(), 0, TestUIPlugin.getString("AbstractLaunchConfigurationDelegate.configurationProblems"), null);
            Iterator iterator = this.problems.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Status status = new Status(4, TestUIPlugin.getID(), 0, string2, null);
                multiStatus.add((IStatus)status);
            }
            throw new CoreException((IStatus)multiStatus);
        }
        IRunHandler iRunHandler = LaunchConfigurationExtensionsManager.getInstance().getRunHandler(this.getLaunchedElement(iLaunchConfiguration));
        if (iRunHandler != null) {
            try {
                iRunHandler.preRun(iLaunchConfiguration, string, iLaunch, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
            catch (Throwable throwable) {
                Status status = new Status(4, TestUIPlugin.getID(), 0, TestUIPlugin.getString("AbstractLaunchConfigurationDelegate.preRunHandlerException"), throwable);
                throw new CoreException((IStatus)status);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        IExecutor iExecutor = this.invokeTestExecutionHarness(iLaunchConfiguration, string, stringBuffer);
        if (stringBuffer.length() > 0) {
            Status status = new Status(4, TestUIPlugin.getID(), 0, TestUIPlugin.getString("AbstractLaunchConfigurationDelegate.testHarnessProblems") + stringBuffer, null);
            throw new CoreException((IStatus)status);
        }
        if (iExecutor != null) {
            iLaunch.addProcess((IProcess)new TestExecutionProcess(iExecutor, iLaunch));
        }
    }
}

