/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil;
import org.eclipse.hyades.models.common.interactions.BVRProperty;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.impl.TPFBehaviorImpl;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ArtifactUtil {
    public static final String PROPERTY_NAME_CLASSPATH = Common_ConfigurationFactory.eINSTANCE.createHyadesClasspathCategory().getName();

    public static void associateTestAsset(CFGClass cFGClass, CFGArtifact cFGArtifact) {
        if (!ConfigurationUtil.containsById((List)cFGArtifact.getDeployableInstances(), (CMNNamedElement)cFGClass)) {
            cFGArtifact.getDeployableInstances().add((Object)cFGClass);
        }
        if (cFGClass instanceof TPFTestSuite) {
            ArtifactUtil.calculateClasspath((TPFTestSuite)cFGClass, cFGArtifact);
        }
    }

    public static void calculateClasspath(TPFTestSuite tPFTestSuite, CFGArtifact cFGArtifact) {
        CFGPropertyGroup cFGPropertyGroup = ConfigurationUtil.searchPropertyGroupById((List)cFGArtifact.getPropertyGroups(), (String)"org.eclipse.hyades.test.configuration.artifact.attributes");
        if (cFGPropertyGroup == null) {
            cFGPropertyGroup = Common_ConfigurationFactory.eINSTANCE.createCFGPropertyGroup();
            cFGPropertyGroup.setPropertyGroupID("org.eclipse.hyades.test.configuration.artifact.attributes");
            cFGArtifact.getPropertyGroups().add((Object)cFGPropertyGroup);
        }
        if (tPFTestSuite.getBehavior() == null || ((TPFBehaviorImpl)tPFTestSuite.getBehavior()).getProject() == null) {
            return;
        }
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(((TPFBehaviorImpl)tPFTestSuite.getBehavior()).getProject());
        if (iProject == null || !iProject.exists()) {
            return;
        }
        String[] stringArray = ArtifactUtil.getProjectClasspath(iProject, false);
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            if (ArtifactUtil.addClasspathEntry(stringArray[n])) {
                BVRProperty[] bVRPropertyArray = ConfigurationUtil.searchPropertiesByName((List)cFGPropertyGroup.getProperties(), (String)PROPERTY_NAME_CLASSPATH, (boolean)false);
                boolean bl = false;
                int n3 = 0;
                while (n3 < bVRPropertyArray.length) {
                    if (stringArray[n].equals(bVRPropertyArray[n3].getValue())) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl) {
                    CFGComparableProperty cFGComparableProperty = Common_ConfigurationFactory.eINSTANCE.createCFGComparableProperty();
                    cFGComparableProperty.setName(PROPERTY_NAME_CLASSPATH);
                    cFGComparableProperty.setOperator("=");
                    cFGComparableProperty.setValue(stringArray[n]);
                    cFGPropertyGroup.getProperties().add((Object)cFGComparableProperty);
                }
            }
            ++n;
        }
    }

    protected static boolean addClasspathEntry(String string) {
        if (string.indexOf("junit.jar") > 0) {
            return false;
        }
        if (string.indexOf("xercesImpl.jar") > 0) {
            return false;
        }
        if (string.indexOf("xmlParserAPIs.jar") > 0) {
            return false;
        }
        if (string.indexOf("hexr.jar") > 0) {
            return false;
        }
        if (string.indexOf("hexcore.jar") > 0) {
            return false;
        }
        if (string.indexOf("common.runner.jar") > 0) {
            return false;
        }
        if (string.indexOf("java.runner.jar") > 0) {
            return false;
        }
        if (string.indexOf("http.runner.jar") > 0) {
            return false;
        }
        return string.indexOf("manual.runner.jar") <= 0;
    }

    public static String[] getProjectClasspath(IProject iProject, boolean bl) {
        Object object;
        if (iProject == null) {
            return new String[0];
        }
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        if (iJavaProject == null) {
            return new String[0];
        }
        ArrayList<IClasspathEntry> arrayList = null;
        try {
            arrayList = new ArrayList<IClasspathEntry>(Arrays.asList(iJavaProject.getRawClasspath()));
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (arrayList == null || arrayList.isEmpty()) {
            return new String[0];
        }
        HashSet<String> hashSet = new HashSet<String>(arrayList.size());
        try {
            object = iJavaProject.getOutputLocation();
            if (object != null) {
                hashSet.add(ArtifactUtil.getFullPath((IPath)object));
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            IClasspathEntry iClasspathEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)((IClasspathEntry)object.next()));
            if (bl && !iClasspathEntry.isExported()) continue;
            String string = null;
            switch (iClasspathEntry.getEntryKind()) {
                case 1: 
                case 4: {
                    string = ArtifactUtil.getFullPath(iClasspathEntry.getPath());
                    if (string == null) break;
                    hashSet.add(string);
                    break;
                }
                case 2: {
                    IPath iPath = iClasspathEntry.getPath().makeAbsolute();
                    IProject iProject2 = ResourcesPlugin.getWorkspace().getRoot().getProject(iPath.toString());
                    hashSet.addAll(Arrays.asList(ArtifactUtil.getProjectClasspath(iProject2, true)));
                    break;
                }
                case 5: {
                    break;
                }
                case 3: {
                    string = ArtifactUtil.getFullPath(iClasspathEntry.getOutputLocation());
                    if (string == null) break;
                    hashSet.add(string);
                }
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    private static String getFullPath(IPath iPath) {
        if (iPath == null) {
            return null;
        }
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath.makeAbsolute());
        if (iResource != null) {
            iPath = iResource.getLocation().makeAbsolute();
        }
        return iPath.toString();
    }
}

