/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.util;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil;
import org.eclipse.hyades.models.common.interactions.BVRProperty;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.ui.PartInitException;

public class LocationUtil {
    public static final String PROPERTY_NAME_ROOTDIR = Common_ConfigurationFactory.eINSTANCE.createHyadesRootDirectroyCategory().getName();

    public static void createNew(IFile iFile, String string, String string2, String string3) throws Exception {
        Resource resource = LocationUtil.createResource(iFile);
        CFGLocation cFGLocation = LocationUtil.createLocation(string, string2, string3);
        resource.getContents().add((Object)cFGLocation);
        EMFUtil.save(resource);
    }

    public static CFGLocation createLocation(String string, String string2, String string3) {
        CFGLocation cFGLocation = ConfigurationUtil.createLocation((String)string, (String)string2, (String)string3);
        LocationUtil.setLocationRootDir(cFGLocation);
        return cFGLocation;
    }

    public static Resource createResource(IFile iFile) {
        URI uRI = URI.createPlatformResourceURI((String)iFile.getFullPath().toString());
        Resource.Factory factory = EMFUtil.getResourceFactory("location");
        return factory.createResource(uRI);
    }

    public static String getFileExtension() {
        return "location";
    }

    public static void openEditor(IFile iFile) throws PartInitException {
        if (!iFile.getFileExtension().equals(LocationUtil.getFileExtension())) {
            return;
        }
        if (TestUIPlugin.getInstance().getPreferenceStore().getBoolean("openEditor")) {
            UIUtil.openEditor((IFile)iFile, (String)"org.eclipse.hyades.test.ui.editor.LocationEditorPart", (boolean)false);
        }
    }

    public static void setLocationRootDir(CFGLocation cFGLocation) {
        CFGPropertyGroup cFGPropertyGroup = ConfigurationUtil.searchPropertyGroupById((List)cFGLocation.getPropertyGroups(), (String)"org.eclipse.hyades.test.configuration.location.attributes");
        if (cFGPropertyGroup == null) {
            cFGPropertyGroup = Common_ConfigurationFactory.eINSTANCE.createCFGPropertyGroup();
            cFGPropertyGroup.setPropertyGroupID("org.eclipse.hyades.test.configuration.location.attributes");
            cFGLocation.getPropertyGroups().add((Object)cFGPropertyGroup);
        }
        BVRProperty[] bVRPropertyArray = ConfigurationUtil.searchPropertiesByName((List)cFGPropertyGroup.getProperties(), (String)PROPERTY_NAME_ROOTDIR, (boolean)false);
        CFGComparableProperty cFGComparableProperty = null;
        if (bVRPropertyArray == null || bVRPropertyArray.length < 1) {
            cFGComparableProperty = Common_ConfigurationFactory.eINSTANCE.createCFGComparableProperty();
            cFGComparableProperty.setName(PROPERTY_NAME_ROOTDIR);
            cFGComparableProperty.setOperator("=");
            cFGPropertyGroup.getProperties().add((Object)cFGComparableProperty);
        } else {
            cFGComparableProperty = (CFGComparableProperty)bVRPropertyArray[0];
        }
        if (cFGComparableProperty.getValue() == null) {
            String string = LocationUtil.getWorkspaceRootDir();
            cFGComparableProperty.setValue(string);
        }
    }

    protected static String getWorkspaceRootDir() {
        String string = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        if (string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - File.separator.length());
        }
        return string;
    }
}

